# WordPress MySQL database migration
#
# Generated: Friday 6. November 2015 15:27 UTC
# Hostname: localhost
# Database: `micronics`
# --------------------------------------------------------

/*!40101 SET NAMES utf8 */;

SET sql_mode='NO_AUTO_VALUE_ON_ZERO';



#
# Delete any existing table `wp_commentmeta`
#

DROP TABLE IF EXISTS `wp_commentmeta`;


#
# Table structure of table `wp_commentmeta`
#

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


#
# Data contents of table `wp_commentmeta`
#

#
# End of data contents of table `wp_commentmeta`
# --------------------------------------------------------



#
# Delete any existing table `wp_comments`
#

DROP TABLE IF EXISTS `wp_comments`;


#
# Table structure of table `wp_comments`
#

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


#
# Data contents of table `wp_comments`
#

#
# End of data contents of table `wp_comments`
# --------------------------------------------------------



#
# Delete any existing table `wp_links`
#

DROP TABLE IF EXISTS `wp_links`;


#
# Table structure of table `wp_links`
#

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


#
# Data contents of table `wp_links`
#

#
# End of data contents of table `wp_links`
# --------------------------------------------------------



#
# Delete any existing table `wp_masterslider_options`
#

DROP TABLE IF EXISTS `wp_masterslider_options`;


#
# Table structure of table `wp_masterslider_options`
#

CREATE TABLE `wp_masterslider_options` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(120) COLLATE utf8_unicode_ci NOT NULL,
  `option_value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


#
# Data contents of table `wp_masterslider_options`
#
INSERT INTO `wp_masterslider_options` ( `ID`, `option_name`, `option_value`) VALUES
(1, 'preset_effect', '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'),
(2, 'buttons_style', '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'),
(3, 'masterslider_custom_css_ver', '1.5'),
(4, 'preset_style', 'eyJtZXRhIjp7fX0='),
(5, 'buttons_css', '.msp-preset-btn-84{ background-color: #b97ebb;color: #fff; } .msp-preset-btn-84:hover{ background-color:#ca89cc;color: #fff; } .msp-preset-btn-84:active{ top:1px } .msp-preset-btn-85{ background-color: #b97ebb;color: #fff; } .msp-preset-btn-85:hover{ background-color:#ca89cc;color: #fff; } .msp-preset-btn-85:active{ top:1px } .msp-preset-btn-86{ color: #b97ebb;border:solid 1px #b97ebb; } .msp-preset-btn-86:hover{ border-color:#ca89cc;color:#ca89cc } .msp-preset-btn-86:active{ top:1px } .msp-preset-btn-87{ background-color: #b97ebb;color: #fff; } .msp-preset-btn-87:hover{ background-color:#ca89cc;color: #fff; } .msp-preset-btn-87:active{ top:1px } .msp-preset-btn-88{ background-color: #b97ebb;color: #fff;box-shadow:0 5px #9a699c; } .msp-preset-btn-88:hover{ background-color:#ca89cc;box-shadow:0 4px #9a699c;top:1px;color: #fff; } .msp-preset-btn-88:active{ box-shadow:0 2px #9a699c;top:3px; } .msp-preset-btn-89{ background-color: #5472D2;color: #fff; } .msp-preset-btn-89:hover{ background-color:#5d7fe9;color: #fff; } .msp-preset-btn-89:active{ top:1px } .msp-preset-btn-90{ background-color: #5472D2;color: #fff; } .msp-preset-btn-90:hover{ background-color:#5d7fe9;color: #fff; } .msp-preset-btn-90:active{ top:1px } .msp-preset-btn-91{ color: #5472D2;border:solid 1px #5472D2; } .msp-preset-btn-91:hover{ border-color:#5d7fe9;color:#5d7fe9 } .msp-preset-btn-91:active{ top:1px } .msp-preset-btn-92{ background-color: #5472D2;color: #fff; } .msp-preset-btn-92:hover{ background-color:#5d7fe9;color: #fff; } .msp-preset-btn-92:active{ top:1px } .msp-preset-btn-93{ background-color: #5472D2;color: #fff;box-shadow:0 5px #4c68be; } .msp-preset-btn-93:hover{ background-color:#5d7fe9;box-shadow:0 4px #4c68be;top:1px;color: #fff; } .msp-preset-btn-93:active{ box-shadow:0 2px #4c68be;top:3px; } .msp-preset-btn-94{ background-color: #00c1cf;color: #fff; } .msp-preset-btn-94:hover{ background-color:#01D4E4;color: #fff; } .msp-preset-btn-94:active{ top:1px } .msp-preset-btn-95{ background-color: #00c1cf;color: #fff; } .msp-preset-btn-95:hover{ background-color:#01D4E4;color: #fff; } .msp-preset-btn-95:active{ top:1px } .msp-preset-btn-96{ color: #00c1cf;border:solid 1px #00c1cf; } .msp-preset-btn-96:hover{ border-color:#01D4E4;color:#01D4E4 } .msp-preset-btn-96:active{ top:1px } .msp-preset-btn-97{ background-color: #00c1cf;color: #fff; } .msp-preset-btn-97:hover{ background-color:#01D4E4;color: #fff; } .msp-preset-btn-97:active{ top:1px } .msp-preset-btn-98{ background-color: #00c1cf;color: #fff;box-shadow:0 5px #00afbc; } .msp-preset-btn-98:hover{ background-color:#01D4E4;box-shadow:0 4px #00afbc;top:1px;color: #fff; } .msp-preset-btn-98:active{ box-shadow:0 2px #00afbc;top:3px; } .msp-preset-btn-99{ background-color: #4cadc9;color: #fff; } .msp-preset-btn-99:hover{ background-color:#63b2c9;color: #fff; } .msp-preset-btn-99:active{ top:1px } .msp-preset-btn-100{ background-color: #4cadc9;color: #fff; } .msp-preset-btn-100:hover{ background-color:#63b2c9;color: #fff; } .msp-preset-btn-100:active{ top:1px } .msp-preset-btn-101{ color: #4cadc9;border:solid 1px #4cadc9; } .msp-preset-btn-101:hover{ border-color:#63b2c9;color:#63b2c9 } .msp-preset-btn-101:active{ top:1px } .msp-preset-btn-102{ background-color: #4cadc9;color: #fff; } .msp-preset-btn-102:hover{ background-color:#63b2c9;color: #fff; } .msp-preset-btn-102:active{ top:1px } .msp-preset-btn-103{ background-color: #4cadc9;color: #fff;box-shadow:0 5px #1aa2c9; } .msp-preset-btn-103:hover{ background-color:#63b2c9;box-shadow:0 4px #1aa2c9;top:1px;color: #fff; } .msp-preset-btn-103:active{ box-shadow:0 2px #1aa2c9;top:3px; } .msp-preset-btn-104{ background-color: #cec2ab;color: #fff; } .msp-preset-btn-104:hover{ background-color:#cebd9d;color: #fff; } .msp-preset-btn-104:active{ top:1px } .msp-preset-btn-105{ background-color: #cec2ab;color: #fff; } .msp-preset-btn-105:hover{ background-color:#cebd9d;color: #fff; } .msp-preset-btn-105:active{ top:1px } .msp-preset-btn-106{ color: #cec2ab;border:solid 1px #cec2ab; } .msp-preset-btn-106:hover{ border-color:#cebd9d;color:#cebd9d } .msp-preset-btn-106:active{ top:1px } .msp-preset-btn-107{ background-color: #cec2ab;color: #fff; } .msp-preset-btn-107:hover{ background-color:#cebd9d;color: #fff; } .msp-preset-btn-107:active{ top:1px } .msp-preset-btn-108{ background-color: #cec2ab;color: #fff;box-shadow:0 5px #C2B7A2; } .msp-preset-btn-108:hover{ background-color:#cebd9d;box-shadow:0 4px #C2B7A2;top:1px;color: #fff; } .msp-preset-btn-108:active{ box-shadow:0 2px #C2B7A2;top:3px; } .msp-preset-btn-109{ background-color: #50485b;color: #fff; } .msp-preset-btn-109:hover{ background-color:#6a6176;color: #fff; } .msp-preset-btn-109:active{ top:1px } .msp-preset-btn-110{ background-color: #50485b;color: #fff; } .msp-preset-btn-110:hover{ background-color:#6a6176;color: #fff; } .msp-preset-btn-110:active{ top:1px } .msp-preset-btn-111{ color: #50485b;border:solid 1px #50485b; } .msp-preset-btn-111:hover{ border-color:#6a6176;color:#6a6176 } .msp-preset-btn-111:active{ top:1px } .msp-preset-btn-112{ background-color: #50485b;color: #fff; } .msp-preset-btn-112:hover{ background-color:#6a6176;color: #fff; } .msp-preset-btn-112:active{ top:1px } .msp-preset-btn-113{ background-color: #50485b;color: #fff;box-shadow:0 5px #412d5b; } .msp-preset-btn-113:hover{ background-color:#6a6176;box-shadow:0 4px #412d5b;top:1px;color: #fff; } .msp-preset-btn-113:active{ box-shadow:0 2px #412d5b;top:3px; } .msp-preset-btn-114{ background-color: #8d6dc4;color: #fff; } .msp-preset-btn-114:hover{ background-color:#977cc4;color: #fff; } .msp-preset-btn-114:active{ top:1px } .msp-preset-btn-115{ background-color: #8d6dc4;color: #fff; } .msp-preset-btn-115:hover{ background-color:#977cc4;color: #fff; } .msp-preset-btn-115:active{ top:1px } .msp-preset-btn-116{ color: #8d6dc4;border:solid 1px #8d6dc4; } .msp-preset-btn-116:hover{ border-color:#977cc4;color:#977cc4 } .msp-preset-btn-116:active{ top:1px } .msp-preset-btn-117{ background-color: #8d6dc4;color: #fff; } .msp-preset-btn-117:hover{ background-color:#977cc4;color: #fff; } .msp-preset-btn-117:active{ top:1px } .msp-preset-btn-118{ background-color: #8d6dc4;color: #fff;box-shadow:0 5px #7c51c4; } .msp-preset-btn-118:hover{ background-color:#977cc4;box-shadow:0 4px #7c51c4;top:1px;color: #fff; } .msp-preset-btn-118:active{ box-shadow:0 2px #7c51c4;top:3px; } .msp-preset-btn-119{ background-color: #75d69c;color: #fff; } .msp-preset-btn-119:hover{ background-color:#7de5a7;color: #fff; } .msp-preset-btn-119:active{ top:1px } .msp-preset-btn-120{ background-color: #75d69c;color: #fff; } .msp-preset-btn-120:hover{ background-color:#7de5a7;color: #fff; } .msp-preset-btn-120:active{ top:1px } .msp-preset-btn-121{ color: #75d69c;border:solid 1px #75d69c; } .msp-preset-btn-121:hover{ border-color:#7de5a7;color:#7de5a7 } .msp-preset-btn-121:active{ top:1px } .msp-preset-btn-122{ background-color: #75d69c;color: #fff; } .msp-preset-btn-122:hover{ background-color:#7de5a7;color: #fff; } .msp-preset-btn-122:active{ top:1px } .msp-preset-btn-123{ background-color: #75d69c;color: #fff;box-shadow:0 5px #41d67d; } .msp-preset-btn-123:hover{ background-color:#7de5a7;box-shadow:0 4px #41d67d;top:1px;color: #fff; } .msp-preset-btn-123:active{ box-shadow:0 2px #41d67d;top:3px; } .msp-preset-btn-124{ background-color: #222;color: #fff; } .msp-preset-btn-124:hover{ background-color:#333;color: #fff; } .msp-preset-btn-124:active{ top:1px } .msp-preset-btn-125{ background-color: #222;color: #fff; } .msp-preset-btn-125:hover{ background-color:#333;color: #fff; } .msp-preset-btn-125:active{ top:1px } .msp-preset-btn-126{ color: #222;border:solid 1px #222; } .msp-preset-btn-126:hover{ border-color:#333;color:#333 } .msp-preset-btn-126:active{ top:1px } .msp-preset-btn-127{ background-color: #222;color: #fff; } .msp-preset-btn-127:hover{ background-color:#333;color: #fff; } .msp-preset-btn-127:active{ top:1px } .msp-preset-btn-128{ background-color: #222;color: #fff;box-shadow:0 5px #000; } .msp-preset-btn-128:hover{ background-color:#333;box-shadow:0 4px #000;top:1px;color: #fff; } .msp-preset-btn-128:active{ box-shadow:0 2px #000;top:3px; } .msp-preset-btn-129{ background-color: #dedede;color: #666; } .msp-preset-btn-129:hover{ background-color:#d1d1d1;color: #666; } .msp-preset-btn-129:active{ top:1px } .msp-preset-btn-130{ background-color: #dedede;color: #666; } .msp-preset-btn-130:hover{ background-color:#d1d1d1;color: #666; } .msp-preset-btn-130:active{ top:1px } .msp-preset-btn-131{ color: #dedede;border:solid 1px #dedede; } .msp-preset-btn-131:hover{ border-color:#d1d1d1;color:#d1d1d1 } .msp-preset-btn-131:active{ top:1px } .msp-preset-btn-132{ background-color: #dedede;color: #666; } .msp-preset-btn-132:hover{ background-color:#d1d1d1;color: #666; } .msp-preset-btn-132:active{ top:1px } .msp-preset-btn-133{ background-color: #dedede;color: #666;box-shadow:0 5px #CACACA; } .msp-preset-btn-133:hover{ background-color:#d1d1d1;color: #666;box-shadow:0 4px #CACACA;top:1px } .msp-preset-btn-133:active{ box-shadow:0 2px #CACACA;top:3px; } .msp-preset-btn-134{ background-color: #f7be68;color: #fff; } .msp-preset-btn-134:hover{ background-color:#e9b362;color: #fff; } .msp-preset-btn-134:active{ top:1px } .msp-preset-btn-135{ background-color: #f7be68;color: #fff; } .msp-preset-btn-135:hover{ background-color:#e9b362;color: #fff; } .msp-preset-btn-135:active{ top:1px } .msp-preset-btn-136{ color: #f7be68;border:solid 1px #f7be68; } .msp-preset-btn-136:hover{ border-color:#e9b362;color:#e9b362 } .msp-preset-btn-136:active{ top:1px } .msp-preset-btn-137{ background-color: #f7be68;color: #fff; } .msp-preset-btn-137:hover{ background-color:#e9b362;color: #fff; } .msp-preset-btn-137:active{ top:1px } .msp-preset-btn-138{ background-color: #f7be68;color: #fff;box-shadow:0 5px #E7AF59; } .msp-preset-btn-138:hover{ background-color:#e9b362;box-shadow:0 4px #E7AF59;top:1px;color: #fff; } .msp-preset-btn-138:active{ box-shadow:0 2px #E7AF59;top:3px; } .msp-preset-btn-139{ background-color: #5aa1e3;color: #fff; } .msp-preset-btn-139:hover{ background-color:#5faaef;color: #fff; } .msp-preset-btn-139:active{ top:1px } .msp-preset-btn-140{ background-color: #5aa1e3;color: #fff; } .msp-preset-btn-140:hover{ background-color:#5faaef;color: #fff; } .msp-preset-btn-140:active{ top:1px } .msp-preset-btn-141{ color: #5aa1e3;border:solid 1px #5aa1e3; } .msp-preset-btn-141:hover{ border-color:#5faaef;color:#5faaef } .msp-preset-btn-141:active{ top:1px } .msp-preset-btn-142{ background-color: #5aa1e3;color: #fff; } .msp-preset-btn-142:hover{ background-color:#5faaef;color: #fff; } .msp-preset-btn-142:active{ top:1px } .msp-preset-btn-143{ background-color: #5aa1e3;color: #fff;box-shadow:0 5px #4c87bf; } .msp-preset-btn-143:hover{ background-color:#5faaef;box-shadow:0 4px #4c87bf;top:1px;color: #fff; } .msp-preset-btn-143:active{ box-shadow:0 2px #4c87bf;top:3px; } .msp-preset-btn-144{ background-color: #6dab3c;color: #fff; } .msp-preset-btn-144:hover{ background-color:#76b941;color: #fff; } .msp-preset-btn-144:active{ top:1px } .msp-preset-btn-145{ background-color: #6dab3c;color: #fff; } .msp-preset-btn-145:hover{ background-color:#76b941;color: #fff; } .msp-preset-btn-145:active{ top:1px } .msp-preset-btn-146{ color: #6dab3c;border:solid 1px #6dab3c; } .msp-preset-btn-146:hover{ border-color:#76b941;color:#76b941 } .msp-preset-btn-146:active{ top:1px } .msp-preset-btn-147{ background-color: #6dab3c;color: #fff; } .msp-preset-btn-147:hover{ background-color:#76b941;color: #fff; } .msp-preset-btn-147:active{ top:1px } .msp-preset-btn-148{ background-color: #6dab3c;color: #fff;box-shadow:0 5px #5e9334; } .msp-preset-btn-148:hover{ background-color:#76b941;box-shadow:0 4px #5e9334;top:1px;color: #fff; } .msp-preset-btn-148:active{ box-shadow:0 2px #5e9334;top:3px; } .msp-preset-btn-149{ background-color: #f4524d;color: #fff; } .msp-preset-btn-149:hover{ background-color:#e04b47;color: #fff; } .msp-preset-btn-149:active{ top:1px } .msp-preset-btn-150{ background-color: #f4524d;color: #fff; } .msp-preset-btn-150:hover{ background-color:#e04b47;color: #fff; } .msp-preset-btn-150:active{ top:1px } .msp-preset-btn-151{ color: #f4524d;border:solid 1px #f4524d; } .msp-preset-btn-151:hover{ border-color:#e04b47;color:#e04b47 } .msp-preset-btn-151:active{ top:1px } .msp-preset-btn-152{ background-color: #f4524d;color: #fff; } .msp-preset-btn-152:hover{ background-color:#e04b47;color: #fff; } .msp-preset-btn-152:active{ top:1px } .msp-preset-btn-153{ background-color: #f4524d;color: #fff;box-shadow:0 5px #cb4440; } .msp-preset-btn-153:hover{ background-color:#e04b47;box-shadow:0 4px #cb4440;top:1px;color: #fff; } .msp-preset-btn-153:active{ box-shadow:0 2px #cb4440;top:3px; } .msp-preset-btn-154{ background-color: #f79468;color: #fff; } .msp-preset-btn-154:hover{ background-color:#e78a61;color: #fff; } .msp-preset-btn-154:active{ top:1px } .msp-preset-btn-155{ background-color: #f79468;color: #fff; } .msp-preset-btn-155:hover{ background-color:#e78a61;color: #fff; } .msp-preset-btn-155:active{ top:1px } .msp-preset-btn-156{ color: #f79468;border:solid 1px #f79468; } .msp-preset-btn-156:hover{ border-color:#e78a61;color:#e78a61 } .msp-preset-btn-156:active{ top:1px } .msp-preset-btn-157{ background-color: #f79468;color: #fff; } .msp-preset-btn-157:hover{ background-color:#e78a61;color: #fff; } .msp-preset-btn-157:active{ top:1px } .msp-preset-btn-158{ background-color: #f79468;color: #fff;box-shadow:0 5px #da835c; } .msp-preset-btn-158:hover{ background-color:#e78a61;box-shadow:0 4px #da835c;top:1px;color: #fff; } .msp-preset-btn-158:active{ box-shadow:0 2px #da835c;top:3px; }') ;

#
# End of data contents of table `wp_masterslider_options`
# --------------------------------------------------------



#
# Delete any existing table `wp_masterslider_sliders`
#

DROP TABLE IF EXISTS `wp_masterslider_sliders`;


#
# Table structure of table `wp_masterslider_sliders`
#

CREATE TABLE `wp_masterslider_sliders` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `alias` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `slides_num` smallint(5) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `params` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `custom_styles` text COLLATE utf8_unicode_ci NOT NULL,
  `custom_fonts` text COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'draft',
  PRIMARY KEY (`ID`),
  KEY `date_created` (`date_created`),
  KEY `alias` (`alias`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


#
# Data contents of table `wp_masterslider_sliders`
#
INSERT INTO `wp_masterslider_sliders` ( `ID`, `title`, `alias`, `type`, `slides_num`, `date_created`, `date_modified`, `params`, `custom_styles`, `custom_fonts`, `status`) VALUES
(1, 'Untitled Slider', 'ms-1', 'custom', 0, '2015-11-04 10:24:05', '2015-11-04 10:24:05', 'a:0:{}', '', '', 'draft') ;

#
# End of data contents of table `wp_masterslider_sliders`
# --------------------------------------------------------



#
# Delete any existing table `wp_options`
#

DROP TABLE IF EXISTS `wp_options`;


#
# Table structure of table `wp_options`
#

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=454 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


#
# Data contents of table `wp_options`
#
INSERT INTO `wp_options` ( `option_id`, `option_name`, `option_value`, `autoload`) VALUES
(1, 'siteurl', 'http://micronics.votresitedemo.com', 'yes'),
(2, 'home', 'http://micronics.votresitedemo.com', 'yes'),
(3, 'blogname', 'Micronics Systems', 'yes'),
(4, 'blogdescription', 'Just another WordPress site', 'yes'),
(5, 'users_can_register', '0', 'yes'),
(6, 'admin_email', 'fd@mobi-pronet.com', 'yes'),
(7, 'start_of_week', '1', 'yes'),
(8, 'use_balanceTags', '0', 'yes'),
(9, 'use_smilies', '1', 'yes'),
(10, 'require_name_email', '1', 'yes'),
(11, 'comments_notify', '1', 'yes'),
(12, 'posts_per_rss', '10', 'yes'),
(13, 'rss_use_excerpt', '0', 'yes'),
(14, 'mailserver_url', 'mail.example.com', 'yes'),
(15, 'mailserver_login', 'login@example.com', 'yes'),
(16, 'mailserver_pass', 'password', 'yes'),
(17, 'mailserver_port', '110', 'yes'),
(18, 'default_category', '1', 'yes'),
(19, 'default_comment_status', 'open', 'yes'),
(20, 'default_ping_status', 'open', 'yes'),
(21, 'default_pingback_flag', '0', 'yes'),
(22, 'posts_per_page', '10', 'yes'),
(23, 'date_format', 'F j, Y', 'yes'),
(24, 'time_format', 'g:i a', 'yes'),
(25, 'links_updated_date_format', 'F j, Y g:i a', 'yes'),
(26, 'comment_moderation', '0', 'yes'),
(27, 'moderation_notify', '1', 'yes'),
(28, 'permalink_structure', '/%postname%/', 'yes'),
(29, 'gzipcompression', '0', 'yes'),
(30, 'hack_file', '0', 'yes'),
(31, 'blog_charset', 'UTF-8', 'yes'),
(32, 'moderation_keys', '', 'no'),
(33, 'active_plugins', 'a:9:{i:0;s:36:"contact-form-7/wp-contact-form-7.php";i:1;s:41:"envato-wordpress-toolkit-master/index.php";i:2;s:27:"js_composer/js_composer.php";i:3;s:37:"mailchimp-for-wp/mailchimp-for-wp.php";i:4;s:29:"masterslider/masterslider.php";i:5;s:51:"ozy-logistic-essentials/ozy-logistic-essentials.php";i:6;s:44:"widget-settings-importexport/widget-data.php";i:7;s:41:"wordpress-importer/wordpress-importer.php";i:8;s:31:"wp-migrate-db/wp-migrate-db.php";}', 'yes'),
(34, 'category_base', '', 'yes'),
(35, 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'),
(36, 'advanced_edit', '0', 'yes'),
(37, 'comment_max_links', '2', 'yes'),
(38, 'gmt_offset', '0', 'yes'),
(39, 'default_email_category', '1', 'yes'),
(40, 'recently_edited', '', 'no'),
(41, 'template', 'logistic', 'yes'),
(42, 'stylesheet', 'logistic-child', 'yes'),
(43, 'comment_whitelist', '1', 'yes'),
(44, 'blacklist_keys', '', 'no'),
(45, 'comment_registration', '0', 'yes'),
(46, 'html_type', 'text/html', 'yes'),
(47, 'use_trackback', '0', 'yes'),
(48, 'default_role', 'subscriber', 'yes'),
(49, 'db_version', '33056', 'yes'),
(50, 'uploads_use_yearmonth_folders', '1', 'yes'),
(51, 'upload_path', '', 'yes'),
(52, 'blog_public', '0', 'yes'),
(53, 'default_link_category', '2', 'yes'),
(54, 'show_on_front', 'page', 'yes'),
(55, 'tag_base', '', 'yes'),
(56, 'show_avatars', '1', 'yes'),
(57, 'avatar_rating', 'G', 'yes'),
(58, 'upload_url_path', '', 'yes'),
(59, 'thumbnail_size_w', '150', 'yes'),
(60, 'thumbnail_size_h', '150', 'yes'),
(61, 'thumbnail_crop', '1', 'yes'),
(62, 'medium_size_w', '300', 'yes'),
(63, 'medium_size_h', '300', 'yes'),
(64, 'avatar_default', 'mystery', 'yes'),
(65, 'large_size_w', '1024', 'yes'),
(66, 'large_size_h', '1024', 'yes'),
(67, 'image_default_link_type', 'file', 'yes'),
(68, 'image_default_size', '', 'yes'),
(69, 'image_default_align', '', 'yes'),
(70, 'close_comments_for_old_posts', '0', 'yes'),
(71, 'close_comments_days_old', '14', 'yes'),
(72, 'thread_comments', '1', 'yes'),
(73, 'thread_comments_depth', '5', 'yes'),
(74, 'page_comments', '0', 'yes'),
(75, 'comments_per_page', '50', 'yes'),
(76, 'default_comments_page', 'newest', 'yes'),
(77, 'comment_order', 'asc', 'yes'),
(78, 'sticky_posts', 'a:0:{}', 'yes'),
(79, 'widget_categories', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(80, 'widget_text', 'a:6:{i:1;a:0:{}i:2;a:3:{s:5:"title";s:16:"A PROPOS DE NOUS";s:4:"text";s:295:"<img src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/logo-white.png"><br>Logistic was founded to make a mark in London’s Clearing and Forwarding industry. Logistic started its operations in all the major cities in Europe with the aim to offer the best in logistics services.";s:6:"filter";b:1;}i:3;a:3:{s:5:"title";s:7:"CONTACT";s:4:"text";s:129:"<b>MICRONICS SYSTEMS - FRANCE</b>\r\nZA Rue des Emeraudes\r\nF-38280 Vilette d’Anthon\r\nTel +33 0) 472 930 480\r\ncontact@micronics.fr";s:6:"filter";b:1;}i:4;a:3:{s:5:"title";s:10:"NEWSLETTER";s:4:"text";s:12:"[mc4wp_form]";s:6:"filter";b:1;}i:5;a:3:{s:5:"title";s:13:"UNE QUESTION?";s:4:"text";s:158:"<img src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/operator1.png">\r\n<a href="http://micronics.votresitedemo.com/?p=54">Contactez-nous</a>";s:6:"filter";b:1;}s:12:"_multiwidget";i:1;}', 'yes'),
(81, 'widget_rss', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
(82, 'uninstall_plugins', 'a:0:{}', 'no'),
(83, 'timezone_string', '', 'yes'),
(84, 'page_for_posts', '0', 'yes'),
(85, 'page_on_front', '6', 'yes'),
(86, 'default_post_format', '0', 'yes'),
(87, 'link_manager_enabled', '0', 'yes'),
(88, 'finished_splitting_shared_terms', '1', 'yes'),
(89, 'initial_db_version', '33056', 'yes'),
(90, 'wp_user_roles', 'a:5:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:68:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:9:"add_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;s:19:"access_masterslider";b:1;s:20:"publish_masterslider";b:1;s:19:"delete_masterslider";b:1;s:19:"create_masterslider";b:1;s:19:"export_masterslider";b:1;s:22:"duplicate_masterslider";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:40:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:19:"access_masterslider";b:1;s:20:"publish_masterslider";b:1;s:19:"delete_masterslider";b:1;s:19:"create_masterslider";b:1;s:19:"export_masterslider";b:1;s:22:"duplicate_masterslider";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:10:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:5:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}}', 'yes'),
(91, 'widget_search', 'a:2:{i:2;a:1:{s:5:"title";s:0:"";}s:12:"_multiwidget";i:1;}', 'yes'),
(92, 'widget_recent-posts', 'a:2:{i:2;a:3:{s:5:"title";s:0:"";s:6:"number";i:5;s:9:"show_date";b:0;}s:12:"_multiwidget";i:1;}', 'yes'),
(93, 'widget_recent-comments', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(94, 'widget_archives', 'a:2:{i:2;a:3:{s:5:"title";s:0:"";s:5:"count";i:0;s:8:"dropdown";i:0;}s:12:"_multiwidget";i:1;}', 'yes'),
(95, 'widget_meta', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
(96, 'sidebars_widgets', 'a:8:{s:19:"wp_inactive_widgets";a:0:{}s:25:"ozy-footer-widget-bar-one";a:1:{i:0;s:6:"text-2";}s:25:"ozy-footer-widget-bar-two";a:1:{i:0;s:10:"nav_menu-2";}s:27:"ozy-footer-widget-bar-three";a:1:{i:0;s:10:"nav_menu-3";}s:26:"ozy-footer-widget-bar-four";a:2:{i:0;s:6:"text-3";i:1;s:6:"text-4";}s:12:"blog-sidebar";a:3:{i:0;s:8:"search-2";i:1;s:14:"recent-posts-2";i:2;s:10:"archives-2";}s:16:"produits-sidebar";a:2:{i:0;s:10:"nav_menu-5";i:1;s:6:"text-5";}s:13:"array_version";i:3;}', 'yes'),
(99, 'cron', 'a:5:{i:1446836460;a:1:{s:20:"wp_maybe_auto_update";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1446860379;a:3:{s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1446882897;a:1:{s:30:"wp_scheduled_auto_draft_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1446903589;a:1:{s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}s:7:"version";i:2;}', 'yes'),
(114, 'can_compress_scripts', '0', 'yes'),
(131, 'theme_mods_twentyfifteen', 'a:1:{s:16:"sidebars_widgets";a:2:{s:4:"time";i:1446558370;s:4:"data";a:2:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:6:{i:0;s:8:"search-2";i:1;s:14:"recent-posts-2";i:2;s:17:"recent-comments-2";i:3;s:10:"archives-2";i:4;s:12:"categories-2";i:5;s:6:"meta-2";}}}}', 'yes'),
(132, 'current_theme', 'Logistic - Child', 'yes') ;
INSERT INTO `wp_options` ( `option_id`, `option_name`, `option_value`, `autoload`) VALUES
(133, 'theme_mods_logistic-child', 'a:2:{i:0;b:0;s:18:"nav_menu_locations";a:2:{s:11:"header-menu";i:4;s:14:"logged-in-menu";i:4;}}', 'yes'),
(134, 'theme_switched', '', 'yes'),
(135, 'vpt_ozy_logistic_option', 'a:147:{s:31:"ozy_logistic_back_to_top_button";s:1:"1";s:20:"ozy_logistic_favicon";s:78:"http://micronics.votresitedemo.com/wp-content/themes/logistic-child/favico.png";s:32:"ozy_logistic_favicon_apple_small";s:88:"http://micronics.votresitedemo.com/wp-content/themes/logistic-child/images/favico_57.png";s:33:"ozy_logistic_favicon_apple_medium";s:88:"http://micronics.votresitedemo.com/wp-content/themes/logistic-child/images/favico_76.png";s:32:"ozy_logistic_favicon_apple_large";s:89:"http://micronics.votresitedemo.com/wp-content/themes/logistic-child/images/favico_120.png";s:33:"ozy_logistic_favicon_apple_xlarge";s:89:"http://micronics.votresitedemo.com/wp-content/themes/logistic-child/images/favico_152.png";s:23:"ozy_logistic_custom_css";s:1578:"ul#menu-primary-menu li :hover {\n    background:#0a0912;\n    border-radius:30px;\n}\n\n#top-menu>ul>li.active {\n    background:#0a0912;\n    border-radius:30px;\n}\n\n#top-menu .menu-item-search:last-child :hover {\n    background:#ffffff;\n    border-radius:30px;\n    color: #2f2f34;\n}\n\n#footer-widget-bar .widget-area h4, #sidebar .widget>h4 {\n    font-family:"Hind-Bold" !important;\n    font-size: 20px !important;\n}\n\n#footer a, #footer-widget-bar a {\n    font-family:"Hind-Regular" !important;\n    font-size: 13px !important;\n}\n\n#footer-widget-bar *:not(input) {\n    font-family:"Hind-Regular" !important;\n    font-size: 13px !important;\n}\n\n#footer *:not(input) {\n    font-size: 13px !important; \n}\n\ninput[type=\'email\'] {\n    display: inline;\n    float: left;\n    border-bottom-right-radius: 0;\n    border-top-right-radius: 0;\n    width: 70%;\n    padding-left: 10px;\n}\n\ninput[type=\'submit\'] {\n    display: inline;\n    float: right;\n    width: 30%;\n    border-bottom-left-radius: 0 !important;\n    border-top-left-radius: 0 !important;\n    position: absolute;\n    right: 10px;\n    padding-left: 10px;\n}\n\n#wpcf7-f4-p54-o1 input[type=\'submit\'] {\n    display: inline;\n    float: left;\n    width: 30%;\n    border-bottom-left-radius: 30px !important;\n    border-top-left-radius: 30px !important;\n    position: relative;\n    right: 10px;\n    padding-left: 35px;\n}\n\n\n\nbody.ozy-page-model-boxed #header, .ozy-page-model-boxed #main {\n    max-width: 1440px;\n}\n\n@media only screen and (min-width: 1212px) {\n.container {\n    padding: 0;\n    width: 100%;\n}\n}\n\n#footer {\n    background :#0a0912;\n}";s:26:"ozy_logistic_custom_script";s:0:"";s:36:"ozy_logistic_typography_google_param";s:36:":100,200,300,400,500,600,700,800,900";s:36:"ozy_logistic_typography_font_preview";s:247:"<link href=\'\' rel=\'stylesheet\' type=\'text/css\'>\n<p style="padding: 0 10px 0 10px;font-family: ___Hind-Regular;font-style: normal;font-weight: 400;font-size: 14px;line-height: 1.5em">\n	Grumpy wizards make toxic brew for the evil Queen and Jack\n</p>";s:33:"ozy_logistic_typography_font_face";s:15:"___Hind-Regular";s:34:"ozy_logistic_typography_font_style";s:6:"normal";s:35:"ozy_logistic_typography_font_weight";s:3:"400";s:33:"ozy_logistic_typography_font_size";s:2:"14";s:40:"ozy_logistic_typography_font_line_height";s:3:"1.5";s:44:"ozy_logistic_typography_heading_font_preview";s:232:"<link href=\'\' rel=\'stylesheet\' type=\'text/css\'>\n<p style="padding: 0 10px 0 10px;font-family: ___Hind-Bold;font-style:;font-weight:;font-size: 26px;line-height: 33px">\n	Grumpy wizards make toxic brew for the evil Queen and Jack\n</p>";s:41:"ozy_logistic_typography_heading_font_face";s:12:"___Hind-Bold";s:44:"ozy_logistic_typography_heading_h1_font_size";s:2:"40";s:45:"ozy_logistic_typography_heading_h1_font_style";s:0:"";s:46:"ozy_logistic_typography_heading_font_weight_h1";s:3:"300";s:46:"ozy_logistic_typography_heading_line_height_h1";s:3:"1.5";s:42:"ozy_logistic_typography_heading_font_ls_h1";s:6:"normal";s:44:"ozy_logistic_typography_heading_h2_font_size";s:2:"30";s:45:"ozy_logistic_typography_heading_h2_font_style";s:0:"";s:46:"ozy_logistic_typography_heading_font_weight_h2";s:3:"500";s:46:"ozy_logistic_typography_heading_line_height_h2";s:3:"1.5";s:42:"ozy_logistic_typography_heading_font_ls_h2";s:6:"normal";s:44:"ozy_logistic_typography_heading_h3_font_size";s:2:"22";s:45:"ozy_logistic_typography_heading_h3_font_style";s:0:"";s:46:"ozy_logistic_typography_heading_font_weight_h3";s:3:"400";s:46:"ozy_logistic_typography_heading_line_height_h3";s:3:"1.5";s:42:"ozy_logistic_typography_heading_font_ls_h3";s:6:"normal";s:44:"ozy_logistic_typography_heading_h4_font_size";s:2:"18";s:45:"ozy_logistic_typography_heading_h4_font_style";s:0:"";s:46:"ozy_logistic_typography_heading_font_weight_h4";s:3:"700";s:46:"ozy_logistic_typography_heading_line_height_h4";s:3:"1.5";s:42:"ozy_logistic_typography_heading_font_ls_h4";s:6:"normal";s:44:"ozy_logistic_typography_heading_h5_font_size";s:2:"16";s:45:"ozy_logistic_typography_heading_h5_font_style";s:0:"";s:46:"ozy_logistic_typography_heading_font_weight_h5";s:3:"300";s:46:"ozy_logistic_typography_heading_line_height_h5";s:3:"1.5";s:42:"ozy_logistic_typography_heading_font_ls_h5";s:6:"normal";s:44:"ozy_logistic_typography_heading_h6_font_size";s:2:"12";s:45:"ozy_logistic_typography_heading_h6_font_style";s:0:"";s:46:"ozy_logistic_typography_heading_font_weight_h6";s:3:"300";s:46:"ozy_logistic_typography_heading_line_height_h6";s:3:"1.5";s:42:"ozy_logistic_typography_heading_font_ls_h6";s:6:"normal";s:46:"ozy_logistic_primary_menu_typography_font_face";s:16:"___Hind-Semibold";s:47:"ozy_logistic_primary_menu_typography_font_style";s:6:"normal";s:48:"ozy_logistic_primary_menu_typography_font_weight";s:0:"";s:46:"ozy_logistic_primary_menu_typography_font_size";s:2:"17";s:48:"ozy_logistic_primary_menu_typography_line_height";s:3:"1.5";s:32:"ozy_logistic_primary_sticky_menu";s:1:"1";s:32:"ozy_logistic_primary_menu_height";s:2:"80";s:32:"ozy_logistic_primary_menu_search";s:1:"1";s:31:"ozy_logistic_primary_menu_align";s:5:"right";s:28:"ozy_logistic_use_custom_logo";s:1:"1";s:24:"ozy_logistic_custom_logo";s:76:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/logo-black.png";s:31:"ozy_logistic_custom_logo_retina";s:0:"";s:42:"ozy_logistic_section_footer_copyright_text";s:40:"@2015 Micronics - Tous droits réservés";s:26:"ozy_logistic_footer_height";s:2:"56";s:23:"ozy_logistic_page_model";s:5:"boxed";s:29:"ozy_logistic_page_404_page_id";s:0:"";s:39:"ozy_logistic_page_page_sidebar_position";s:4:"full";s:33:"ozy_logistic_page_page_sidebar_id";s:0:"";s:30:"ozy_logistic_page_page_comment";s:0:"";s:29:"ozy_logistic_page_page_author";s:0:"";s:37:"ozy_logistic_page_page_comment_closed";s:0:"";s:28:"ozy_logistic_page_page_share";s:0:"";s:39:"ozy_logistic_page_blog_sidebar_position";s:5:"right";s:33:"ozy_logistic_page_blog_sidebar_id";s:12:"blog-sidebar";s:30:"ozy_logistic_page_blog_comment";s:1:"1";s:29:"ozy_logistic_page_blog_author";s:1:"1";s:28:"ozy_logistic_page_blog_share";s:1:"1";s:36:"ozy_logistic_page_blog_related_posts";s:1:"1";s:35:"ozy_logistic_page_blog_list_page_id";s:0:"";s:46:"ozy_logistic_page_woocommerce_sidebar_position";s:4:"left";s:40:"ozy_logistic_page_woocommerce_sidebar_id";s:16:"produits-sidebar";s:26:"ozy_logistic_fancbox_media";s:1:"1";s:30:"ozy_logistic_fancbox_thumbnail";s:0:"";s:27:"ozy_logistic_countdown_year";s:4:"2015";s:28:"ozy_logistic_countdown_month";s:2:"11";s:26:"ozy_logistic_countdown_day";s:2:"15";s:27:"ozy_logistic_countdown_hour";s:2:"12";s:29:"ozy_logistic_countdown_minute";s:2:"12";s:29:"ozy_logistic_countdown_second";s:2:"00";s:37:"ozy_logistic_content_background_color";s:19:"rgba(255,255,255,1)";s:26:"ozy_logistic_content_color";s:7:"#000000";s:36:"ozy_logistic_content_color_alternate";s:7:"#0267c1";s:37:"ozy_logistic_content_color_alternate2";s:7:"#000000";s:37:"ozy_logistic_content_color_alternate3";s:7:"#ffffff";s:47:"ozy_logistic_content_background_color_alternate";s:19:"rgba(240,240,240,1)";s:41:"ozy_logistic_primary_menu_separator_color";s:19:"rgba(240,240,240,1)";s:36:"ozy_logistic_primary_menu_logo_color";s:13:"rgba(0,0,0,1)";s:36:"ozy_logistic_primary_menu_font_color";s:15:"rgba(10,9,18,1)";s:42:"ozy_logistic_primary_menu_font_color_hover";s:19:"rgba(255,255,255,1)";s:42:"ozy_logistic_primary_menu_background_color";s:19:"rgba(255,255,255,1)";s:48:"ozy_logistic_primary_menu_background_color_hover";s:15:"rgba(10,9,18,1)";s:43:"ozy_logistic_primary_menu_separator_color_2";s:19:"rgba(235,235,235,1)";s:36:"ozy_logistic_footer_background_image";s:0:"";s:27:"ozy_logistic_footer_color_1";s:16:"rgba(47,47,52,1)";s:27:"ozy_logistic_footer_color_2";s:7:"#ffffff";s:27:"ozy_logistic_footer_color_3";s:7:"#0267c1";s:27:"ozy_logistic_footer_color_4";s:7:"#2f323c";s:28:"ozy_logistic_form_font_color";s:16:"rgba(35,35,35,1)";s:34:"ozy_logistic_form_background_color";s:19:"rgba(255,255,255,1)";s:35:"ozy_logistic_form_button_font_color";s:19:"rgba(255,255,255,1)";s:41:"ozy_logistic_form_button_font_color_hover";s:19:"rgba(255,255,255,1)";s:41:"ozy_logistic_form_button_background_color";s:13:"rgba(0,0,0,1)";s:47:"ozy_logistic_form_button_background_color_hover";s:17:"rgba(2,103,193,1)";s:34:"ozy_logistic_body_background_color";s:7:"#000000";s:34:"ozy_logistic_body_background_image";s:0:"";s:39:"ozy_logistic_body_background_image_size";s:0:"";s:41:"ozy_logistic_body_background_image_repeat";s:7:"inherit";s:45:"ozy_logistic_body_background_image_attachment";s:0:"";s:42:"ozy_logistic_social_accounts_fivehundredpx";s:0:"";s:36:"ozy_logistic_social_accounts_behance";s:0:"";s:36:"ozy_logistic_social_accounts_blogger";s:0:"";s:38:"ozy_logistic_social_accounts_delicious";s:0:"";s:39:"ozy_logistic_social_accounts_deviantart";s:0:"";s:33:"ozy_logistic_social_accounts_digg";s:0:"";s:36:"ozy_logistic_social_accounts_dribble";s:0:"";s:34:"ozy_logistic_social_accounts_email";s:0:"";s:37:"ozy_logistic_social_accounts_facebook";s:0:"";s:35:"ozy_logistic_social_accounts_flickr";s:0:"";s:35:"ozy_logistic_social_accounts_forrst";s:0:"";s:39:"ozy_logistic_social_accounts_foursquare";s:0:"";s:35:"ozy_logistic_social_accounts_github";s:0:"";s:39:"ozy_logistic_social_accounts_googleplus";s:1:"#";s:38:"ozy_logistic_social_accounts_instagram";s:0:"";s:35:"ozy_logistic_social_accounts_lastfm";s:0:"";s:37:"ozy_logistic_social_accounts_linkedin";s:1:"#";s:36:"ozy_logistic_social_accounts_myspace";s:0:"";s:38:"ozy_logistic_social_accounts_pinterest";s:0:"";s:32:"ozy_logistic_social_accounts_rss";s:0:"";s:39:"ozy_logistic_social_accounts_soundcloud";s:0:"";s:40:"ozy_logistic_social_accounts_stumbleupon";s:0:"";s:35:"ozy_logistic_social_accounts_tumblr";s:0:"";s:36:"ozy_logistic_social_accounts_twitter";s:0:"";s:34:"ozy_logistic_social_accounts_vimeo";s:0:"";s:38:"ozy_logistic_social_accounts_wordpress";s:0:"";s:34:"ozy_logistic_social_accounts_yahoo";s:0:"";s:36:"ozy_logistic_social_accounts_youtube";s:0:"";s:23:"ozy_logistic_social_use";s:1:"1";s:30:"ozy_logistic_social_icon_order";a:2:{i:0;s:8:"linkedin";i:1;s:10:"googleplus";}s:31:"ozy_logistic_social_icon_target";s:6:"_blank";s:0:"";s:0:"";}', 'yes'),
(136, 'notifier-cache', '<?xml version="1.0" encoding="UTF-8"?>\r\n<notifier>\r\n	<latest>2.4</latest>\r\n	<changelog>\r\n<![CDATA[\r\n<h4>Version 2.4</h4>\r\n<ul>\r\n<li>Visual Content Composer plugin updated</li>\r\n<li>Master Slider plugin updated</li>\r\n<li>Envato Toolkit plugin updated</li>\r\n</ul>\r\n<h4>Version 2.3</h4>\r\n<ul>\r\n<li>Visual Content Composer plugin updated</li>\r\n<li>Master Slider plugin updated</li>\r\n<li>WordPress 4.3 compatibility issues fixed</li>\r\n<li>TGM Plugin installer updated</li>\r\n</ul>\r\n<h4>Version 2.2</h4>\r\n<ul>\r\n<li>Visual Content Composer plugin updated</li>\r\n<li>Master Slider plugin updated</li>\r\n<li>Several WPML compatibility issues fixed</li>\r\n</ul>\r\n<h4>Version 2.1</h4>\r\n<ul>\r\n<li>Visual Content Composer plugin updated (Please update your plugin)</li>\r\n</ul>\r\n<h4>Version 2.0</h4>\r\n<ul>\r\n<li>Master Slider plugin updated</li>\r\n<li>Various Fixes</li>\r\n</ul>\r\n<h4>Version 1.9</h4>\r\n<ul>\r\n<li>Visual Content Composer plugin updated</li>\r\n<li>Master Slider plugin updated</li>\r\n<li>** Sticky Menu option added Theme Options &gt; Layout &gt; Primary Menu</li>\r\n<li>Various Fix &amp; Improvements</li>\r\n</ul>\r\n<ul>\r\n<li>Master Slider plugin updated to 2.12.0 version</li>\r\n<li>Visual Content Composer plugin updated to 4.4.4 version</li>\r\n<li>Envato Toolkit plugin updated to 1.7.2 version</li>\r\n<li>Bulk plugin updating issue fixed</li>\r\n<li>Various bug fixes and improvements</li>\r\n</ul>\r\n<h4>Version 1.7</h4>\r\n<ul>\r\n<li>Master Slider plugin updated to 2.10.2 version</li>\r\n<li>Boxed Mode issue when sidebar used, fixed. The page was not going boxed.</li>\r\n<li>New sizing option added for Row Background Slider, centered and full width.</li>\r\n<li>Ozy Essentials Plugin updated to 1.5 version</li>\r\n<li>2 New demo home page layouts added into dummy data</li>\r\n<li>New visual shortcode added, Image Box With Caption Wrapper</li>\r\n<li>Various bug fixes and improvements</li>\r\n</ul>\r\n<h4>Version 1.6</h4>\r\n<ul>\r\n<li>Master Slider plugin updated to 2.9.12 version</li>\r\n<li>Visual Content Composer plugin updated to 4.4.4 version</li>\r\n<li>Font color selection added to Row component (after Visual Composer 4.4.1)</li>\r\n<li>Ozy Essentials Plugin updated to 1.4 version</li>\r\n<li>Added new option to Menu Edit Options (if you are having issues at frontend with non latin characters on Request a Rate window)</li>\r\n<li>Various bug fixes and improvements</li>\r\n</ul>\r\n<h4>Version 1.5</h4>\r\n<ul>\r\n<li>Master Slider plugin updated 2.9.9 version</li>\r\n<li>Visual Content Composer plugin updated 4.4.2 version</li>\r\n<li>Various bug fixes and improvements</li>\r\n</ul>\r\n<h4>Version 1.4</h4>\r\n<ul>\r\n<li>Master Slider plugin updated 2.9.8 version</li>\r\n<li>Ozy Essentials Plguin Updated to 1.4 version</li>\r\n<li>Twitter Slider / Carousel component working as expected now</li>\r\n<li>Various bug fixes and improvements</li>\r\n</ul>\r\n<h4>Version 1.3</h4>\r\n<ul>\r\n<li>Master Slider plugin updated</li>\r\n<li>Masonry Blog Page template added *New Feature*</li>\r\n<li>Various bug fixes and improvements</li>\r\n</ul>\r\n<h4>Version 1.2</h4>\r\n<ul>\r\n<li>Visual Content Composer plugin updated</li>\r\n<li>Master Slider plugin updated</li>\r\n<li>Various bug fixes and improvements</li>\r\n</ul>\r\n<h4>Version 1.1</h4>\r\n<ul>\r\n<li>Mobile menu breakpoints decreased, so now you can view your site as desktop version on 1280 wide screens too</li>\r\n<li>Better menu performance for different break points</li>\r\n<li>Fixed one dummy Master Slider item that not functioning as expected</li>\r\n<li>Various bug fixes and improvements</li>\r\n</ul>\r\n<h4>Version 1.0</h4>\r\n<ul>\r\n<li>Initial Release</li>\r\n</ul>\r\n]]>\r\n	</changelog>\r\n</notifier>', 'yes'),
(137, 'notifier-cache-last-updated', '1446794479', 'yes'),
(147, 'vc_version', '4.8.0.1', 'yes'),
(148, 'recently_activated', 'a:0:{}', 'yes'),
(149, 'wpcf7', 'a:1:{s:7:"version";s:3:"4.3";}', 'yes'),
(150, 'masterslider_db_version', '1.4', 'yes'),
(151, 'masterslider_capabilities_added', '1', 'yes'),
(152, 'masterslider_default_options_added', '1', 'yes'),
(153, 'masterslider_default_buttons_added', '1', 'yes'),
(154, 'masterslider_is_license_actived', '0', 'yes'),
(155, 'msp_envato_license', 'a:1:{s:5:"token";s:0:"";}', 'yes'),
(158, 'msp_general_setting', '', 'yes'),
(159, 'msp_woocommerce', '', 'yes'),
(160, 'msp_advanced', '', 'yes'),
(161, 'masterslider_plugin_version', '2.22.0', 'yes'),
(196, 'widget_custommenu-widget', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
(197, 'widget_filedownload-widget', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
(198, 'widget_flickr_widget', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
(199, 'widget_latestposts-widget', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
(200, 'widget_testimonial-widget', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
(201, 'widget_calendar', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
(202, 'widget_nav_menu', 'a:5:{i:1;a:0:{}i:2;a:2:{s:5:"title";s:12:"LIENS UTILES";s:8:"nav_menu";i:2;}i:3;a:2:{s:5:"title";s:12:"LIENS UTILES";s:8:"nav_menu";i:3;}i:5;a:2:{s:5:"title";s:8:"Produits";s:8:"nav_menu";i:5;}s:12:"_multiwidget";i:1;}', 'yes'),
(203, 'widget_master-slider-main-widget', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
(204, 'widget_pages', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
(206, 'widget_tag_cloud', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
(221, 'nav_menu_options', 'a:2:{i:0;b:0;s:8:"auto_add";a:0:{}}', 'yes'),
(254, 'category_children', 'a:0:{}', 'yes'),
(325, 'mc4wp_lite_version', '2.3.18', 'yes'),
(328, 'mc4wp_lite_form', 'a:12:{s:3:"css";s:7:"default";s:6:"markup";s:133:"<p>\r\n	<input type="email" name="EMAIL" placeholder="ADRESSE EMAIL" required />\r\n\r\n	<input type="submit" value="M\'INSCRIRE" />\r\n</p>\r\n";s:12:"double_optin";s:1:"1";s:18:"hide_after_success";s:1:"0";s:8:"redirect";s:0:"";s:15:"text_subscribed";s:79:"Thank you, your sign-up request was successful! Please check your e-mail inbox.";s:18:"text_invalid_email";s:37:"Please provide a valid email address.";s:27:"text_required_field_missing";s:35:"Please fill in the required fields.";s:23:"text_already_subscribed";s:53:"Given email address is already subscribed, thank you!";s:10:"text_error";s:51:"Oops. Something went wrong. Please try again later.";s:17:"text_unsubscribed";s:35:"You were successfully unsubscribed.";s:19:"text_not_subscribed";s:38:"Given email address is not subscribed.";}', 'yes'),
(345, 'rewrite_rules', 'a:83:{s:47:"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:42:"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:35:"category/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:17:"category/(.+?)/?$";s:35:"index.php?category_name=$matches[1]";s:44:"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:39:"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:32:"tag/([^/]+)/page/?([0-9]{1,})/?$";s:43:"index.php?tag=$matches[1]&paged=$matches[2]";s:14:"tag/([^/]+)/?$";s:25:"index.php?tag=$matches[1]";s:45:"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:40:"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:33:"type/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?post_format=$matches[1]&paged=$matches[2]";s:15:"type/([^/]+)/?$";s:33:"index.php?post_format=$matches[1]";s:40:"vc_grid_item/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:50:"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:70:"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:65:"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:65:"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:"vc_grid_item/([^/]+)/trackback/?$";s:39:"index.php?vc_grid_item=$matches[1]&tb=1";s:41:"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$";s:52:"index.php?vc_grid_item=$matches[1]&paged=$matches[2]";s:48:"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$";s:52:"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]";s:33:"vc_grid_item/([^/]+)(/[0-9]+)?/?$";s:51:"index.php?vc_grid_item=$matches[1]&page=$matches[2]";s:29:"vc_grid_item/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:39:"vc_grid_item/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:59:"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:54:"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:54:"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:12:"robots\\.txt$";s:18:"index.php?robots=1";s:48:".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$";s:18:"index.php?feed=old";s:20:".*wp-app\\.php(/.*)?$";s:19:"index.php?error=403";s:18:".*wp-register.php$";s:23:"index.php?register=true";s:32:"feed/(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:27:"(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:20:"page/?([0-9]{1,})/?$";s:28:"index.php?&paged=$matches[1]";s:27:"comment-page-([0-9]{1,})/?$";s:38:"index.php?&page_id=6&cpage=$matches[1]";s:41:"comments/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:36:"comments/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:44:"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:39:"search/(.+)/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:32:"search/(.+)/page/?([0-9]{1,})/?$";s:41:"index.php?s=$matches[1]&paged=$matches[2]";s:14:"search/(.+)/?$";s:23:"index.php?s=$matches[1]";s:47:"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:42:"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:35:"author/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?author_name=$matches[1]&paged=$matches[2]";s:17:"author/([^/]+)/?$";s:33:"index.php?author_name=$matches[1]";s:69:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]";s:39:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$";s:63:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]";s:56:"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:51:"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:44:"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]";s:26:"([0-9]{4})/([0-9]{1,2})/?$";s:47:"index.php?year=$matches[1]&monthnum=$matches[2]";s:43:"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:38:"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:31:"([0-9]{4})/page/?([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&paged=$matches[2]";s:13:"([0-9]{4})/?$";s:26:"index.php?year=$matches[1]";s:27:".?.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:".?.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:20:"(.?.+?)/trackback/?$";s:35:"index.php?pagename=$matches[1]&tb=1";s:40:"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:35:"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:28:"(.?.+?)/page/?([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&paged=$matches[2]";s:35:"(.?.+?)/comment-page-([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&cpage=$matches[2]";s:20:"(.?.+?)(/[0-9]+)?/?$";s:47:"index.php?pagename=$matches[1]&page=$matches[2]";s:27:"[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:"[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:20:"([^/]+)/trackback/?$";s:31:"index.php?name=$matches[1]&tb=1";s:40:"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?name=$matches[1]&feed=$matches[2]";s:35:"([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?name=$matches[1]&feed=$matches[2]";s:28:"([^/]+)/page/?([0-9]{1,})/?$";s:44:"index.php?name=$matches[1]&paged=$matches[2]";s:35:"([^/]+)/comment-page-([0-9]{1,})/?$";s:44:"index.php?name=$matches[1]&cpage=$matches[2]";s:20:"([^/]+)(/[0-9]+)?/?$";s:43:"index.php?name=$matches[1]&page=$matches[2]";s:16:"[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:26:"[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:46:"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:41:"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:41:"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";}', 'yes') ;

#
# End of data contents of table `wp_options`
# --------------------------------------------------------



#
# Delete any existing table `wp_postmeta`
#

DROP TABLE IF EXISTS `wp_postmeta`;


#
# Table structure of table `wp_postmeta`
#

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=753 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


#
# Data contents of table `wp_postmeta`
#
INSERT INTO `wp_postmeta` ( `meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
(2, 4, '_form', '<p>NAME (REQUIRED)<br />\n    [text* your-name] </p>\n\n<p>EMAIL (REQUIRED)<br />\n    [email* your-email] </p>\n\n<p>SUBJECT<br />\n    [text your-subject] </p>\n\n<p>YOUR MESSAGE<br />\n    [textarea your-message] </p>\n\n<p>[submit "SEND"]</p>'),
(3, 4, '_mail', 'a:8:{s:7:"subject";s:14:"[your-subject]";s:6:"sender";s:36:"[your-name] <wordpress@micronics.fr>";s:4:"body";s:189:"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on Micronics Systems (http://micronics.votresitedemo.com)";s:9:"recipient";s:18:"fd@mobi-pronet.com";s:18:"additional_headers";s:22:"Reply-To: [your-email]";s:11:"attachments";s:0:"";s:8:"use_html";b:0;s:13:"exclude_blank";b:0;}'),
(4, 4, '_mail_2', 'a:9:{s:6:"active";b:0;s:7:"subject";s:14:"[your-subject]";s:6:"sender";s:42:"Micronics Systems <wordpress@micronics.fr>";s:4:"body";s:131:"Message Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on Micronics Systems (http://micronics.votresitedemo.com)";s:9:"recipient";s:12:"[your-email]";s:18:"additional_headers";s:28:"Reply-To: fd@mobi-pronet.com";s:11:"attachments";s:0:"";s:8:"use_html";b:0;s:13:"exclude_blank";b:0;}'),
(5, 4, '_messages', 'a:22:{s:12:"mail_sent_ok";s:43:"Your message was sent successfully. Thanks.";s:12:"mail_sent_ng";s:93:"Failed to send your message. Please try later or contact the administrator by another method.";s:16:"validation_error";s:74:"Validation errors occurred. Please confirm the fields and submit it again.";s:4:"spam";s:93:"Failed to send your message. Please try later or contact the administrator by another method.";s:12:"accept_terms";s:35:"Please accept the terms to proceed.";s:16:"invalid_required";s:34:"Please fill in the required field.";s:16:"invalid_too_long";s:23:"This input is too long.";s:17:"invalid_too_short";s:24:"This input is too short.";s:12:"invalid_date";s:26:"Date format seems invalid.";s:14:"date_too_early";s:23:"This date is too early.";s:13:"date_too_late";s:22:"This date is too late.";s:13:"upload_failed";s:22:"Failed to upload file.";s:24:"upload_file_type_invalid";s:30:"This file type is not allowed.";s:21:"upload_file_too_large";s:23:"This file is too large.";s:23:"upload_failed_php_error";s:38:"Failed to upload file. Error occurred.";s:14:"invalid_number";s:28:"Number format seems invalid.";s:16:"number_too_small";s:25:"This number is too small.";s:16:"number_too_large";s:25:"This number is too large.";s:23:"quiz_answer_not_correct";s:27:"Your answer is not correct.";s:13:"invalid_email";s:28:"Email address seems invalid.";s:11:"invalid_url";s:18:"URL seems invalid.";s:11:"invalid_tel";s:31:"Telephone number seems invalid.";}'),
(6, 4, '_additional_settings', ''),
(7, 4, '_locale', 'en_US'),
(11, 6, '_edit_last', '1'),
(12, 6, '_edit_lock', '1446820532:1'),
(13, 6, '_wp_page_template', 'default'),
(14, 6, '_wpb_vc_js_status', 'true'),
(15, 6, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(16, 6, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"1";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"1";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"0";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"full";s:30:"ozy_logistic_meta_page_sidebar";s:0:"";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(17, 6, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(32, 24, '_edit_last', '1'),
(33, 24, '_edit_lock', '1446627612:1'),
(35, 24, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(36, 26, '_edit_last', '1'),
(38, 26, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(39, 26, '_edit_lock', '1446627487:1'),
(40, 28, '_edit_last', '1'),
(42, 28, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(43, 28, '_edit_lock', '1446627473:1'),
(50, 33, '_menu_item_type', 'custom'),
(51, 33, '_menu_item_menu_item_parent', '0'),
(52, 33, '_menu_item_object_id', '33'),
(53, 33, '_menu_item_object', 'custom'),
(54, 33, '_menu_item_target', ''),
(55, 33, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(56, 33, '_menu_item_xfn', ''),
(57, 33, '_menu_item_url', 'http://#'),
(59, 34, '_menu_item_type', 'custom'),
(60, 34, '_menu_item_menu_item_parent', '0'),
(61, 34, '_menu_item_object_id', '34'),
(62, 34, '_menu_item_object', 'custom'),
(63, 34, '_menu_item_target', ''),
(64, 34, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(65, 34, '_menu_item_xfn', ''),
(66, 34, '_menu_item_url', 'http://#'),
(68, 35, '_menu_item_type', 'custom'),
(69, 35, '_menu_item_menu_item_parent', '0'),
(70, 35, '_menu_item_object_id', '35'),
(71, 35, '_menu_item_object', 'custom'),
(72, 35, '_menu_item_target', ''),
(73, 35, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(74, 35, '_menu_item_xfn', ''),
(75, 35, '_menu_item_url', 'http://#'),
(77, 36, '_menu_item_type', 'custom'),
(78, 36, '_menu_item_menu_item_parent', '0'),
(79, 36, '_menu_item_object_id', '36'),
(80, 36, '_menu_item_object', 'custom'),
(81, 36, '_menu_item_target', ''),
(82, 36, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(83, 36, '_menu_item_xfn', ''),
(84, 36, '_menu_item_url', 'http://#'),
(86, 37, '_menu_item_type', 'custom'),
(87, 37, '_menu_item_menu_item_parent', '0'),
(88, 37, '_menu_item_object_id', '37'),
(89, 37, '_menu_item_object', 'custom'),
(90, 37, '_menu_item_target', ''),
(91, 37, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(92, 37, '_menu_item_xfn', ''),
(93, 37, '_menu_item_url', 'http://#'),
(95, 33, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(96, 34, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(97, 35, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(98, 36, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(99, 37, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(100, 38, '_menu_item_type', 'custom'),
(101, 38, '_menu_item_menu_item_parent', '0'),
(102, 38, '_menu_item_object_id', '38'),
(103, 38, '_menu_item_object', 'custom'),
(104, 38, '_menu_item_target', ''),
(105, 38, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(106, 38, '_menu_item_xfn', ''),
(107, 38, '_menu_item_url', 'http://#'),
(108, 38, '_menu_item_orphaned', '1446628581'),
(109, 39, '_menu_item_type', 'custom'),
(110, 39, '_menu_item_menu_item_parent', '0'),
(111, 39, '_menu_item_object_id', '39'),
(112, 39, '_menu_item_object', 'custom'),
(113, 39, '_menu_item_target', ''),
(114, 39, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(115, 39, '_menu_item_xfn', ''),
(116, 39, '_menu_item_url', 'http://#'),
(118, 40, '_menu_item_type', 'custom'),
(119, 40, '_menu_item_menu_item_parent', '0'),
(120, 40, '_menu_item_object_id', '40'),
(121, 40, '_menu_item_object', 'custom'),
(122, 40, '_menu_item_target', ''),
(123, 40, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(124, 40, '_menu_item_xfn', ''),
(125, 40, '_menu_item_url', 'http://#'),
(127, 41, '_menu_item_type', 'custom'),
(128, 41, '_menu_item_menu_item_parent', '0'),
(129, 41, '_menu_item_object_id', '41'),
(130, 41, '_menu_item_object', 'custom'),
(131, 41, '_menu_item_target', ''),
(132, 41, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(133, 41, '_menu_item_xfn', ''),
(134, 41, '_menu_item_url', 'http://#') ;
INSERT INTO `wp_postmeta` ( `meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
(136, 42, '_menu_item_type', 'custom'),
(137, 42, '_menu_item_menu_item_parent', '0'),
(138, 42, '_menu_item_object_id', '42'),
(139, 42, '_menu_item_object', 'custom'),
(140, 42, '_menu_item_target', ''),
(141, 42, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(142, 42, '_menu_item_xfn', ''),
(143, 42, '_menu_item_url', 'http://#'),
(145, 43, '_menu_item_type', 'custom'),
(146, 43, '_menu_item_menu_item_parent', '0'),
(147, 43, '_menu_item_object_id', '43'),
(148, 43, '_menu_item_object', 'custom'),
(149, 43, '_menu_item_target', ''),
(150, 43, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(151, 43, '_menu_item_xfn', ''),
(152, 43, '_menu_item_url', 'http://#'),
(154, 39, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(155, 40, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(156, 41, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(157, 42, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(158, 43, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(169, 45, '_edit_last', '1'),
(170, 45, '_wp_page_template', 'default'),
(171, 45, '_wpb_vc_js_status', 'true'),
(172, 45, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(173, 45, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"1";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"0";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"full";s:30:"ozy_logistic_meta_page_sidebar";s:0:"";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(174, 45, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(175, 45, '_edit_lock', '1446808639:1'),
(176, 49, '_edit_last', '1'),
(177, 49, '_wp_page_template', 'default'),
(178, 49, '_wpb_vc_js_status', 'false'),
(179, 49, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(180, 49, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"0";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"full";s:30:"ozy_logistic_meta_page_sidebar";s:0:"";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(181, 49, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(182, 49, '_edit_lock', '1446629359:1'),
(183, 51, '_edit_last', '1'),
(184, 51, '_wp_page_template', 'default'),
(185, 51, '_wpb_vc_js_status', 'false'),
(186, 51, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(187, 51, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"0";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"full";s:30:"ozy_logistic_meta_page_sidebar";s:0:"";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(188, 51, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(189, 51, '_edit_lock', '1446629382:1'),
(190, 54, '_edit_last', '1'),
(191, 54, '_wp_page_template', 'default'),
(192, 54, '_wpb_vc_js_status', 'true'),
(193, 54, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(194, 54, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"1";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:27:"Restez en contact avec nous";s:41:"ozy_logistic_meta_page_custom_title_color";s:19:"rgba(255,255,255,1)";s:39:"ozy_logistic_meta_page_custom_sub_title";s:63:"Nous cultivons notre savoir-faire et nos technologies pour vous";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:18:"rgba(52,204,255,1)";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:91:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/bg_image_contact-1144x477.jpg";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:6:"center";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:6:"bottom";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"400";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"0";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"full";s:30:"ozy_logistic_meta_page_sidebar";s:0:"";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"1";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:0:"";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"1";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:83:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/world_bg-1144x715.png";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:6:"center";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:9:"no-repeat";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(195, 54, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(196, 54, '_edit_lock', '1446821686:1'),
(197, 56, '_menu_item_type', 'post_type'),
(198, 56, '_menu_item_menu_item_parent', '0'),
(199, 56, '_menu_item_object_id', '54'),
(200, 56, '_menu_item_object', 'page'),
(201, 56, '_menu_item_target', ''),
(202, 56, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(203, 56, '_menu_item_xfn', ''),
(204, 56, '_menu_item_url', ''),
(206, 57, '_menu_item_type', 'post_type'),
(207, 57, '_menu_item_menu_item_parent', '0'),
(208, 57, '_menu_item_object_id', '51'),
(209, 57, '_menu_item_object', 'page'),
(210, 57, '_menu_item_target', ''),
(211, 57, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(212, 57, '_menu_item_xfn', ''),
(213, 57, '_menu_item_url', ''),
(215, 58, '_menu_item_type', 'post_type'),
(216, 58, '_menu_item_menu_item_parent', '0'),
(217, 58, '_menu_item_object_id', '49'),
(218, 58, '_menu_item_object', 'page'),
(219, 58, '_menu_item_target', ''),
(220, 58, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(221, 58, '_menu_item_xfn', ''),
(222, 58, '_menu_item_url', ''),
(224, 59, '_menu_item_type', 'post_type'),
(225, 59, '_menu_item_menu_item_parent', '0'),
(226, 59, '_menu_item_object_id', '45'),
(227, 59, '_menu_item_object', 'page'),
(228, 59, '_menu_item_target', ''),
(229, 59, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(230, 59, '_menu_item_xfn', ''),
(231, 59, '_menu_item_url', ''),
(233, 56, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(234, 57, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(235, 58, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(236, 59, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(237, 60, '_edit_last', '1'),
(238, 60, '_wp_page_template', 'default'),
(239, 60, '_wpb_vc_js_status', 'false'),
(240, 60, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(241, 60, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"1";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"1";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"left";s:30:"ozy_logistic_meta_page_sidebar";s:16:"produits-sidebar";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(242, 60, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(243, 60, '_edit_lock', '1446809949:1'),
(244, 62, '_menu_item_type', 'post_type'),
(245, 62, '_menu_item_menu_item_parent', '0'),
(246, 62, '_menu_item_object_id', '60'),
(247, 62, '_menu_item_object', 'page'),
(248, 62, '_menu_item_target', ''),
(249, 62, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(250, 62, '_menu_item_xfn', ''),
(251, 62, '_menu_item_url', '') ;
INSERT INTO `wp_postmeta` ( `meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
(253, 62, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(254, 63, '_menu_item_type', 'post_type'),
(255, 63, '_menu_item_menu_item_parent', '0'),
(256, 63, '_menu_item_object_id', '54'),
(257, 63, '_menu_item_object', 'page'),
(258, 63, '_menu_item_target', ''),
(259, 63, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(260, 63, '_menu_item_xfn', ''),
(261, 63, '_menu_item_url', ''),
(262, 63, '_menu_item_orphaned', '1446629698'),
(263, 76, '_wp_attached_file', '2015/11/logo-white.png'),
(264, 76, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:206;s:6:"height";i:49;s:4:"file";s:22:"2015/11/logo-white.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"logo-white-150x49.png";s:5:"width";i:150;s:6:"height";i:49;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:11:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";s:11:"orientation";i:0;}}'),
(265, 77, '_wp_attached_file', '2015/11/logo-black.png'),
(266, 77, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:208;s:6:"height";i:49;s:4:"file";s:22:"2015/11/logo-black.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"logo-black-150x49.png";s:5:"width";i:150;s:6:"height";i:49;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:11:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";s:11:"orientation";i:0;}}'),
(267, 78, '_wp_attached_file', '2015/11/slider-image-green.png'),
(268, 78, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1440;s:6:"height";i:900;s:4:"file";s:30:"2015/11/slider-image-green.png";s:5:"sizes";a:6:{s:9:"thumbnail";a:4:{s:4:"file";s:30:"slider-image-green-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:30:"slider-image-green-300x188.png";s:5:"width";i:300;s:6:"height";i:188;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:31:"slider-image-green-1024x640.png";s:5:"width";i:1024;s:6:"height";i:640;s:9:"mime-type";s:9:"image/png";}s:8:"boxyboxy";a:4:{s:4:"file";s:30:"slider-image-green-480x480.png";s:5:"width";i:480;s:6:"height";i:480;s:9:"mime-type";s:9:"image/png";}s:7:"showbiz";a:4:{s:4:"file";s:30:"slider-image-green-720x720.png";s:5:"width";i:720;s:6:"height";i:720;s:9:"mime-type";s:9:"image/png";}s:4:"blog";a:4:{s:4:"file";s:31:"slider-image-green-1144x715.png";s:5:"width";i:1144;s:6:"height";i:715;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:11:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";s:11:"orientation";i:0;}}'),
(269, 79, '_wp_attached_file', '2015/11/slider-image-circuits.png'),
(270, 79, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1440;s:6:"height";i:898;s:4:"file";s:33:"2015/11/slider-image-circuits.png";s:5:"sizes";a:6:{s:9:"thumbnail";a:4:{s:4:"file";s:33:"slider-image-circuits-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:33:"slider-image-circuits-300x187.png";s:5:"width";i:300;s:6:"height";i:187;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:34:"slider-image-circuits-1024x639.png";s:5:"width";i:1024;s:6:"height";i:639;s:9:"mime-type";s:9:"image/png";}s:8:"boxyboxy";a:4:{s:4:"file";s:33:"slider-image-circuits-480x480.png";s:5:"width";i:480;s:6:"height";i:480;s:9:"mime-type";s:9:"image/png";}s:7:"showbiz";a:4:{s:4:"file";s:33:"slider-image-circuits-720x720.png";s:5:"width";i:720;s:6:"height";i:720;s:9:"mime-type";s:9:"image/png";}s:4:"blog";a:4:{s:4:"file";s:34:"slider-image-circuits-1144x713.png";s:5:"width";i:1144;s:6:"height";i:713;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:11:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";s:11:"orientation";i:0;}}'),
(305, 102, '_wp_attached_file', '2015/11/cms-image.png'),
(306, 102, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:529;s:6:"height";i:359;s:4:"file";s:21:"2015/11/cms-image.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"cms-image-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"cms-image-300x204.png";s:5:"width";i:300;s:6:"height";i:204;s:9:"mime-type";s:9:"image/png";}s:8:"boxyboxy";a:4:{s:4:"file";s:21:"cms-image-480x359.png";s:5:"width";i:480;s:6:"height";i:359;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:11:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";s:11:"orientation";i:0;}}'),
(308, 45, '_wpb_shortcodes_custom_css', '.vc_custom_1446805109031{padding-top: 40px !important;}.vc_custom_1446805435087{background-color: #efeff2 !important;}.vc_custom_1446805689580{padding-top: 20px !important;}'),
(309, 124, '_wp_attached_file', '2015/11/director1-150x150.jpg'),
(310, 124, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:150;s:6:"height";i:150;s:4:"file";s:29:"2015/11/director1-150x150.jpg";s:5:"sizes";a:0:{}s:10:"image_meta";a:11:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";s:11:"orientation";i:0;}}'),
(311, 126, '_wp_attached_file', '2015/11/96895135-300x180.jpg'),
(312, 126, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:300;s:6:"height";i:180;s:4:"file";s:28:"2015/11/96895135-300x180.jpg";s:5:"sizes";a:2:{s:9:"thumbnail";a:4:{s:4:"file";s:28:"96895135-300x180-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:28:"96895135-300x180-300x180.jpg";s:5:"width";i:300;s:6:"height";i:180;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:11:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";s:11:"orientation";i:0;}}'),
(313, 129, '_wp_attached_file', '2015/11/bg_image_contact-1144x477.jpg'),
(314, 129, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1144;s:6:"height";i:477;s:4:"file";s:37:"2015/11/bg_image_contact-1144x477.jpg";s:5:"sizes";a:6:{s:9:"thumbnail";a:4:{s:4:"file";s:37:"bg_image_contact-1144x477-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:37:"bg_image_contact-1144x477-300x125.jpg";s:5:"width";i:300;s:6:"height";i:125;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:38:"bg_image_contact-1144x477-1024x427.jpg";s:5:"width";i:1024;s:6:"height";i:427;s:9:"mime-type";s:10:"image/jpeg";}s:8:"boxyboxy";a:4:{s:4:"file";s:37:"bg_image_contact-1144x477-480x477.jpg";s:5:"width";i:480;s:6:"height";i:477;s:9:"mime-type";s:10:"image/jpeg";}s:7:"showbiz";a:4:{s:4:"file";s:37:"bg_image_contact-1144x477-720x477.jpg";s:5:"width";i:720;s:6:"height";i:477;s:9:"mime-type";s:10:"image/jpeg";}s:4:"blog";a:4:{s:4:"file";s:38:"bg_image_contact-1144x477-1144x477.jpg";s:5:"width";i:1144;s:6:"height";i:477;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:11:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";s:11:"orientation";i:0;}}'),
(315, 130, '_wp_attached_file', '2015/11/world_bg-1144x715.png'),
(316, 130, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1144;s:6:"height";i:715;s:4:"file";s:29:"2015/11/world_bg-1144x715.png";s:5:"sizes";a:6:{s:9:"thumbnail";a:4:{s:4:"file";s:29:"world_bg-1144x715-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:29:"world_bg-1144x715-300x188.png";s:5:"width";i:300;s:6:"height";i:188;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:30:"world_bg-1144x715-1024x640.png";s:5:"width";i:1024;s:6:"height";i:640;s:9:"mime-type";s:9:"image/png";}s:8:"boxyboxy";a:4:{s:4:"file";s:29:"world_bg-1144x715-480x480.png";s:5:"width";i:480;s:6:"height";i:480;s:9:"mime-type";s:9:"image/png";}s:7:"showbiz";a:4:{s:4:"file";s:29:"world_bg-1144x715-720x715.png";s:5:"width";i:720;s:6:"height";i:715;s:9:"mime-type";s:9:"image/png";}s:4:"blog";a:4:{s:4:"file";s:30:"world_bg-1144x715-1144x715.png";s:5:"width";i:1144;s:6:"height";i:715;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:11:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";s:11:"orientation";i:0;}}'),
(317, 133, '_wp_attached_file', '2015/11/operator.png'),
(318, 133, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:600;s:6:"height";i:839;s:4:"file";s:20:"2015/11/operator.png";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:20:"operator-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:20:"operator-215x300.png";s:5:"width";i:215;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:8:"boxyboxy";a:4:{s:4:"file";s:20:"operator-480x480.png";s:5:"width";i:480;s:6:"height";i:480;s:9:"mime-type";s:9:"image/png";}s:7:"showbiz";a:4:{s:4:"file";s:20:"operator-600x720.png";s:5:"width";i:600;s:6:"height";i:720;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:11:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";s:11:"orientation";i:0;}}'),
(319, 141, '_edit_last', '1'),
(320, 141, '_edit_lock', '1446812687:1'),
(321, 141, '_wp_page_template', 'default'),
(322, 141, '_wpb_vc_js_status', 'true'),
(323, 141, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(324, 141, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"1";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"0";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"full";s:30:"ozy_logistic_meta_page_sidebar";s:0:"";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(325, 141, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(326, 143, '_edit_last', '1'),
(327, 143, '_edit_lock', '1446814792:1'),
(328, 143, '_wp_page_template', 'default'),
(329, 143, '_wpb_vc_js_status', 'true'),
(330, 143, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(331, 143, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"1";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"1";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"left";s:30:"ozy_logistic_meta_page_sidebar";s:16:"produits-sidebar";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(332, 143, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(333, 145, '_edit_last', '1'),
(334, 145, '_edit_lock', '1446814704:1'),
(335, 145, '_wp_page_template', 'default'),
(336, 145, '_wpb_vc_js_status', 'true'),
(337, 145, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(338, 145, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"1";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"1";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"left";s:30:"ozy_logistic_meta_page_sidebar";s:16:"produits-sidebar";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(339, 145, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(340, 147, '_edit_last', '1'),
(341, 147, '_wp_page_template', 'default'),
(342, 147, '_wpb_vc_js_status', 'true'),
(343, 147, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(344, 147, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"1";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"1";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"left";s:30:"ozy_logistic_meta_page_sidebar";s:16:"produits-sidebar";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(345, 147, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(346, 147, '_edit_lock', '1446815039:1'),
(347, 149, '_menu_item_type', 'post_type'),
(348, 149, '_menu_item_menu_item_parent', '0'),
(349, 149, '_menu_item_object_id', '141'),
(350, 149, '_menu_item_object', 'page'),
(351, 149, '_menu_item_target', ''),
(352, 149, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(353, 149, '_menu_item_xfn', ''),
(354, 149, '_menu_item_url', ''),
(356, 150, '_menu_item_type', 'post_type'),
(357, 150, '_menu_item_menu_item_parent', '149'),
(358, 150, '_menu_item_object_id', '147'),
(359, 150, '_menu_item_object', 'page'),
(360, 150, '_menu_item_target', ''),
(361, 150, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(362, 150, '_menu_item_xfn', ''),
(363, 150, '_menu_item_url', ''),
(365, 151, '_menu_item_type', 'post_type'),
(366, 151, '_menu_item_menu_item_parent', '149'),
(367, 151, '_menu_item_object_id', '145'),
(368, 151, '_menu_item_object', 'page'),
(369, 151, '_menu_item_target', ''),
(370, 151, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(371, 151, '_menu_item_xfn', ''),
(372, 151, '_menu_item_url', ''),
(374, 152, '_menu_item_type', 'post_type'),
(375, 152, '_menu_item_menu_item_parent', '149'),
(376, 152, '_menu_item_object_id', '143'),
(377, 152, '_menu_item_object', 'page'),
(378, 152, '_menu_item_target', ''),
(379, 152, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(380, 152, '_menu_item_xfn', ''),
(381, 152, '_menu_item_url', ''),
(383, 149, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(384, 150, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(385, 151, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(386, 152, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(437, 158, '_edit_last', '1'),
(438, 158, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(439, 158, '_edit_lock', '1446643818:1'),
(440, 159, '_edit_last', '1'),
(441, 159, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}') ;
INSERT INTO `wp_postmeta` ( `meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
(442, 159, '_edit_lock', '1446646901:1'),
(443, 160, '_edit_last', '1'),
(444, 160, '_wp_page_template', 'page-regular-blog.php'),
(445, 160, '_wpb_vc_js_status', 'false'),
(446, 160, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(447, 160, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"1";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:5:"right";s:30:"ozy_logistic_meta_page_sidebar";s:12:"blog-sidebar";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(448, 160, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(449, 160, '_edit_lock', '1446732700:1'),
(453, 141, '_wpb_shortcodes_custom_css', '.vc_custom_1446811755292{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/produits1.jpg?id=382) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}'),
(454, 194, '_wp_attached_file', '2015/11/product-image-260x260.png'),
(455, 194, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:260;s:6:"height";i:260;s:4:"file";s:33:"2015/11/product-image-260x260.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:33:"product-image-260x260-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:11:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";s:11:"orientation";i:0;}}'),
(456, 210, '_edit_last', '1'),
(457, 210, '_edit_lock', '1446721522:1'),
(458, 211, '_wp_attached_file', '2015/11/Hind-Medium.svg'),
(459, 212, '_wp_attached_file', '2015/11/Hind-Bold.eot'),
(460, 213, '_wp_attached_file', '2015/11/Hind-Semibold.eot'),
(461, 214, '_wp_attached_file', '2015/11/Hind-Regular.woff'),
(462, 215, '_wp_attached_file', '2015/11/Hind-Bold.woff'),
(463, 216, '_wp_attached_file', '2015/11/Hind-Semibold.woff'),
(464, 217, '_wp_attached_file', '2015/11/Hind-Light.woff'),
(465, 218, '_wp_attached_file', '2015/11/Hind-Semibold.svg'),
(466, 219, '_wp_attached_file', '2015/11/Hind-Bold.svg'),
(467, 220, '_wp_attached_file', '2015/11/Hind-Semibold.ttf'),
(468, 221, '_wp_attached_file', '2015/11/Hind-Regular.ttf'),
(469, 222, '_wp_attached_file', '2015/11/Hind-Regular.eot'),
(470, 223, '_wp_attached_file', '2015/11/Hind-Medium.eot'),
(471, 224, '_wp_attached_file', '2015/11/Hind-Medium.woff'),
(472, 225, '_wp_attached_file', '2015/11/Hind-Medium.ttf'),
(473, 226, '_wp_attached_file', '2015/11/Hind-Light.ttf'),
(474, 227, '_wp_attached_file', '2015/11/Hind-Regular.svg'),
(475, 228, '_wp_attached_file', '2015/11/Hind-Light.svg'),
(476, 229, '_wp_attached_file', '2015/11/Hind-Bold.ttf'),
(477, 230, '_wp_attached_file', '2015/11/Hind-Light.eot'),
(478, 210, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(479, 210, 'ozy_logistic_meta_font', 'a:1:{s:28:"ozy_logistic_meta_font_group";a:1:{i:0;a:7:{s:25:"ozy_logistic_meta_font_id";s:9:"Hind-Bold";s:26:"ozy_logistic_meta_font_eot";s:75:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Bold.eot";s:27:"ozy_logistic_meta_font_woff";s:76:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Bold.woff";s:26:"ozy_logistic_meta_font_ttf";s:75:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Bold.ttf";s:26:"ozy_logistic_meta_font_svg";s:75:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Bold.svg";s:29:"ozy_logistic_meta_font_weight";s:3:"700";s:28:"ozy_logistic_meta_font_style";s:6:"normal";}}}'),
(480, 231, '_edit_last', '1'),
(481, 231, '_edit_lock', '1446721766:1'),
(482, 231, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(483, 231, 'ozy_logistic_meta_font', 'a:1:{s:28:"ozy_logistic_meta_font_group";a:1:{i:0;a:7:{s:25:"ozy_logistic_meta_font_id";s:10:"Hind-Light";s:26:"ozy_logistic_meta_font_eot";s:76:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Light.eot";s:27:"ozy_logistic_meta_font_woff";s:77:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Light.woff";s:26:"ozy_logistic_meta_font_ttf";s:76:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Light.ttf";s:26:"ozy_logistic_meta_font_svg";s:76:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Light.svg";s:29:"ozy_logistic_meta_font_weight";s:3:"300";s:28:"ozy_logistic_meta_font_style";s:6:"normal";}}}'),
(484, 232, '_edit_last', '1'),
(485, 232, '_edit_lock', '1446800375:1'),
(486, 232, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(487, 232, 'ozy_logistic_meta_font', 'a:1:{s:28:"ozy_logistic_meta_font_group";a:1:{i:0;a:7:{s:25:"ozy_logistic_meta_font_id";s:11:"Hind-Medium";s:26:"ozy_logistic_meta_font_eot";s:77:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Medium.eot";s:27:"ozy_logistic_meta_font_woff";s:78:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Medium.woff";s:26:"ozy_logistic_meta_font_ttf";s:77:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Medium.ttf";s:26:"ozy_logistic_meta_font_svg";s:77:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Medium.svg";s:29:"ozy_logistic_meta_font_weight";s:3:"500";s:28:"ozy_logistic_meta_font_style";s:6:"normal";}}}'),
(488, 233, '_edit_last', '1'),
(489, 233, '_edit_lock', '1446721799:1'),
(490, 233, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(491, 233, 'ozy_logistic_meta_font', 'a:1:{s:28:"ozy_logistic_meta_font_group";a:1:{i:0;a:7:{s:25:"ozy_logistic_meta_font_id";s:12:"Hind-Regular";s:26:"ozy_logistic_meta_font_eot";s:78:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Regular.eot";s:27:"ozy_logistic_meta_font_woff";s:79:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Regular.woff";s:26:"ozy_logistic_meta_font_ttf";s:78:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Regular.ttf";s:26:"ozy_logistic_meta_font_svg";s:78:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Regular.svg";s:29:"ozy_logistic_meta_font_weight";s:3:"400";s:28:"ozy_logistic_meta_font_style";s:6:"normal";}}}'),
(492, 234, '_edit_last', '1'),
(493, 234, '_edit_lock', '1446727883:1'),
(494, 234, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(495, 234, 'ozy_logistic_meta_font', 'a:1:{s:28:"ozy_logistic_meta_font_group";a:1:{i:0;a:7:{s:25:"ozy_logistic_meta_font_id";s:13:"Hind-Semibold";s:26:"ozy_logistic_meta_font_eot";s:79:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Semibold.eot";s:27:"ozy_logistic_meta_font_woff";s:80:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Semibold.woff";s:26:"ozy_logistic_meta_font_ttf";s:79:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Semibold.ttf";s:26:"ozy_logistic_meta_font_svg";s:79:"http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Semibold.svg";s:29:"ozy_logistic_meta_font_weight";s:3:"600";s:28:"ozy_logistic_meta_font_style";s:6:"normal";}}}'),
(497, 6, '_wpb_shortcodes_custom_css', '.vc_custom_1446798115356{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}.vc_custom_1446655471037{padding-top: 120px !important;}.vc_custom_1446797669437{padding-bottom: 20px !important;}.vc_custom_1446797743170{padding-top: 40px !important;padding-bottom: 40px !important;}'),
(498, 259, '_edit_last', '1'),
(499, 259, '_edit_lock', '1446655740:1'),
(500, 259, '_wp_page_template', 'default'),
(501, 259, '_wpb_vc_js_status', 'false'),
(502, 259, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(503, 259, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"0";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"full";s:30:"ozy_logistic_meta_page_sidebar";s:0:"";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(504, 259, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(505, 261, '_edit_last', '1'),
(506, 261, '_wp_page_template', 'default'),
(507, 261, '_wpb_vc_js_status', 'false'),
(508, 261, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(509, 261, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"0";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"full";s:30:"ozy_logistic_meta_page_sidebar";s:0:"";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(510, 261, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(511, 261, '_edit_lock', '1446655753:1'),
(512, 263, '_edit_last', '1'),
(513, 263, '_edit_lock', '1446655772:1'),
(514, 263, '_wp_page_template', 'default'),
(515, 263, '_wpb_vc_js_status', 'false'),
(516, 263, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(517, 263, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"0";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"full";s:30:"ozy_logistic_meta_page_sidebar";s:0:"";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(518, 263, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(519, 265, '_edit_last', '1'),
(520, 265, '_wp_page_template', 'default'),
(521, 265, '_wpb_vc_js_status', 'false'),
(522, 265, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(523, 265, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"0";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"full";s:30:"ozy_logistic_meta_page_sidebar";s:0:"";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(524, 265, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(525, 265, '_edit_lock', '1446655789:1'),
(526, 267, '_edit_last', '1'),
(527, 267, '_edit_lock', '1446655805:1'),
(528, 267, '_wp_page_template', 'default'),
(529, 267, '_wpb_vc_js_status', 'false'),
(530, 267, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(531, 267, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"0";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"full";s:30:"ozy_logistic_meta_page_sidebar";s:0:"";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(532, 267, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(533, 269, '_edit_last', '1'),
(534, 269, '_wp_page_template', 'default'),
(535, 269, '_wpb_vc_js_status', 'false'),
(536, 269, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(537, 269, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"0";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"full";s:30:"ozy_logistic_meta_page_sidebar";s:0:"";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(538, 269, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(539, 269, '_edit_lock', '1446655820:1'),
(540, 271, '_edit_last', '1'),
(541, 271, '_edit_lock', '1446655833:1'),
(542, 271, '_wp_page_template', 'default'),
(543, 271, '_wpb_vc_js_status', 'false'),
(544, 271, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(545, 271, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"0";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"full";s:30:"ozy_logistic_meta_page_sidebar";s:0:"";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}') ;
INSERT INTO `wp_postmeta` ( `meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
(546, 271, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(547, 273, '_menu_item_type', 'post_type'),
(548, 273, '_menu_item_menu_item_parent', '0'),
(549, 273, '_menu_item_object_id', '271'),
(550, 273, '_menu_item_object', 'page'),
(551, 273, '_menu_item_target', ''),
(552, 273, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(553, 273, '_menu_item_xfn', ''),
(554, 273, '_menu_item_url', ''),
(556, 274, '_menu_item_type', 'post_type'),
(557, 274, '_menu_item_menu_item_parent', '0'),
(558, 274, '_menu_item_object_id', '269'),
(559, 274, '_menu_item_object', 'page'),
(560, 274, '_menu_item_target', ''),
(561, 274, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(562, 274, '_menu_item_xfn', ''),
(563, 274, '_menu_item_url', ''),
(565, 275, '_menu_item_type', 'post_type'),
(566, 275, '_menu_item_menu_item_parent', '0'),
(567, 275, '_menu_item_object_id', '267'),
(568, 275, '_menu_item_object', 'page'),
(569, 275, '_menu_item_target', ''),
(570, 275, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(571, 275, '_menu_item_xfn', ''),
(572, 275, '_menu_item_url', ''),
(574, 276, '_menu_item_type', 'post_type'),
(575, 276, '_menu_item_menu_item_parent', '0'),
(576, 276, '_menu_item_object_id', '265'),
(577, 276, '_menu_item_object', 'page'),
(578, 276, '_menu_item_target', ''),
(579, 276, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(580, 276, '_menu_item_xfn', ''),
(581, 276, '_menu_item_url', ''),
(583, 277, '_menu_item_type', 'post_type'),
(584, 277, '_menu_item_menu_item_parent', '0'),
(585, 277, '_menu_item_object_id', '263'),
(586, 277, '_menu_item_object', 'page'),
(587, 277, '_menu_item_target', ''),
(588, 277, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(589, 277, '_menu_item_xfn', ''),
(590, 277, '_menu_item_url', ''),
(592, 278, '_menu_item_type', 'post_type'),
(593, 278, '_menu_item_menu_item_parent', '0'),
(594, 278, '_menu_item_object_id', '261'),
(595, 278, '_menu_item_object', 'page'),
(596, 278, '_menu_item_target', ''),
(597, 278, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(598, 278, '_menu_item_xfn', ''),
(599, 278, '_menu_item_url', ''),
(601, 279, '_menu_item_type', 'post_type'),
(602, 279, '_menu_item_menu_item_parent', '0'),
(603, 279, '_menu_item_object_id', '259'),
(604, 279, '_menu_item_object', 'page'),
(605, 279, '_menu_item_target', ''),
(606, 279, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(607, 279, '_menu_item_xfn', ''),
(608, 279, '_menu_item_url', ''),
(610, 279, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(611, 278, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(612, 277, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(613, 276, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(614, 275, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(615, 274, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(616, 273, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(617, 280, '_menu_item_type', 'custom'),
(618, 280, '_menu_item_menu_item_parent', '0'),
(619, 280, '_menu_item_object_id', '280'),
(620, 280, '_menu_item_object', 'custom'),
(621, 280, '_menu_item_target', ''),
(622, 280, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(623, 280, '_menu_item_xfn', ''),
(624, 280, '_menu_item_url', '#'),
(626, 280, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(627, 281, '_menu_item_type', 'custom'),
(628, 281, '_menu_item_menu_item_parent', '0'),
(629, 281, '_menu_item_object_id', '281'),
(630, 281, '_menu_item_object', 'custom'),
(631, 281, '_menu_item_target', ''),
(632, 281, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(633, 281, '_menu_item_xfn', ''),
(634, 281, '_menu_item_url', '#'),
(636, 281, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(637, 282, '_edit_last', '1'),
(638, 282, '_wp_page_template', 'default'),
(639, 282, '_wpb_vc_js_status', 'false'),
(640, 282, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(641, 282, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"0";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"full";s:30:"ozy_logistic_meta_page_sidebar";s:0:"";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(642, 282, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(643, 282, '_edit_lock', '1446656253:1'),
(644, 284, '_edit_last', '1'),
(645, 284, '_wp_page_template', 'default'),
(646, 284, '_wpb_vc_js_status', 'false'),
(647, 284, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(648, 284, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"0";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"full";s:30:"ozy_logistic_meta_page_sidebar";s:0:"";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(649, 284, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(650, 284, '_edit_lock', '1446656265:1'),
(651, 286, '_edit_last', '1'),
(652, 286, '_wp_page_template', 'default'),
(653, 286, '_wpb_vc_js_status', 'false'),
(654, 286, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}') ;
INSERT INTO `wp_postmeta` ( `meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
(655, 286, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"0";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"full";s:30:"ozy_logistic_meta_page_sidebar";s:0:"";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(656, 286, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(657, 286, '_edit_lock', '1446656291:1'),
(658, 288, '_edit_last', '1'),
(659, 288, '_edit_lock', '1446656333:1'),
(660, 288, '_wp_page_template', 'default'),
(661, 288, '_wpb_vc_js_status', 'false'),
(662, 288, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(663, 288, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"0";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"full";s:30:"ozy_logistic_meta_page_sidebar";s:0:"";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(664, 288, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(665, 291, '_edit_last', '1'),
(666, 291, '_wp_page_template', 'default'),
(667, 291, '_wpb_vc_js_status', 'false'),
(668, 291, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(669, 291, 'ozy_logistic_meta_page', 'a:19:{s:34:"ozy_logistic_meta_page_custom_menu";s:2:"-1";s:40:"ozy_logistic_meta_page_revolution_slider";s:2:"-1";s:36:"ozy_logistic_meta_page_master_slider";s:2:"-1";s:40:"ozy_logistic_meta_page_use_footer_slider";s:1:"0";s:46:"ozy_logistic_meta_page_use_footer_slider_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_revolution_footer_slider";s:2:"-1";s:43:"ozy_logistic_meta_page_master_footer_slider";s:2:"-1";}}s:34:"ozy_logistic_meta_page_show_loader";s:1:"0";s:45:"ozy_logistic_meta_page_hide_footer_widget_bar";s:2:"-1";s:33:"ozy_logistic_meta_page_hide_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_no_content_padding";s:1:"0";s:39:"ozy_logistic_meta_page_use_custom_title";s:1:"0";s:45:"ozy_logistic_meta_page_use_custom_title_group";a:1:{i:0;a:10:{s:44:"ozy_logistic_meta_page_custom_title_position";s:4:"left";s:35:"ozy_logistic_meta_page_custom_title";s:0:"";s:41:"ozy_logistic_meta_page_custom_title_color";s:0:"";s:39:"ozy_logistic_meta_page_custom_sub_title";s:0:"";s:45:"ozy_logistic_meta_page_custom_sub_title_color";s:0:"";s:43:"ozy_logistic_meta_page_custom_title_bgcolor";s:0:"";s:38:"ozy_logistic_meta_page_custom_title_bg";s:0:"";s:49:"ozy_logistic_meta_page_custom_title_bg_x_position";s:4:"left";s:49:"ozy_logistic_meta_page_custom_title_bg_y_position";s:3:"top";s:42:"ozy_logistic_meta_page_custom_title_height";s:3:"100";}}s:35:"ozy_logistic_meta_page_hide_content";s:1:"0";s:34:"ozy_logistic_meta_page_use_sidebar";s:1:"0";s:36:"ozy_logistic_meta_page_sidebar_group";a:1:{i:0;a:2:{s:39:"ozy_logistic_meta_page_sidebar_position";s:4:"full";s:30:"ozy_logistic_meta_page_sidebar";s:0:"";}}s:39:"ozy_logistic_meta_page_use_custom_style";s:1:"0";s:35:"ozy_logistic_meta_page_layout_group";a:1:{i:0;a:2:{s:47:"ozy_logistic_meta_page_layout_ascend_background";s:19:"rgba(255,255,255,1)";s:52:"ozy_logistic_meta_page_layout_transparent_background";s:1:"0";}}s:44:"ozy_logistic_meta_page_use_custom_background";s:1:"0";s:39:"ozy_logistic_meta_page_background_group";a:1:{i:0;a:17:{s:39:"ozy_logistic_meta_page_background_image";s:0:"";s:44:"ozy_logistic_meta_page_background_image_size";s:0:"";s:45:"ozy_logistic_meta_page_background_image_pos_x";s:4:"left";s:45:"ozy_logistic_meta_page_background_image_pos_y";s:3:"top";s:46:"ozy_logistic_meta_page_background_image_repeat";s:7:"inherit";s:50:"ozy_logistic_meta_page_background_image_attachment";s:0:"";s:39:"ozy_logistic_meta_page_background_color";s:7:"#ffffff";s:42:"ozy_logistic_meta_page_background_use_gmap";s:1:"0";s:44:"ozy_logistic_meta_page_background_gmap_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_gmap_address";s:0:"";}}s:44:"ozy_logistic_meta_page_background_use_slider";s:1:"0";s:46:"ozy_logistic_meta_page_background_slider_group";a:1:{i:0;a:1:{s:46:"ozy_logistic_meta_page_background_slider_image";s:0:"";}}s:48:"ozy_logistic_meta_page_background_use_video_self";s:1:"0";s:50:"ozy_logistic_meta_page_background_video_self_group";a:1:{i:0;a:4:{s:50:"ozy_logistic_meta_page_background_video_self_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_mp4";s:0:"";s:49:"ozy_logistic_meta_page_background_video_self_webm";s:0:"";s:48:"ozy_logistic_meta_page_background_video_self_ogv";s:0:"";}}s:51:"ozy_logistic_meta_page_background_use_video_youtube";s:1:"0";s:53:"ozy_logistic_meta_page_background_video_youtube_group";a:1:{i:0;a:2:{s:53:"ozy_logistic_meta_page_background_video_youtube_image";s:0:"";s:50:"ozy_logistic_meta_page_background_video_youtube_id";s:0:"";}}s:49:"ozy_logistic_meta_page_background_use_video_vimeo";s:1:"0";s:51:"ozy_logistic_meta_page_background_video_vimeo_group";a:1:{i:0;a:2:{s:51:"ozy_logistic_meta_page_background_video_vimeo_image";s:0:"";s:48:"ozy_logistic_meta_page_background_video_vimeo_id";s:0:"";}}}}s:33:"ozy_logistic_meta_page_page_model";s:7:"generic";}'),
(670, 291, 'ozy_logistic_meta_page_blog', 'a:2:{s:36:"ozy_logistic_meta_page_blog_category";a:1:{i:0;s:2:"-1";}s:33:"ozy_logistic_meta_page_blog_order";s:9:"date-desc";}'),
(671, 291, '_edit_lock', '1446656349:1'),
(672, 293, '_menu_item_type', 'post_type'),
(673, 293, '_menu_item_menu_item_parent', '0'),
(674, 293, '_menu_item_object_id', '286'),
(675, 293, '_menu_item_object', 'page'),
(676, 293, '_menu_item_target', ''),
(677, 293, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(678, 293, '_menu_item_xfn', ''),
(679, 293, '_menu_item_url', ''),
(681, 294, '_menu_item_type', 'post_type'),
(682, 294, '_menu_item_menu_item_parent', '0'),
(683, 294, '_menu_item_object_id', '284'),
(684, 294, '_menu_item_object', 'page'),
(685, 294, '_menu_item_target', ''),
(686, 294, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(687, 294, '_menu_item_xfn', ''),
(688, 294, '_menu_item_url', ''),
(690, 295, '_menu_item_type', 'post_type'),
(691, 295, '_menu_item_menu_item_parent', '0'),
(692, 295, '_menu_item_object_id', '282'),
(693, 295, '_menu_item_object', 'page'),
(694, 295, '_menu_item_target', ''),
(695, 295, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(696, 295, '_menu_item_xfn', ''),
(697, 295, '_menu_item_url', ''),
(699, 281, 'menu-item-style', '{"is_form":"0","html_content":"","bg_color":"#000000","fn_color":"","border_color":"","character_issues":"0","border_width":"0"}'),
(700, 295, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(701, 294, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(702, 293, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(703, 296, '_menu_item_type', 'custom'),
(704, 296, '_menu_item_menu_item_parent', '0'),
(705, 296, '_menu_item_object_id', '296'),
(706, 296, '_menu_item_object', 'custom'),
(707, 296, '_menu_item_target', ''),
(708, 296, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(709, 296, '_menu_item_xfn', ''),
(710, 296, '_menu_item_url', '#'),
(712, 297, '_menu_item_type', 'post_type'),
(713, 297, '_menu_item_menu_item_parent', '0'),
(714, 297, '_menu_item_object_id', '291'),
(715, 297, '_menu_item_object', 'page'),
(716, 297, '_menu_item_target', ''),
(717, 297, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(718, 297, '_menu_item_xfn', ''),
(719, 297, '_menu_item_url', ''),
(721, 298, '_menu_item_type', 'post_type'),
(722, 298, '_menu_item_menu_item_parent', '0'),
(723, 298, '_menu_item_object_id', '288'),
(724, 298, '_menu_item_object', 'page'),
(725, 298, '_menu_item_target', ''),
(726, 298, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
(727, 298, '_menu_item_xfn', ''),
(728, 298, '_menu_item_url', ''),
(730, 296, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(731, 298, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(732, 297, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(733, 6, '_wpb_post_custom_css', '\r\n\r\n.ozy-simlple-info-box>section {\r\n    min-height: 278px;\r\n}\r\n\r\n\r\n.ozy-simlple-info-box>section a {\r\n    position: absolute;\r\n    bottom: 22px;\r\n}\r\n\r\n.ozy-news-bar>ul>li:first-child {\r\n    padding-left: 0;\r\n}\r\n\r\n.ozy-news-bar>ul>li:first-child h1 {\r\n    font-family:"Hind-Bold" !important;\r\n    font-size: 50px !important;\r\n}\r\n\r\n.ozy-news-bar>ul>li:first-child>h2 {\r\n    font-family:"Hind-Regular" !important;\r\n    font-size: 30px !important;\r\n}\r\n\r\n.ozy-news-bar>ul>li:first-child>a {\r\n    font-family:"Hind-Regular" !important;\r\n    font-size: 12px !important;\r\n}\r\n\r\n.ozy-news-bar>ul>li a {\r\n    font-family:"Hind-Bold" !important;\r\n    font-size: 16px !important;\r\n}\r\n\r\n\r\n\r\n\r\n'),
(734, 311, '_wp_attached_file', '2015/11/block-industrie.png'),
(735, 311, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:280;s:6:"height";i:249;s:4:"file";s:27:"2015/11/block-industrie.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:27:"block-industrie-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:11:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";s:11:"orientation";i:0;}}'),
(736, 312, '_wp_attached_file', '2015/11/block-solution.png'),
(737, 312, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:280;s:6:"height";i:249;s:4:"file";s:26:"2015/11/block-solution.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"block-solution-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:11:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";s:11:"orientation";i:0;}}'),
(738, 313, '_wp_attached_file', '2015/11/block-etude.png'),
(739, 313, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:280;s:6:"height";i:249;s:4:"file";s:23:"2015/11/block-etude.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"block-etude-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:11:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";s:11:"orientation";i:0;}}'),
(740, 314, '_wp_attached_file', '2015/11/block-eco-conception.png'),
(741, 314, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:280;s:6:"height";i:249;s:4:"file";s:32:"2015/11/block-eco-conception.png";s:5:"sizes";a:1:{s:9:"thumbnail";a:4:{s:4:"file";s:32:"block-eco-conception-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:11:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";s:11:"orientation";i:0;}}'),
(742, 45, '_wpb_post_custom_css', '#mip_societe_section1 h3 {\r\n    font-family:"Hind-Semibold" !important;\r\n    font-size: 25px !important;\r\n    color: #0267c1 !important;\r\n}\r\n\r\n#mip_societe_section1 h5 {\r\n    font-family:"Hind-Semibold" !important;\r\n    font-size: 18px !important;\r\n    color: #0a0912 !important;\r\n}\r\n\r\n#mip_societe_section2 h3 {\r\n    font-family:"Hind-Semibold" !important;\r\n    font-size: 25px !important;\r\n    color: #0a0912 !important;\r\n    text-transform: uppercase;\r\n}\r\n\r\n#mip_societe_section3 h3 {\r\n    font-family:"Hind-Semibold" !important;\r\n    font-size: 25px !important;\r\n    color: #0a0912 !important; \r\n    text-transform: uppercase;\r\n}\r\n\r\n#mip_societe_section3 .vc_tta-title-text {\r\n    font-family:"Hind-Regular" !important;\r\n    font-size: 14px !important;\r\n    color: #000000;\r\n}\r\n\r\n#mip_societe_section3 .wpb_wrapper {\r\n    font-family:"Hind-Regular" !important;\r\n    font-size: 14px !important;\r\n}\r\n\r\n#mip_societe_section3 .testimonial {\r\n    font-family:"Hind-Regular" !important;\r\n    font-size: 25px !important;\r\n}'),
(745, 382, '_wp_attached_file', '2015/11/produits1.jpg'),
(746, 382, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1272;s:6:"height";i:679;s:4:"file";s:21:"2015/11/produits1.jpg";s:5:"sizes";a:6:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"produits1-150x150.jpg";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:10:"image/jpeg";}s:6:"medium";a:4:{s:4:"file";s:21:"produits1-300x160.jpg";s:5:"width";i:300;s:6:"height";i:160;s:9:"mime-type";s:10:"image/jpeg";}s:5:"large";a:4:{s:4:"file";s:22:"produits1-1024x547.jpg";s:5:"width";i:1024;s:6:"height";i:547;s:9:"mime-type";s:10:"image/jpeg";}s:8:"boxyboxy";a:4:{s:4:"file";s:21:"produits1-480x480.jpg";s:5:"width";i:480;s:6:"height";i:480;s:9:"mime-type";s:10:"image/jpeg";}s:7:"showbiz";a:4:{s:4:"file";s:21:"produits1-720x679.jpg";s:5:"width";i:720;s:6:"height";i:679;s:9:"mime-type";s:10:"image/jpeg";}s:4:"blog";a:4:{s:4:"file";s:22:"produits1-1144x611.jpg";s:5:"width";i:1144;s:6:"height";i:611;s:9:"mime-type";s:10:"image/jpeg";}}s:10:"image_meta";a:11:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";s:11:"orientation";i:0;}}'),
(747, 141, '_wpb_post_custom_css', '#mip_univers_section2 h3 {\r\n    font-family:"Hind-Semibold" !important;\r\n    font-size: 25px !important;\r\n    text-transform: uppercase;\r\n    color: #0a0912;\r\n}\r\n'),
(748, 280, 'menu-item-style', '{"is_form":"0","html_content":"","bg_color":"","fn_color":"","border_color":"","character_issues":"0","border_width":"2px"}'),
(749, 393, '_wp_attached_file', '2015/11/operator1.png'),
(750, 393, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:318;s:6:"height";i:230;s:4:"file";s:21:"2015/11/operator1.png";s:5:"sizes";a:2:{s:9:"thumbnail";a:4:{s:4:"file";s:21:"operator1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"operator1-300x217.png";s:5:"width";i:300;s:6:"height";i:217;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:11:{s:8:"aperture";i:0;s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";i:0;s:9:"copyright";s:0:"";s:12:"focal_length";i:0;s:3:"iso";i:0;s:13:"shutter_speed";i:0;s:5:"title";s:0:"";s:11:"orientation";i:0;}}'),
(751, 4, '_vc_post_settings', 'a:1:{s:10:"vc_grid_id";a:0:{}}'),
(752, 54, '_wpb_shortcodes_custom_css', '.vc_custom_1446816735907{margin-top: 0px !important;margin-right: 0px !important;margin-bottom: 0px !important;margin-left: 0px !important;padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}') ;

#
# End of data contents of table `wp_postmeta`
# --------------------------------------------------------



#
# Delete any existing table `wp_posts`
#

DROP TABLE IF EXISTS `wp_posts`;


#
# Table structure of table `wp_posts`
#

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=408 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


#
# Data contents of table `wp_posts`
#
INSERT INTO `wp_posts` ( `ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(3, 1, '2015-11-03 13:39:49', '0000-00-00 00:00:00', '', 'Auto Draft', '', 'auto-draft', 'open', 'open', '', '', '', '', '2015-11-03 13:39:49', '0000-00-00 00:00:00', '', 0, 'http://micronics.votresitedemo.com/?p=3', 0, 'post', '', 0),
(4, 1, '2015-11-03 14:02:19', '2015-11-03 14:02:19', '<p>NAME (REQUIRED)<br />\r\n    [text* your-name] </p>\r\n\r\n<p>EMAIL (REQUIRED)<br />\r\n    [email* your-email] </p>\r\n\r\n<p>SUBJECT<br />\r\n    [text your-subject] </p>\r\n\r\n<p>YOUR MESSAGE<br />\r\n    [textarea your-message] </p>\r\n\r\n<p>[submit "SEND"]</p>\n[your-subject]\n[your-name] <wordpress@micronics.fr>\nFrom: [your-name] <[your-email]>\r\nSubject: [your-subject]\r\n\r\nMessage Body:\r\n[your-message]\r\n\r\n--\r\nThis e-mail was sent from a contact form on Micronics Systems (http://micronics.votresitedemo.com)\nfd@mobi-pronet.com\nReply-To: [your-email]\n\n\n\n\n[your-subject]\nMicronics Systems <wordpress@micronics.fr>\nMessage Body:\r\n[your-message]\r\n\r\n--\r\nThis e-mail was sent from a contact form on Micronics Systems (http://micronics.votresitedemo.com)\n[your-email]\nReply-To: fd@mobi-pronet.com\n\n\n\nYour message was sent successfully. Thanks.\nFailed to send your message. Please try later or contact the administrator by another method.\nValidation errors occurred. Please confirm the fields and submit it again.\nFailed to send your message. Please try later or contact the administrator by another method.\nPlease accept the terms to proceed.\nPlease fill in the required field.\nThis input is too long.\nThis input is too short.\nDate format seems invalid.\nThis date is too early.\nThis date is too late.\nFailed to upload file.\nThis file type is not allowed.\nThis file is too large.\nFailed to upload file. Error occurred.\nNumber format seems invalid.\nThis number is too small.\nThis number is too large.\nYour answer is not correct.\nEmail address seems invalid.\nURL seems invalid.\nTelephone number seems invalid.', 'Contact form 1', '', 'publish', 'closed', 'closed', '', 'contact-form-1', '', '', '2015-11-06 13:19:47', '2015-11-06 13:19:47', '', 0, 'http://micronics.votresitedemo.com/?post_type=wpcf7_contact_form&#038;p=4', 0, 'wpcf7_contact_form', '', 0),
(6, 1, '2015-11-04 07:55:20', '2015-11-04 07:55:20', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446798115356{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner css=".vc_custom_1446797669437{padding-bottom: 20px !important;}"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes" css=".vc_custom_1446797743170{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'publish', 'closed', 'closed', '', 'accueil', '', '', '2015-11-06 11:20:19', '2015-11-06 11:20:19', '', 0, 'http://micronics.votresitedemo.com/?page_id=6', 0, 'page', '', 0),
(7, 1, '2015-11-04 07:55:20', '2015-11-04 07:55:20', '', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 07:55:20', '2015-11-04 07:55:20', '', 6, 'http://micronics.votresitedemo.com/index.php/2015/11/04/6-revision-v1/', 0, 'revision', '', 0),
(8, 1, '2015-11-06 08:16:47', '2015-11-06 08:16:47', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446797498341{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner css=".vc_custom_1446797669437{padding-bottom: 20px !important;}"][vc_custom_heading text="SPÉCIALISTE\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes" css=".vc_custom_1446797743170{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446797681500{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\nMétallurgie\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\n\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\nTest Bench\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-autosave-v1', '', '', '2015-11-06 08:16:47', '2015-11-06 08:16:47', '', 6, 'http://micronics.votresitedemo.com/index.php/2015/11/04/6-autosave-v1/', 0, 'revision', '', 0),
(10, 1, '2015-11-04 08:16:30', '2015-11-04 08:16:30', '[vc_row][vc_column][vc_custom_heading text="PROVIDING FIRST CLASS FREIGHT SERVICES"][vc_column_text]\r\n<h4 style="text-align: center;">LOGISTIC HELPS YOU REALISE YOUR BUSINESS GOALS</h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 08:16:30', '2015-11-04 08:16:30', '', 6, 'http://micronics.votresitedemo.com/index.php/2015/11/04/6-revision-v1/', 0, 'revision', '', 0),
(13, 1, '2015-11-04 08:23:10', '2015-11-04 08:23:10', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="12" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="PROVIDING FIRST CLASS FREIGHT SERVICES"][vc_column_text]\r\n<h4 style="text-align: center;">LOGISTIC HELPS YOU REALISE YOUR BUSINESS GOALS</h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 08:23:10', '2015-11-04 08:23:10', '', 6, 'http://micronics.votresitedemo.com/index.php/2015/11/04/6-revision-v1/', 0, 'revision', '', 0),
(15, 1, '2015-11-04 08:24:51', '2015-11-04 08:24:51', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="PROVIDING FIRST CLASS FREIGHT SERVICES"][vc_column_text]\r\n<h4 style="text-align: center;">LOGISTIC HELPS YOU REALISE YOUR BUSINESS GOALS</h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 08:24:51', '2015-11-04 08:24:51', '', 6, 'http://micronics.votresitedemo.com/index.php/2015/11/04/6-revision-v1/', 0, 'revision', '', 0),
(16, 1, '2015-11-04 08:26:37', '2015-11-04 08:26:37', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="PROVIDING FIRST CLASS FREIGHT SERVICES"][vc_column_text]\r\n<h4 style="text-align: center;">LOGISTIC HELPS YOU REALISE YOUR BUSINESS GOALS</h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="AT A GLANCE" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="AT A GLANCE" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="SPEED FOR YOUR GOODS" title="Air Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="CLEVERLY COMBINED" title="Sea Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 08:26:37', '2015-11-04 08:26:37', '', 6, 'http://micronics.votresitedemo.com/index.php/2015/11/04/6-revision-v1/', 0, 'revision', '', 0),
(17, 1, '2015-11-04 08:27:29', '2015-11-04 08:27:29', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="PROVIDING FIRST CLASS FREIGHT SERVICES" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;">LOGISTIC HELPS YOU REALISE YOUR BUSINESS GOALS</h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="AT A GLANCE" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="AT A GLANCE" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="SPEED FOR YOUR GOODS" title="Air Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="CLEVERLY COMBINED" title="Sea Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 08:27:29', '2015-11-04 08:27:29', '', 6, 'http://micronics.votresitedemo.com/index.php/2015/11/04/6-revision-v1/', 0, 'revision', '', 0),
(18, 1, '2015-11-04 08:27:50', '2015-11-04 08:27:50', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="PROVIDING FIRST CLASS FREIGHT SERVICES" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4>LOGISTIC HELPS YOU REALISE YOUR BUSINESS GOALS</h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="AT A GLANCE" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="AT A GLANCE" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="SPEED FOR YOUR GOODS" title="Air Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="CLEVERLY COMBINED" title="Sea Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 08:27:50', '2015-11-04 08:27:50', '', 6, 'http://micronics.votresitedemo.com/index.php/2015/11/04/6-revision-v1/', 0, 'revision', '', 0),
(19, 1, '2015-11-04 08:28:12', '2015-11-04 08:28:12', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="PROVIDING FIRST CLASS FREIGHT SERVICES" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;">LOGISTIC HELPS YOU REALISE YOUR BUSINESS GOALS</h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="AT A GLANCE" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="AT A GLANCE" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="SPEED FOR YOUR GOODS" title="Air Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="CLEVERLY COMBINED" title="Sea Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 08:28:12', '2015-11-04 08:28:12', '', 6, 'http://micronics.votresitedemo.com/index.php/2015/11/04/6-revision-v1/', 0, 'revision', '', 0),
(20, 1, '2015-11-04 08:28:39', '2015-11-04 08:28:39', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="PROVIDING FIRST CLASS FREIGHT SERVICES" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">LOGISTIC HELPS YOU REALISE YOUR BUSINESS GOALS</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="AT A GLANCE" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="AT A GLANCE" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="SPEED FOR YOUR GOODS" title="Air Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="CLEVERLY COMBINED" title="Sea Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 08:28:39', '2015-11-04 08:28:39', '', 6, 'http://micronics.votresitedemo.com/index.php/2015/11/04/6-revision-v1/', 0, 'revision', '', 0),
(22, 1, '2015-11-04 08:56:28', '2015-11-04 08:56:28', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="PROVIDING FIRST CLASS FREIGHT SERVICES" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">LOGISTIC HELPS YOU REALISE YOUR BUSINESS GOALS</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="AT A GLANCE" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="AT A GLANCE" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="SPEED FOR YOUR GOODS" title="Air Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="CLEVERLY COMBINED" title="Sea Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 08:56:28', '2015-11-04 08:56:28', '', 6, 'http://micronics.votresitedemo.com/index.php/2015/11/04/6-revision-v1/', 0, 'revision', '', 0),
(24, 1, '2015-11-04 08:59:14', '2015-11-04 08:59:14', 'Dentelles promenade oh firmament camarades qu eu. Ou claquaient au estaminets du en retrouvait. Vieillards de en ma clairieres on paraissait. On fervente du oh la galopent premiere. Frontiere ca servantes le superieur carabines murmurait. Singuliers bleuissent par par ils souhaitait oui grouillent revolution. Carre masse celui vie ses mon son. Caillou iii air surprit ere ennemie cuivres apercut general ils. Sur hauts notre femme image des rente fut eux.', 'Alimentations stabilisées - Type microlab', '', 'publish', 'open', 'open', '', 'alimentations-stabilisees-type-microlab', '', '', '2015-11-04 09:00:37', '2015-11-04 09:00:37', '', 0, 'http://micronics.votresitedemo.com/?p=24', 0, 'post', '', 0),
(25, 1, '2015-11-04 08:59:14', '2015-11-04 08:59:14', '', 'Alimentations stabilisées - Type microlab', '', 'inherit', 'closed', 'closed', '', '24-revision-v1', '', '', '2015-11-04 08:59:14', '2015-11-04 08:59:14', '', 24, 'http://micronics.votresitedemo.com/index.php/2015/11/04/24-revision-v1/', 0, 'revision', '', 0),
(26, 1, '2015-11-04 08:59:30', '2015-11-04 08:59:30', 'Signalant te direction epluchant defensive tiendrons or. Eut ces escorte justice prepare maigres courbes prenons ils. Servantes couraient situation sacrifiez regardent des oui. Selon tenez sacre ai ce pente je. Qui ces vin tres avec non haut dans pour mais. Ouvre son rirez moi foi quels vieil. Eux lui nuit jet chez sans pile ras. Je entourage cependant polygones affection me du.', 'Redresseur autonome pour métaux précieux', '', 'publish', 'open', 'open', '', 'redresseur-autonome-pour-metaux-precieux', '', '', '2015-11-04 09:00:29', '2015-11-04 09:00:29', '', 0, 'http://micronics.votresitedemo.com/?p=26', 0, 'post', '', 0),
(27, 1, '2015-11-04 08:59:30', '2015-11-04 08:59:30', '', 'Redresseur autonome pour métaux précieux', '', 'inherit', 'closed', 'closed', '', '26-revision-v1', '', '', '2015-11-04 08:59:30', '2015-11-04 08:59:30', '', 26, 'http://micronics.votresitedemo.com/index.php/2015/11/04/26-revision-v1/', 0, 'revision', '', 0),
(28, 1, '2015-11-04 08:59:42', '2015-11-04 08:59:42', 'Moi ces annees sortit ombres pic enleve. Entrainait legerement par remarquent bon. Les langage art son puisque sourire. Sourire me en occupee charges surpris souffle on abattit. Escorte ils but stupide enormes. Pitie sur quand dut halte metal son mur. Va creve oh galop ah pense qu. Partout semence va ca la or lorgnez epouses dechire.', 'Nouveau : redresseur de courant double sortie', '', 'publish', 'open', 'open', '', 'nouveau-redresseur-de-courant-double-sortie', '', '', '2015-11-04 09:00:13', '2015-11-04 09:00:13', '', 0, 'http://micronics.votresitedemo.com/?p=28', 0, 'post', '', 0),
(29, 1, '2015-11-04 08:59:42', '2015-11-04 08:59:42', '', 'Nouveau : redresseur de courant double sortie', '', 'inherit', 'closed', 'closed', '', '28-revision-v1', '', '', '2015-11-04 08:59:42', '2015-11-04 08:59:42', '', 28, 'http://micronics.votresitedemo.com/index.php/2015/11/04/28-revision-v1/', 0, 'revision', '', 0),
(30, 1, '2015-11-04 09:00:07', '2015-11-04 09:00:07', 'Moi ces annees sortit ombres pic enleve. Entrainait legerement par remarquent bon. Les langage art son puisque sourire. Sourire me en occupee charges surpris souffle on abattit. Escorte ils but stupide enormes. Pitie sur quand dut halte metal son mur. Va creve oh galop ah pense qu. Partout semence va ca la or lorgnez epouses dechire.', 'Nouveau : redresseur de courant double sortie', '', 'inherit', 'closed', 'closed', '', '28-revision-v1', '', '', '2015-11-04 09:00:07', '2015-11-04 09:00:07', '', 28, 'http://micronics.votresitedemo.com/index.php/2015/11/04/28-revision-v1/', 0, 'revision', '', 0),
(31, 1, '2015-11-04 09:00:22', '2015-11-04 09:00:22', 'Signalant te direction epluchant defensive tiendrons or. Eut ces escorte justice prepare maigres courbes prenons ils. Servantes couraient situation sacrifiez regardent des oui. Selon tenez sacre ai ce pente je. Qui ces vin tres avec non haut dans pour mais. Ouvre son rirez moi foi quels vieil. Eux lui nuit jet chez sans pile ras. Je entourage cependant polygones affection me du.', 'Redresseur autonome pour métaux précieux', '', 'inherit', 'closed', 'closed', '', '26-revision-v1', '', '', '2015-11-04 09:00:22', '2015-11-04 09:00:22', '', 26, 'http://micronics.votresitedemo.com/index.php/2015/11/04/26-revision-v1/', 0, 'revision', '', 0),
(32, 1, '2015-11-04 09:00:37', '2015-11-04 09:00:37', 'Dentelles promenade oh firmament camarades qu eu. Ou claquaient au estaminets du en retrouvait. Vieillards de en ma clairieres on paraissait. On fervente du oh la galopent premiere. Frontiere ca servantes le superieur carabines murmurait. Singuliers bleuissent par par ils souhaitait oui grouillent revolution. Carre masse celui vie ses mon son. Caillou iii air surprit ere ennemie cuivres apercut general ils. Sur hauts notre femme image des rente fut eux.', 'Alimentations stabilisées - Type microlab', '', 'inherit', 'closed', 'closed', '', '24-revision-v1', '', '', '2015-11-04 09:00:37', '2015-11-04 09:00:37', '', 24, 'http://micronics.votresitedemo.com/index.php/2015/11/04/24-revision-v1/', 0, 'revision', '', 0),
(33, 1, '2015-11-04 09:16:01', '2015-11-04 09:16:01', '', 'Lien1', '', 'publish', 'closed', 'closed', '', 'lien1', '', '', '2015-11-04 09:16:01', '2015-11-04 09:16:01', '', 0, 'http://micronics.votresitedemo.com/?p=33', 1, 'nav_menu_item', '', 0),
(34, 1, '2015-11-04 09:16:01', '2015-11-04 09:16:01', '', 'Lien2', '', 'publish', 'closed', 'closed', '', 'lien2', '', '', '2015-11-04 09:16:01', '2015-11-04 09:16:01', '', 0, 'http://micronics.votresitedemo.com/?p=34', 2, 'nav_menu_item', '', 0),
(35, 1, '2015-11-04 09:16:01', '2015-11-04 09:16:01', '', 'Lien3', '', 'publish', 'closed', 'closed', '', 'lien3', '', '', '2015-11-04 09:16:01', '2015-11-04 09:16:01', '', 0, 'http://micronics.votresitedemo.com/?p=35', 3, 'nav_menu_item', '', 0),
(36, 1, '2015-11-04 09:16:01', '2015-11-04 09:16:01', '', 'Lien4', '', 'publish', 'closed', 'closed', '', 'lien4', '', '', '2015-11-04 09:16:01', '2015-11-04 09:16:01', '', 0, 'http://micronics.votresitedemo.com/?p=36', 4, 'nav_menu_item', '', 0),
(37, 1, '2015-11-04 09:16:01', '2015-11-04 09:16:01', '', 'Lien5', '', 'publish', 'closed', 'closed', '', 'lien5', '', '', '2015-11-04 09:16:01', '2015-11-04 09:16:01', '', 0, 'http://micronics.votresitedemo.com/?p=37', 5, 'nav_menu_item', '', 0),
(38, 1, '2015-11-04 09:16:21', '0000-00-00 00:00:00', '', 'Lien10', '', 'draft', 'closed', 'closed', '', '', '', '', '2015-11-04 09:16:21', '0000-00-00 00:00:00', '', 0, 'http://micronics.votresitedemo.com/?p=38', 1, 'nav_menu_item', '', 0),
(39, 1, '2015-11-04 09:17:00', '2015-11-04 09:17:00', '', 'Lien11', '', 'publish', 'closed', 'closed', '', 'lien11', '', '', '2015-11-04 09:17:00', '2015-11-04 09:17:00', '', 0, 'http://micronics.votresitedemo.com/?p=39', 1, 'nav_menu_item', '', 0),
(40, 1, '2015-11-04 09:17:00', '2015-11-04 09:17:00', '', 'Lien12', '', 'publish', 'closed', 'closed', '', 'lien12', '', '', '2015-11-04 09:17:00', '2015-11-04 09:17:00', '', 0, 'http://micronics.votresitedemo.com/?p=40', 2, 'nav_menu_item', '', 0),
(41, 1, '2015-11-04 09:17:00', '2015-11-04 09:17:00', '', 'Lien13', '', 'publish', 'closed', 'closed', '', 'lien13', '', '', '2015-11-04 09:17:00', '2015-11-04 09:17:00', '', 0, 'http://micronics.votresitedemo.com/?p=41', 3, 'nav_menu_item', '', 0),
(42, 1, '2015-11-04 09:17:00', '2015-11-04 09:17:00', '', 'Lien14', '', 'publish', 'closed', 'closed', '', 'lien14', '', '', '2015-11-04 09:17:00', '2015-11-04 09:17:00', '', 0, 'http://micronics.votresitedemo.com/?p=42', 4, 'nav_menu_item', '', 0),
(43, 1, '2015-11-04 09:17:00', '2015-11-04 09:17:00', '', 'Lien15', '', 'publish', 'closed', 'closed', '', 'lien15', '', '', '2015-11-04 09:17:00', '2015-11-04 09:17:00', '', 0, 'http://micronics.votresitedemo.com/?p=43', 5, 'nav_menu_item', '', 0),
(45, 1, '2015-11-04 09:30:01', '2015-11-04 09:30:01', '[vc_row css=".vc_custom_1446805109031{padding-top: 40px !important;}" el_id="mip_societe_section1"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446805435087{background-color: #efeff2 !important;}" el_id="mip_societe_section2"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text css=".vc_custom_1446805689580{padding-top: 20px !important;}"]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row el_id="mip_societe_section3"][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs shape="square" color="white" autoplay="10" active_section="1" no_fill_content_area="true"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'publish', 'closed', 'closed', '', 'societe', '', '', '2015-11-06 11:19:40', '2015-11-06 11:19:40', '', 0, 'http://micronics.votresitedemo.com/?page_id=45', 0, 'page', '', 0),
(46, 1, '2015-11-04 09:30:01', '2015-11-04 09:30:01', '', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 09:30:01', '2015-11-04 09:30:01', '', 45, 'http://micronics.votresitedemo.com/index.php/2015/11/04/45-revision-v1/', 0, 'revision', '', 0),
(47, 1, '2015-11-04 09:30:37', '2015-11-04 09:30:37', '', 'SOCIÉTÉ', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 09:30:37', '2015-11-04 09:30:37', '', 45, 'http://micronics.votresitedemo.com/index.php/2015/11/04/45-revision-v1/', 0, 'revision', '', 0),
(48, 1, '2015-11-04 09:31:31', '2015-11-04 09:31:31', '', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 09:31:31', '2015-11-04 09:31:31', '', 45, 'http://micronics.votresitedemo.com/index.php/2015/11/04/45-revision-v1/', 0, 'revision', '', 0),
(49, 1, '2015-11-04 09:31:40', '2015-11-04 09:31:40', '', 'Secteurs d’activité', '', 'publish', 'closed', 'closed', '', 'secteurs-dactivite', '', '', '2015-11-04 09:31:40', '2015-11-04 09:31:40', '', 0, 'http://micronics.votresitedemo.com/?page_id=49', 0, 'page', '', 0),
(50, 1, '2015-11-04 09:31:40', '2015-11-04 09:31:40', '', 'Secteurs d’activité', '', 'inherit', 'closed', 'closed', '', '49-revision-v1', '', '', '2015-11-04 09:31:40', '2015-11-04 09:31:40', '', 49, 'http://micronics.votresitedemo.com/index.php/2015/11/04/49-revision-v1/', 0, 'revision', '', 0),
(51, 1, '2015-11-04 09:31:48', '2015-11-04 09:31:48', '', 'Service & support', '', 'publish', 'closed', 'closed', '', 'produits', '', '', '2015-11-04 09:32:01', '2015-11-04 09:32:01', '', 0, 'http://micronics.votresitedemo.com/?page_id=51', 0, 'page', '', 0),
(52, 1, '2015-11-04 09:31:48', '2015-11-04 09:31:48', '', 'Produits', '', 'inherit', 'closed', 'closed', '', '51-revision-v1', '', '', '2015-11-04 09:31:48', '2015-11-04 09:31:48', '', 51, 'http://micronics.votresitedemo.com/index.php/2015/11/04/51-revision-v1/', 0, 'revision', '', 0),
(53, 1, '2015-11-04 09:32:01', '2015-11-04 09:32:01', '', 'Service & support', '', 'inherit', 'closed', 'closed', '', '51-revision-v1', '', '', '2015-11-04 09:32:01', '2015-11-04 09:32:01', '', 51, 'http://micronics.votresitedemo.com/index.php/2015/11/04/51-revision-v1/', 0, 'revision', '', 0),
(54, 1, '2015-11-04 09:32:12', '2015-11-04 09:32:12', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h5 style="text-align: left;">LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][vc_single_image image="133" img_size="medium" alignment="center"][/vc_column][/vc_row][vc_row row_fullwidth="1" row_zero_column_space="1" css=".vc_custom_1446816735907{margin-top: 0px !important;margin-right: 0px !important;margin-bottom: 0px !important;margin-left: 0px !important;padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][vc_column][ozy_vc_prettymap address="Micronics Systems, Rue des Émeraudes, Villette-d\'Anthon, France" custom_icon="77" hue=""][/vc_column][/vc_row]', 'Contact', '', 'publish', 'closed', 'closed', '', 'contact', '', '', '2015-11-06 13:46:11', '2015-11-06 13:46:11', '', 0, 'http://micronics.votresitedemo.com/?page_id=54', 0, 'page', '', 0),
(55, 1, '2015-11-04 09:32:12', '2015-11-04 09:32:12', '', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-04 09:32:12', '2015-11-04 09:32:12', '', 54, 'http://micronics.votresitedemo.com/index.php/2015/11/04/54-revision-v1/', 0, 'revision', '', 0),
(56, 1, '2015-11-04 09:32:55', '2015-11-04 09:32:55', '', 'CONTACT', '', 'publish', 'closed', 'closed', '', '56', '', '', '2015-11-04 13:26:12', '2015-11-04 13:26:12', '', 0, 'http://micronics.votresitedemo.com/?p=56', 5, 'nav_menu_item', '', 0),
(57, 1, '2015-11-04 09:32:55', '2015-11-04 09:32:55', '', 'SERVICE & SUPPORT', '', 'publish', 'closed', 'closed', '', '57', '', '', '2015-11-04 13:26:12', '2015-11-04 13:26:12', '', 0, 'http://micronics.votresitedemo.com/?p=57', 4, 'nav_menu_item', '', 0),
(58, 1, '2015-11-04 09:32:55', '2015-11-04 09:32:55', '', 'SECTEURS D’ACTIVITÉ', '', 'publish', 'closed', 'closed', '', '58', '', '', '2015-11-04 13:26:12', '2015-11-04 13:26:12', '', 0, 'http://micronics.votresitedemo.com/?p=58', 2, 'nav_menu_item', '', 0),
(59, 1, '2015-11-04 09:32:55', '2015-11-04 09:32:55', '', 'SOCIÉTÉ', '', 'publish', 'closed', 'closed', '', '59', '', '', '2015-11-04 13:26:12', '2015-11-04 13:26:12', '', 0, 'http://micronics.votresitedemo.com/?p=59', 1, 'nav_menu_item', '', 0),
(60, 1, '2015-11-04 09:33:07', '2015-11-04 09:33:07', '', 'Produits', '', 'publish', 'closed', 'closed', '', 'produits-2', '', '', '2015-11-04 14:56:41', '2015-11-04 14:56:41', '', 0, 'http://micronics.votresitedemo.com/?page_id=60', 0, 'page', '', 0),
(61, 1, '2015-11-04 09:33:07', '2015-11-04 09:33:07', '', 'Produits', '', 'inherit', 'closed', 'closed', '', '60-revision-v1', '', '', '2015-11-04 09:33:07', '2015-11-04 09:33:07', '', 60, 'http://micronics.votresitedemo.com/index.php/2015/11/04/60-revision-v1/', 0, 'revision', '', 0),
(62, 1, '2015-11-04 09:33:37', '2015-11-04 09:33:37', '', 'PRODUITS', '', 'publish', 'closed', 'closed', '', '62', '', '', '2015-11-04 13:26:12', '2015-11-04 13:26:12', '', 0, 'http://micronics.votresitedemo.com/?p=62', 3, 'nav_menu_item', '', 0),
(63, 1, '2015-11-04 09:34:58', '0000-00-00 00:00:00', ' ', '', '', 'draft', 'closed', 'closed', '', '', '', '', '2015-11-04 09:34:58', '0000-00-00 00:00:00', '', 0, 'http://micronics.votresitedemo.com/?p=63', 1, 'nav_menu_item', '', 0),
(64, 1, '2015-11-04 09:44:47', '2015-11-04 09:44:47', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="spécialiste en conversion d’énergie" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">LOGISTIC HELPS YOU REALISE YOUR BUSINESS GOALS</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="AT A GLANCE" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="AT A GLANCE" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="SPEED FOR YOUR GOODS" title="Air Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="CLEVERLY COMBINED" title="Sea Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 09:44:47', '2015-11-04 09:44:47', '', 6, 'http://micronics.votresitedemo.com/?p=64', 0, 'revision', '', 0),
(65, 1, '2015-11-04 09:46:29', '2015-11-04 09:46:29', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;">MICRONICS SYSTEMS</h4>\r\n<h4 style="text-align: center;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="AT A GLANCE" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="AT A GLANCE" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="SPEED FOR YOUR GOODS" title="Air Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="CLEVERLY COMBINED" title="Sea Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 09:46:29', '2015-11-04 09:46:29', '', 6, 'http://micronics.votresitedemo.com/?p=65', 0, 'revision', '', 0),
(66, 1, '2015-11-04 09:46:54', '2015-11-04 09:46:54', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="AT A GLANCE" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="AT A GLANCE" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="SPEED FOR YOUR GOODS" title="Air Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="CLEVERLY COMBINED" title="Sea Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 09:46:54', '2015-11-04 09:46:54', '', 6, 'http://micronics.votresitedemo.com/?p=66', 0, 'revision', '', 0),
(67, 1, '2015-11-04 09:49:21', '2015-11-04 09:49:21', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="Industrie" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="Solution recherche" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="SPEED FOR YOUR GOODS" title="Air Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="CLEVERLY COMBINED" title="Sea Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 09:49:21', '2015-11-04 09:49:21', '', 6, 'http://micronics.votresitedemo.com/?p=67', 0, 'revision', '', 0),
(68, 1, '2015-11-04 09:49:56', '2015-11-04 09:49:56', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Industrie" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="Solution recherche" title="Ground Shipping" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="SPEED FOR YOUR GOODS" title="Air Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="CLEVERLY COMBINED" title="Sea Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 09:49:56', '2015-11-04 09:49:56', '', 6, 'http://micronics.votresitedemo.com/?p=68', 0, 'revision', '', 0) ;
INSERT INTO `wp_posts` ( `ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(69, 1, '2015-11-04 09:50:24', '2015-11-04 09:50:24', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Industrie" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Solution recherche" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="SPEED FOR YOUR GOODS" title="Air Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="CLEVERLY COMBINED" title="Sea Delivery" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 09:50:24', '2015-11-04 09:50:24', '', 6, 'http://micronics.votresitedemo.com/?p=69', 0, 'revision', '', 0),
(70, 1, '2015-11-04 09:51:11', '2015-11-04 09:51:11', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Industrie" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Solution recherche" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Etude et développment" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Eco-conception" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 09:51:11', '2015-11-04 09:51:11', '', 6, 'http://micronics.votresitedemo.com/?p=70', 0, 'revision', '', 0),
(71, 1, '2015-11-04 09:52:27', '2015-11-04 09:52:27', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Solution recherche" excerpt="Laboratoire"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Etude et développment" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Eco-conception" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 09:52:27', '2015-11-04 09:52:27', '', 6, 'http://micronics.votresitedemo.com/?p=71', 0, 'revision', '', 0),
(72, 1, '2015-11-04 09:52:51', '2015-11-04 09:52:51', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Etude et développment" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Eco-conception" excerpt="Hashtag Blue Bottle Williamsburg meggings, Kickstarter gluten-free mustache jean shorts Portland messenger bag heirloom fap. "][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 09:52:51', '2015-11-04 09:52:51', '', 6, 'http://micronics.votresitedemo.com/?p=72', 0, 'revision', '', 0),
(73, 1, '2015-11-04 09:56:11', '2015-11-04 09:56:11', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 09:56:11', '2015-11-04 09:56:11', '', 6, 'http://micronics.votresitedemo.com/?p=73', 0, 'revision', '', 0),
(74, 1, '2015-11-04 10:07:49', '2015-11-04 10:07:49', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="9" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 10:07:49', '2015-11-04 10:07:49', '', 6, 'http://micronics.votresitedemo.com/?p=74', 0, 'revision', '', 0),
(75, 1, '2015-11-04 10:12:37', '2015-11-04 10:12:37', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="14" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 10:12:37', '2015-11-04 10:12:37', '', 6, 'http://micronics.votresitedemo.com/?p=75', 0, 'revision', '', 0),
(76, 1, '2015-11-04 10:15:05', '2015-11-04 10:15:05', '', 'logo-white', '', 'inherit', 'open', 'closed', '', 'logo-white', '', '', '2015-11-04 10:15:05', '2015-11-04 10:15:05', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/logo-white.png', 0, 'attachment', 'image/png', 0),
(77, 1, '2015-11-04 10:15:06', '2015-11-04 10:15:06', '', 'logo-black', '', 'inherit', 'open', 'closed', '', 'logo-black', '', '', '2015-11-04 10:15:06', '2015-11-04 10:15:06', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/logo-black.png', 0, 'attachment', 'image/png', 0),
(78, 1, '2015-11-04 10:26:24', '2015-11-04 10:26:24', '', 'slider-image-green', '', 'inherit', 'open', 'closed', '', 'slider-image-green', '', '', '2015-11-04 10:26:24', '2015-11-04 10:26:24', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png', 0, 'attachment', 'image/png', 0),
(79, 1, '2015-11-04 10:26:26', '2015-11-04 10:26:26', '', 'slider-image-circuits', '', 'inherit', 'open', 'closed', '', 'slider-image-circuits', '', '', '2015-11-04 10:26:26', '2015-11-04 10:26:26', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-circuits.png', 0, 'attachment', 'image/png', 0),
(96, 1, '2015-11-04 10:37:37', '2015-11-04 10:37:37', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 10:37:37', '2015-11-04 10:37:37', '', 6, 'http://micronics.votresitedemo.com/?p=96', 0, 'revision', '', 0),
(98, 1, '2015-11-04 10:41:34', '2015-11-04 10:41:34', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 10:41:34', '2015-11-04 10:41:34', '', 6, 'http://micronics.votresitedemo.com/?p=98', 0, 'revision', '', 0),
(99, 1, '2015-11-04 10:42:13', '2015-11-04 10:42:13', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 10:42:13', '2015-11-04 10:42:13', '', 6, 'http://micronics.votresitedemo.com/?p=99', 0, 'revision', '', 0),
(100, 1, '2015-11-06 10:43:16', '2015-11-06 10:43:16', '[vc_row css=".vc_custom_1446805109031{padding-top: 40px !important;}" el_id="mip_societe_section1"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446805435087{background-color: #efeff2 !important;}" el_id="mip_societe_section2"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text css=".vc_custom_1446805689580{padding-top: 20px !important;}"]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\n\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row el_id="mip_societe_section3"][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5" title="mip_tabs"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-autosave-v1', '', '', '2015-11-06 10:43:16', '2015-11-06 10:43:16', '', 45, 'http://micronics.votresitedemo.com/?p=100', 0, 'revision', '', 0),
(101, 1, '2015-11-04 10:50:37', '2015-11-04 10:50:37', '[vc_row][vc_column width="1/2"][vc_single_image][/vc_column][vc_column width="1/2"][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 10:50:37', '2015-11-04 10:50:37', '', 45, 'http://micronics.votresitedemo.com/?p=101', 0, 'revision', '', 0),
(102, 1, '2015-11-04 10:56:10', '2015-11-04 10:56:10', '', 'cms-image', '', 'inherit', 'open', 'closed', '', 'cms-image', '', '', '2015-11-04 10:56:10', '2015-11-04 10:56:10', '', 45, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/cms-image.png', 0, 'attachment', 'image/png', 0),
(103, 1, '2015-11-04 10:58:00', '2015-11-04 10:58:00', '[vc_row][vc_column width="1/2"][vc_single_image image="102"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 10:58:00', '2015-11-04 10:58:00', '', 45, 'http://micronics.votresitedemo.com/?p=103', 0, 'revision', '', 0),
(104, 1, '2015-11-04 10:58:57', '2015-11-04 10:58:57', '[vc_row][vc_column width="1/2"][vc_single_image image="102"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 10:58:57', '2015-11-04 10:58:57', '', 45, 'http://micronics.votresitedemo.com/?p=104', 0, 'revision', '', 0),
(105, 1, '2015-11-04 10:59:47', '2015-11-04 10:59:47', '[vc_row][vc_column width="1/2"][vc_single_image image="102"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 10:59:47', '2015-11-04 10:59:47', '', 45, 'http://micronics.votresitedemo.com/?p=105', 0, 'revision', '', 0),
(106, 1, '2015-11-04 11:02:21', '2015-11-04 11:02:21', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_divider caption_size="h3" border_style="solid" border_size="2" border_color="#efeff2"][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:02:21', '2015-11-04 11:02:21', '', 45, 'http://micronics.votresitedemo.com/?p=106', 0, 'revision', '', 0),
(107, 1, '2015-11-04 11:03:01', '2015-11-04 11:03:01', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#efeff2"][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:03:01', '2015-11-04 11:03:01', '', 45, 'http://micronics.votresitedemo.com/?p=107', 0, 'revision', '', 0),
(108, 1, '2015-11-04 11:04:33', '2015-11-04 11:04:33', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#efeff2" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:04:33', '2015-11-04 11:04:33', '', 45, 'http://micronics.votresitedemo.com/?p=108', 0, 'revision', '', 0),
(109, 1, '2015-11-04 11:04:59', '2015-11-04 11:04:59', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="10" border_color="#efeff2" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:04:59', '2015-11-04 11:04:59', '', 45, 'http://micronics.votresitedemo.com/?p=109', 0, 'revision', '', 0),
(110, 1, '2015-11-04 11:06:10', '2015-11-04 11:06:10', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#1e73be" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:06:10', '2015-11-04 11:06:10', '', 45, 'http://micronics.votresitedemo.com/?p=110', 0, 'revision', '', 0),
(111, 1, '2015-11-04 11:07:07', '2015-11-04 11:07:07', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:07:07', '2015-11-04 11:07:07', '', 45, 'http://micronics.votresitedemo.com/?p=111', 0, 'revision', '', 0),
(112, 1, '2015-11-04 11:13:01', '2015-11-04 11:13:01', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446635423739{background-color: #efeff2 !important;}"][vc_column css=".vc_custom_1446635503614{background-color: #81d742 !important;}"][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:13:01', '2015-11-04 11:13:01', '', 45, 'http://micronics.votresitedemo.com/?p=112', 0, 'revision', '', 0),
(113, 1, '2015-11-04 11:14:06', '2015-11-04 11:14:06', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446635645018{background-color: #1e73be !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][/vc_column][/vc_row][vc_row][vc_column][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:14:06', '2015-11-04 11:14:06', '', 45, 'http://micronics.votresitedemo.com/?p=113', 0, 'revision', '', 0),
(114, 1, '2015-11-04 11:14:59', '2015-11-04 11:14:59', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446635645018{background-color: #1e73be !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n[/vc_column_text][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:14:59', '2015-11-04 11:14:59', '', 45, 'http://micronics.votresitedemo.com/?p=114', 0, 'revision', '', 0),
(115, 1, '2015-11-04 11:15:43', '2015-11-04 11:15:43', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446635741709{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n[/vc_column_text][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:15:43', '2015-11-04 11:15:43', '', 45, 'http://micronics.votresitedemo.com/?p=115', 0, 'revision', '', 0),
(116, 1, '2015-11-04 11:19:06', '2015-11-04 11:19:06', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446635741709{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:19:06', '2015-11-04 11:19:06', '', 45, 'http://micronics.votresitedemo.com/?p=116', 0, 'revision', '', 0),
(117, 1, '2015-11-04 11:22:24', '2015-11-04 11:22:24', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446635741709{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:22:24', '2015-11-04 11:22:24', '', 45, 'http://micronics.votresitedemo.com/?p=117', 0, 'revision', '', 0) ;
INSERT INTO `wp_posts` ( `ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(118, 1, '2015-11-04 11:25:35', '2015-11-04 11:25:35', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446635741709{background-color: #efeff2 !important;}"][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n[/vc_column_text][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][/ozy_vc_testimonials][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:25:35', '2015-11-04 11:25:35', '', 45, 'http://micronics.votresitedemo.com/?p=118', 0, 'revision', '', 0),
(119, 1, '2015-11-04 11:27:15', '2015-11-04 11:27:15', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][/vc_column][/vc_row][vc_row][vc_column width="2/3"][vc_tta_tabs][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:27:15', '2015-11-04 11:27:15', '', 45, 'http://micronics.votresitedemo.com/?p=119', 0, 'revision', '', 0),
(120, 1, '2015-11-04 11:30:54', '2015-11-04 11:30:54', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs active_section="1"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:30:54', '2015-11-04 11:30:54', '', 45, 'http://micronics.votresitedemo.com/?p=120', 0, 'revision', '', 0),
(121, 1, '2015-11-04 11:36:03', '2015-11-04 11:36:03', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446636892026{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="1" active_section="1"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:36:03', '2015-11-04 11:36:03', '', 45, 'http://micronics.votresitedemo.com/?p=121', 0, 'revision', '', 0),
(122, 1, '2015-11-04 11:37:32', '2015-11-04 11:37:32', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446636892026{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="1" active_section="1"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:37:32', '2015-11-04 11:37:32', '', 45, 'http://micronics.votresitedemo.com/?p=122', 0, 'revision', '', 0),
(123, 1, '2015-11-04 11:38:46', '2015-11-04 11:38:46', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446636892026{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:38:46', '2015-11-04 11:38:46', '', 45, 'http://micronics.votresitedemo.com/?p=123', 0, 'revision', '', 0),
(124, 1, '2015-11-04 11:42:00', '2015-11-04 11:42:00', '', 'director1-150x150', '', 'inherit', 'open', 'closed', '', 'director1-150x150', '', '', '2015-11-04 11:42:00', '2015-11-04 11:42:00', '', 45, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/director1-150x150.jpg', 0, 'attachment', 'image/jpeg', 0),
(125, 1, '2015-11-04 11:42:11', '2015-11-04 11:42:11', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446636892026{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:42:11', '2015-11-04 11:42:11', '', 45, 'http://micronics.votresitedemo.com/?p=125', 0, 'revision', '', 0),
(126, 1, '2015-11-04 11:43:19', '2015-11-04 11:43:19', '', '96895135-300x180', '', 'inherit', 'open', 'closed', '', '96895135-300x180', '', '', '2015-11-04 11:43:19', '2015-11-04 11:43:19', '', 45, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/96895135-300x180.jpg', 0, 'attachment', 'image/jpeg', 0),
(127, 1, '2015-11-04 11:43:23', '2015-11-04 11:43:23', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446636892026{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:43:23', '2015-11-04 11:43:23', '', 45, 'http://micronics.votresitedemo.com/?p=127', 0, 'revision', '', 0) ;
INSERT INTO `wp_posts` ( `ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(128, 1, '2015-11-04 11:44:04', '2015-11-04 11:44:04', '[vc_row][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446636892026{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-04 11:44:04', '2015-11-04 11:44:04', '', 45, 'http://micronics.votresitedemo.com/?p=128', 0, 'revision', '', 0),
(129, 1, '2015-11-04 12:55:25', '2015-11-04 12:55:25', '', 'bg_image_contact-1144x477', '', 'inherit', 'open', 'closed', '', 'bg_image_contact-1144x477', '', '', '2015-11-04 12:55:25', '2015-11-04 12:55:25', '', 54, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/bg_image_contact-1144x477.jpg', 0, 'attachment', 'image/jpeg', 0),
(130, 1, '2015-11-04 12:58:01', '2015-11-04 12:58:01', '', 'world_bg-1144x715', '', 'inherit', 'open', 'closed', '', 'world_bg-1144x715', '', '', '2015-11-04 12:58:01', '2015-11-04 12:58:01', '', 54, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/world_bg-1144x715.png', 0, 'attachment', 'image/png', 0),
(131, 1, '2015-11-04 13:01:53', '2015-11-04 13:01:53', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h5>LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-04 13:01:53', '2015-11-04 13:01:53', '', 54, 'http://micronics.votresitedemo.com/?p=131', 0, 'revision', '', 0),
(132, 1, '2015-11-06 13:21:55', '2015-11-06 13:21:55', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\n<h5 style="text-align: left;">LOGISTIC (HEADQUARTERS)</h5>\n<strong>Global Logistic, London</strong>\n4-5 Spring St, London‎\nTel: +44 20 8786 7200\nFax: +44 20 8786 7200\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][vc_single_image image="133" img_size="medium" alignment="center"][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_prettymap][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-autosave-v1', '', '', '2015-11-06 13:21:55', '2015-11-06 13:21:55', '', 54, 'http://micronics.votresitedemo.com/?p=132', 0, 'revision', '', 0),
(133, 1, '2015-11-04 13:04:57', '2015-11-04 13:04:57', '', 'operator', '', 'inherit', 'open', 'closed', '', 'operator', '', '', '2015-11-04 13:04:57', '2015-11-04 13:04:57', '', 54, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/operator.png', 0, 'attachment', 'image/png', 0),
(134, 1, '2015-11-04 13:05:06', '2015-11-04 13:05:06', '[vc_row][vc_column][vc_column_text]\r\n<h5>LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_single_image image="133"][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-04 13:05:06', '2015-11-04 13:05:06', '', 54, 'http://micronics.votresitedemo.com/?p=134', 0, 'revision', '', 0),
(135, 1, '2015-11-04 13:07:33', '2015-11-04 13:07:33', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h5 style="text-align: left;">LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][vc_single_image image="133"][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-04 13:07:33', '2015-11-04 13:07:33', '', 54, 'http://micronics.votresitedemo.com/?p=135', 0, 'revision', '', 0),
(136, 1, '2015-11-04 13:07:55', '2015-11-04 13:07:55', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h5 style="text-align: left;">LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][vc_single_image image="133" img_size="full"][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-04 13:07:55', '2015-11-04 13:07:55', '', 54, 'http://micronics.votresitedemo.com/?p=136', 0, 'revision', '', 0),
(137, 1, '2015-11-04 13:08:16', '2015-11-04 13:08:16', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h5 style="text-align: left;">LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][vc_single_image image="133" img_size="large"][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-04 13:08:16', '2015-11-04 13:08:16', '', 54, 'http://micronics.votresitedemo.com/?p=137', 0, 'revision', '', 0),
(138, 1, '2015-11-04 13:08:35', '2015-11-04 13:08:35', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h5 style="text-align: left;">LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][vc_single_image image="133" img_size="medium"][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-04 13:08:35', '2015-11-04 13:08:35', '', 54, 'http://micronics.votresitedemo.com/?p=138', 0, 'revision', '', 0),
(139, 1, '2015-11-04 13:08:58', '2015-11-04 13:08:58', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h5 style="text-align: left;">LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][vc_single_image image="133" img_size="medium" alignment="right"][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-04 13:08:58', '2015-11-04 13:08:58', '', 54, 'http://micronics.votresitedemo.com/?p=139', 0, 'revision', '', 0),
(140, 1, '2015-11-04 13:09:31', '2015-11-04 13:09:31', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h5 style="text-align: left;">LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][vc_single_image image="133" img_size="medium" alignment="center"][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-04 13:09:31', '2015-11-04 13:09:31', '', 54, 'http://micronics.votresitedemo.com/?p=140', 0, 'revision', '', 0),
(141, 1, '2015-11-04 13:16:18', '2015-11-04 13:16:18', '[vc_row css=".vc_custom_1446811755292{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/produits1.jpg?id=382) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_id="mip_univers_section1"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="custom" border_width="4" el_width="40" accent_color="#0267c1"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></h4>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row el_id="mip_univers_section2"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="center" caption_position="top" more_custom="on" width="40px" align="center"][vc_column_text]\r\n<p style="text-align: center;"><span style="font-weight: 400;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row el_id="mip_univers_section3"][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'publish', 'closed', 'closed', '', 'redresseur-a-decoupage', '', '', '2015-11-06 12:25:22', '2015-11-06 12:25:22', '', 60, 'http://micronics.votresitedemo.com/?page_id=141', 0, 'page', '', 0),
(142, 1, '2015-11-04 13:16:18', '2015-11-04 13:16:18', '', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 13:16:18', '2015-11-04 13:16:18', '', 141, 'http://micronics.votresitedemo.com/?p=142', 0, 'revision', '', 0),
(143, 1, '2015-11-04 13:16:42', '2015-11-04 13:16:42', '[vc_row][vc_column][vc_column_text]\r\n<h2>Redresseur à découpage - Microswitch (0 à 3000 A)</h2>\r\n&nbsp;\r\n\r\nCar feerique radieuse dut pressent. Cathedrale le la tu maintenant va redoublait vieillards ordonnance. Pretends le empilait viennent la philippe kolbacks. Groupes drapent menions me etalent je je. Boulevard regardent dissipait pu va. Paraissent admiration decharnees je me tristement etonnement tu du. Pu bouleaux horrible havresac quarante en.\r\n\r\nCes porta une grave ont salle. Regard que soldat penser des iii aux arrive cranes. Apprenons ils adjudants son que divergent concierge. Ici nos des feu comme crier voeux. Car portieres reveillez puissions dentelles pas. Effrayant jet nez cauchemar couraient echauffer air nid.\r\n\r\n<a href="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png"><img class="size-full wp-image-194 alignleft" src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png" alt="product-image-260x260" width="260" height="260" /></a>Carabines mal fusillade contemple net alternent des fabriques. Son amour mur rendu poing fin parmi. Trahison car defoncat les refletez jeu physique. Me indus tours ii voila houle. Surpris pendant te sourire se tendons arriere. Radieuse il contient on bouleaux.\r\n\r\nNet cauchemar ses deroulent des gachettes ton echauffer. Quand ici meres annee rouge les. Bambous mes pouvons torture blottis jet. Electrique vin mon tricolores fit maintenant republique souhaitait. Ah si ivres de etais brave aides metal appel. Le je lisiere chinois qu diables importe. Roc aux viendrait les signalant parlaient attachent seulement. Ah ce frequentes souffrance du gourmettes eclatantes. Vingt ca la hisse doute en leurs annee. Je drapent sa laissez premier.\r\n\r\nCet est dit vert tete tira non. Vieille pelouse secouee cet pinacle mauvais rit. Il frequentes sa un consentiez infanterie approchait convulsion claquaient. Premiers sa batisses poitrine garnison du le. La survivants sa condamnait simplement redoublait. Ii comprenez oh philomene evocation uniformes.\r\n\r\nCe nous donc deja avec ah tout agit. On fenetres mamelons se agissait ma. Changea au prelude laideur promene mariage te en extreme. On caracolent paraissent evidemment on. Adjudant heureuse kolbacks la on. Nos ont blottis les diables soudain ciments. Impose tu bucher humain je ahuris ii. Conquerir enfantent causaient cesserent nid jeu viendrait certitude.\r\n\r\nSinguliers estaminets decharnees etonnement diplomates fer par mur jet. Six style monte mille des. Et sa donnerai chantant repartit tonneaux. Devient on travers pu entendu savants prepare on. Que fit creerent chantant tacherai ete toussent. Bon dentelles conquerir indicible nos agreerait evocation seulement. Dut sol harmonie massacre flottent bon.\r\n\r\nMon peu net tetes selon uns haine eumes loups. Suffisait construit courroies he en et. Fraternite entrainait electrique infanterie car ces vieillards. Eux les moi verte lunes seuls breve leurs. Dressait mourants on oh amertume entendit mettions il. Tot caissons feu soudaine aux absorber ton dimanche. Il entrait ca la labeurs premier. Cet fanatiques victorieux asiatiques manoeuvres fin atteignait. Leurs mines celui pu seule ah arbre oh qu.\r\n\r\nPiquette laissons comptent la societes en couverts. Agir nous venu en hors arcs joie on. Comme que ton sur chose coeur. Ici comprenez jugements mur ton pic cauchemar printemps sentiment. Crurent fatigue ca pu sa carreau. Nos attique volonte des humains. Inassouvi des neanmoins ils dut poussiere.\r\n\r\nWagons et livree en laissa ce soucis. Asie art coin est hate dut peu. Croix ca louis qu wagon le irise forme la utile. Avait air alors herbe net car adore indus mes doute. Assassins attachent apprenons mur fer. Emmener meurtre ici vit symbole mariage eux. Patre ils par essor ronde osait vieil. Ronfle te forces qu oh quelle suivit legion oh. Va un bientot va aurions paysans il comprit faisans sentent. Non renferment fraternite moustachus bas cimetieres ras construits descendons.\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][/vc_row]', 'Microswitch (0 à 3000 A)', '', 'publish', 'closed', 'closed', '', 'microswitch-0-a-3000-a', '', '', '2015-11-06 13:01:44', '2015-11-06 13:01:44', '', 141, 'http://micronics.votresitedemo.com/?page_id=143', 0, 'page', '', 0),
(144, 1, '2015-11-04 13:16:42', '2015-11-04 13:16:42', '', 'Microswitch (0 à 3000 A)', '', 'inherit', 'closed', 'closed', '', '143-revision-v1', '', '', '2015-11-04 13:16:42', '2015-11-04 13:16:42', '', 143, 'http://micronics.votresitedemo.com/?p=144', 0, 'revision', '', 0),
(145, 1, '2015-11-04 13:16:58', '2015-11-04 13:16:58', '[vc_row][vc_column][vc_column_text]\r\n<h2>Redresseur à découpage - Powerswitch (3000 à 10000 A)</h2>\r\nCar feerique radieuse dut pressent. Cathedrale le la tu maintenant va redoublait vieillards ordonnance. Pretends le empilait viennent la philippe kolbacks. Groupes drapent menions me etalent je je. Boulevard regardent dissipait pu va. Paraissent admiration decharnees je me tristement etonnement tu du. Pu bouleaux horrible havresac quarante en.\r\n\r\nCes porta une grave ont salle. Regard que soldat penser des iii aux arrive cranes. Apprenons ils adjudants son que divergent concierge. Ici nos des feu comme crier voeux. Car portieres reveillez puissions dentelles pas. Effrayant jet nez cauchemar couraient echauffer air nid.\r\n\r\n<a href="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png"><img class="size-full wp-image-194 alignleft" src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png" alt="product-image-260x260" width="260" height="260" /></a>Carabines mal fusillade contemple net alternent des fabriques. Son amour mur rendu poing fin parmi. Trahison car defoncat les refletez jeu physique. Me indus tours ii voila houle. Surpris pendant te sourire se tendons arriere. Radieuse il contient on bouleaux.\r\n\r\nNet cauchemar ses deroulent des gachettes ton echauffer. Quand ici meres annee rouge les. Bambous mes pouvons torture blottis jet. Electrique vin mon tricolores fit maintenant republique souhaitait. Ah si ivres de etais brave aides metal appel. Le je lisiere chinois qu diables importe. Roc aux viendrait les signalant parlaient attachent seulement. Ah ce frequentes souffrance du gourmettes eclatantes. Vingt ca la hisse doute en leurs annee. Je drapent sa laissez premier.\r\n\r\nCet est dit vert tete tira non. Vieille pelouse secouee cet pinacle mauvais rit. Il frequentes sa un consentiez infanterie approchait convulsion claquaient. Premiers sa batisses poitrine garnison du le. La survivants sa condamnait simplement redoublait. Ii comprenez oh philomene evocation uniformes.\r\n\r\nCe nous donc deja avec ah tout agit. On fenetres mamelons se agissait ma. Changea au prelude laideur promene mariage te en extreme. On caracolent paraissent evidemment on. Adjudant heureuse kolbacks la on. Nos ont blottis les diables soudain ciments. Impose tu bucher humain je ahuris ii. Conquerir enfantent causaient cesserent nid jeu viendrait certitude.\r\n\r\nSinguliers estaminets decharnees etonnement diplomates fer par mur jet. Six style monte mille des. Et sa donnerai chantant repartit tonneaux. Devient on travers pu entendu savants prepare on. Que fit creerent chantant tacherai ete toussent. Bon dentelles conquerir indicible nos agreerait evocation seulement. Dut sol harmonie massacre flottent bon.\r\n\r\nMon peu net tetes selon uns haine eumes loups. Suffisait construit courroies he en et. Fraternite entrainait electrique infanterie car ces vieillards. Eux les moi verte lunes seuls breve leurs. Dressait mourants on oh amertume entendit mettions il. Tot caissons feu soudaine aux absorber ton dimanche. Il entrait ca la labeurs premier. Cet fanatiques victorieux asiatiques manoeuvres fin atteignait. Leurs mines celui pu seule ah arbre oh qu.\r\n\r\nPiquette laissons comptent la societes en couverts. Agir nous venu en hors arcs joie on. Comme que ton sur chose coeur. Ici comprenez jugements mur ton pic cauchemar printemps sentiment. Crurent fatigue ca pu sa carreau. Nos attique volonte des humains. Inassouvi des neanmoins ils dut poussiere.\r\n\r\nWagons et livree en laissa ce soucis. Asie art coin est hate dut peu. Croix ca louis qu wagon le irise forme la utile. Avait air alors herbe net car adore indus mes doute. Assassins attachent apprenons mur fer. Emmener meurtre ici vit symbole mariage eux. Patre ils par essor ronde osait vieil. Ronfle te forces qu oh quelle suivit legion oh. Va un bientot va aurions paysans il comprit faisans sentent. Non renferment fraternite moustachus bas cimetieres ras construits descendons.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][/vc_row]', 'Powerswitch (3000 à 10000 A)', '', 'publish', 'closed', 'closed', '', 'powerswitch-3000-a-10000-a', '', '', '2015-11-06 13:00:46', '2015-11-06 13:00:46', '', 141, 'http://micronics.votresitedemo.com/?page_id=145', 0, 'page', '', 0),
(146, 1, '2015-11-04 13:16:58', '2015-11-04 13:16:58', '', 'Powerswitch (3000 à 10000 A)', '', 'inherit', 'closed', 'closed', '', '145-revision-v1', '', '', '2015-11-04 13:16:58', '2015-11-04 13:16:58', '', 145, 'http://micronics.votresitedemo.com/?p=146', 0, 'revision', '', 0),
(147, 1, '2015-11-04 13:17:21', '2015-11-04 13:17:21', '[vc_row][vc_column][vc_column_text]\r\n<h2>Redresseur à découpage - VTwin (Double sortie)</h2>\r\nCar feerique radieuse dut pressent. Cathedrale le la tu maintenant va redoublait vieillards ordonnance. Pretends le empilait viennent la philippe kolbacks. Groupes drapent menions me etalent je je. Boulevard regardent dissipait pu va. Paraissent admiration decharnees je me tristement etonnement tu du. Pu bouleaux horrible havresac quarante en.\r\n\r\nCes porta une grave ont salle. Regard que soldat penser des iii aux arrive cranes. Apprenons ils adjudants son que divergent concierge. Ici nos des feu comme crier voeux. Car portieres reveillez puissions dentelles pas. Effrayant jet nez cauchemar couraient echauffer air nid.\r\n\r\n<a href="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png"><img class="size-full wp-image-194 alignleft" src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png" alt="product-image-260x260" width="260" height="260" /></a>Carabines mal fusillade contemple net alternent des fabriques. Son amour mur rendu poing fin parmi. Trahison car defoncat les refletez jeu physique. Me indus tours ii voila houle. Surpris pendant te sourire se tendons arriere. Radieuse il contient on bouleaux.\r\n\r\nNet cauchemar ses deroulent des gachettes ton echauffer. Quand ici meres annee rouge les. Bambous mes pouvons torture blottis jet. Electrique vin mon tricolores fit maintenant republique souhaitait. Ah si ivres de etais brave aides metal appel. Le je lisiere chinois qu diables importe. Roc aux viendrait les signalant parlaient attachent seulement. Ah ce frequentes souffrance du gourmettes eclatantes. Vingt ca la hisse doute en leurs annee. Je drapent sa laissez premier.\r\n\r\nCet est dit vert tete tira non. Vieille pelouse secouee cet pinacle mauvais rit. Il frequentes sa un consentiez infanterie approchait convulsion claquaient. Premiers sa batisses poitrine garnison du le. La survivants sa condamnait simplement redoublait. Ii comprenez oh philomene evocation uniformes.\r\n\r\nCe nous donc deja avec ah tout agit. On fenetres mamelons se agissait ma. Changea au prelude laideur promene mariage te en extreme. On caracolent paraissent evidemment on. Adjudant heureuse kolbacks la on. Nos ont blottis les diables soudain ciments. Impose tu bucher humain je ahuris ii. Conquerir enfantent causaient cesserent nid jeu viendrait certitude.\r\n\r\nSinguliers estaminets decharnees etonnement diplomates fer par mur jet. Six style monte mille des. Et sa donnerai chantant repartit tonneaux. Devient on travers pu entendu savants prepare on. Que fit creerent chantant tacherai ete toussent. Bon dentelles conquerir indicible nos agreerait evocation seulement. Dut sol harmonie massacre flottent bon.\r\n\r\nMon peu net tetes selon uns haine eumes loups. Suffisait construit courroies he en et. Fraternite entrainait electrique infanterie car ces vieillards. Eux les moi verte lunes seuls breve leurs. Dressait mourants on oh amertume entendit mettions il. Tot caissons feu soudaine aux absorber ton dimanche. Il entrait ca la labeurs premier. Cet fanatiques victorieux asiatiques manoeuvres fin atteignait. Leurs mines celui pu seule ah arbre oh qu.\r\n\r\nPiquette laissons comptent la societes en couverts. Agir nous venu en hors arcs joie on. Comme que ton sur chose coeur. Ici comprenez jugements mur ton pic cauchemar printemps sentiment. Crurent fatigue ca pu sa carreau. Nos attique volonte des humains. Inassouvi des neanmoins ils dut poussiere.\r\n\r\nWagons et livree en laissa ce soucis. Asie art coin est hate dut peu. Croix ca louis qu wagon le irise forme la utile. Avait air alors herbe net car adore indus mes doute. Assassins attachent apprenons mur fer. Emmener meurtre ici vit symbole mariage eux. Patre ils par essor ronde osait vieil. Ronfle te forces qu oh quelle suivit legion oh. Va un bientot va aurions paysans il comprit faisans sentent. Non renferment fraternite moustachus bas cimetieres ras construits descendons.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][/vc_row]', 'VTwin (Double sortie)', '', 'publish', 'closed', 'closed', '', 'vtwin-double-sortie', '', '', '2015-11-06 13:03:07', '2015-11-06 13:03:07', '', 141, 'http://micronics.votresitedemo.com/?page_id=147', 0, 'page', '', 0),
(148, 1, '2015-11-04 13:17:21', '2015-11-04 13:17:21', '', 'VTwin (Double sortie)', '', 'inherit', 'closed', 'closed', '', '147-revision-v1', '', '', '2015-11-04 13:17:21', '2015-11-04 13:17:21', '', 147, 'http://micronics.votresitedemo.com/?p=148', 0, 'revision', '', 0),
(149, 1, '2015-11-04 13:19:57', '2015-11-04 13:19:57', ' ', '', '', 'publish', 'closed', 'closed', '', '149', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 60, 'http://micronics.votresitedemo.com/?p=149', 2, 'nav_menu_item', '', 0),
(150, 1, '2015-11-04 13:19:57', '2015-11-04 13:19:57', ' ', '', '', 'publish', 'closed', 'closed', '', '150', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 141, 'http://micronics.votresitedemo.com/?p=150', 3, 'nav_menu_item', '', 0),
(151, 1, '2015-11-04 13:19:57', '2015-11-04 13:19:57', ' ', '', '', 'publish', 'closed', 'closed', '', '151', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 141, 'http://micronics.votresitedemo.com/?p=151', 4, 'nav_menu_item', '', 0),
(152, 1, '2015-11-04 13:19:57', '2015-11-04 13:19:57', ' ', '', '', 'publish', 'closed', 'closed', '', '152', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 141, 'http://micronics.votresitedemo.com/?p=152', 5, 'nav_menu_item', '', 0),
(158, 1, '2015-11-04 13:32:24', '2015-11-04 13:32:24', '', 'Produits Sidebar', '', 'publish', 'closed', 'closed', '', 'produits-sidebar', '', '', '2015-11-04 13:32:24', '2015-11-04 13:32:24', '', 0, 'http://micronics.votresitedemo.com/?post_type=ozy_sidebars&#038;p=158', 0, 'ozy_sidebars', '', 0),
(159, 1, '2015-11-04 14:24:00', '2015-11-04 14:24:00', '', 'Blog Sidebar', '', 'publish', 'closed', 'closed', '', 'blog-sidebar', '', '', '2015-11-04 14:24:00', '2015-11-04 14:24:00', '', 0, 'http://micronics.votresitedemo.com/?post_type=ozy_sidebars&#038;p=159', 0, 'ozy_sidebars', '', 0),
(160, 1, '2015-11-04 14:26:11', '2015-11-04 14:26:11', '', 'Blog', '', 'publish', 'closed', 'closed', '', 'blog', '', '', '2015-11-04 14:35:09', '2015-11-04 14:35:09', '', 0, 'http://micronics.votresitedemo.com/?page_id=160', 0, 'page', '', 0),
(161, 1, '2015-11-04 14:26:11', '2015-11-04 14:26:11', '', 'Blog', '', 'inherit', 'closed', 'closed', '', '160-revision-v1', '', '', '2015-11-04 14:26:11', '2015-11-04 14:26:11', '', 160, 'http://micronics.votresitedemo.com/?p=161', 0, 'revision', '', 0),
(162, 1, '2015-11-04 14:32:11', '2015-11-04 14:32:11', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 14:32:11', '2015-11-04 14:32:11', '', 6, 'http://micronics.votresitedemo.com/?p=162', 0, 'revision', '', 0),
(163, 1, '2015-11-06 12:25:20', '2015-11-06 12:25:20', '[vc_row css=".vc_custom_1446811755292{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/produits1.jpg?id=382) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_id="mip_univers_section1"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\n[/vc_column_text][vc_separator color="custom" border_width="4" el_width="40" accent_color="#0267c1"][vc_column_text]\n<h4 style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></h4>\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row el_id="mip_univers_section2"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="center" caption_position="top" more_custom="on" width="40px" align="center"][vc_column_text]\n<p style="text-align: center;"><span style="font-weight: 400;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row el_id="mip_univers_section3"][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-autosave-v1', '', '', '2015-11-06 12:25:20', '2015-11-06 12:25:20', '', 141, 'http://micronics.votresitedemo.com/?p=163', 0, 'revision', '', 0),
(164, 1, '2015-11-04 15:06:06', '2015-11-04 15:06:06', '[vc_row][vc_column][ozy_vc_textillate size="40"]Redresseur à découpage[/ozy_vc_textillate][ozy_vc_divider caption_size="h6" caption="Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum."][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:06:06', '2015-11-04 15:06:06', '', 141, 'http://micronics.votresitedemo.com/?p=164', 0, 'revision', '', 0),
(165, 1, '2015-11-04 15:09:15', '2015-11-04 15:09:15', '[vc_row][vc_column][ozy_vc_textillate size="40"]Redresseur à découpage[/ozy_vc_textillate][ozy_vc_divider caption_size="h6" caption="Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum." border_style="solid" border_size="4" border_color="#34ccff" caption_align="center"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:09:15', '2015-11-04 15:09:15', '', 141, 'http://micronics.votresitedemo.com/?p=165', 0, 'revision', '', 0),
(166, 1, '2015-11-04 15:10:31', '2015-11-04 15:10:31', '[vc_row][vc_column][ozy_vc_divider caption_size="h6" caption="Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum." border_style="solid" border_size="4" border_color="#34ccff" caption_align="center" caption_position="top"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:10:31', '2015-11-04 15:10:31', '', 141, 'http://micronics.votresitedemo.com/?p=166', 0, 'revision', '', 0),
(167, 1, '2015-11-04 15:11:11', '2015-11-04 15:11:11', '[vc_row][vc_column][ozy_vc_divider caption_size="h3" caption="Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum." border_style="solid" border_size="4" border_color="#34ccff" caption_align="center" caption_position="top"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:11:11', '2015-11-04 15:11:11', '', 141, 'http://micronics.votresitedemo.com/?p=167', 0, 'revision', '', 0),
(168, 1, '2015-11-04 15:11:39', '2015-11-04 15:11:39', '[vc_row][vc_column][ozy_vc_divider caption_size="h3" caption="Redresseur à découpage" border_style="solid" border_size="4" border_color="#34ccff" caption_align="center" caption_position="top"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:11:39', '2015-11-04 15:11:39', '', 141, 'http://micronics.votresitedemo.com/?p=168', 0, 'revision', '', 0),
(169, 1, '2015-11-04 15:12:13', '2015-11-04 15:12:13', '[vc_row][vc_column][ozy_vc_divider caption_size="h1" caption="Redresseur à découpage" border_style="solid" border_size="4" border_color="#34ccff" caption_align="center" caption_position="top"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:12:13', '2015-11-04 15:12:13', '', 141, 'http://micronics.votresitedemo.com/?p=169', 0, 'revision', '', 0),
(170, 1, '2015-11-04 15:12:58', '2015-11-04 15:12:58', '[vc_row][vc_column][ozy_vc_divider caption_size="h1" caption="Redresseur à découpage" border_style="solid" border_size="4" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" align="center"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:12:58', '2015-11-04 15:12:58', '', 141, 'http://micronics.votresitedemo.com/?p=170', 0, 'revision', '', 0),
(171, 1, '2015-11-04 15:14:09', '2015-11-04 15:14:09', '[vc_row][vc_column][ozy_vc_divider caption_size="h1" caption="Redresseur à découpage" border_style="solid" border_size="4" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="200px" align="center"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:14:09', '2015-11-04 15:14:09', '', 141, 'http://micronics.votresitedemo.com/?p=171', 0, 'revision', '', 0),
(172, 1, '2015-11-04 15:14:35', '2015-11-04 15:14:35', '[vc_row][vc_column][ozy_vc_divider caption_size="h1" caption="Redresseur à découpage" border_style="solid" border_size="4" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" align="center"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:14:35', '2015-11-04 15:14:35', '', 141, 'http://micronics.votresitedemo.com/?p=172', 0, 'revision', '', 0),
(173, 1, '2015-11-04 15:14:52', '2015-11-04 15:14:52', '[vc_row][vc_column][ozy_vc_divider caption_size="h1" caption="Redresseur à découpage" border_style="solid" border_size="4" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="300px" align="center"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:14:52', '2015-11-04 15:14:52', '', 141, 'http://micronics.votresitedemo.com/?p=173', 0, 'revision', '', 0),
(174, 1, '2015-11-04 15:16:14', '2015-11-04 15:16:14', '[vc_row row_min_height="400px"][vc_column][ozy_vc_divider caption_size="h1" caption="Redresseur à découpage" border_style="solid" border_size="4" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="300px" align="center"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:16:14', '2015-11-04 15:16:14', '', 141, 'http://micronics.votresitedemo.com/?p=174', 0, 'revision', '', 0),
(175, 1, '2015-11-04 15:18:03', '2015-11-04 15:18:03', '[vc_row row_min_height="700px"][vc_column][ozy_vc_divider caption_size="h1" caption="Redresseur à découpage" border_style="solid" border_size="4" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="300px" align="center"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:18:03', '2015-11-04 15:18:03', '', 141, 'http://micronics.votresitedemo.com/?p=175', 0, 'revision', '', 0),
(176, 1, '2015-11-04 15:18:37', '2015-11-04 15:18:37', '[vc_row row_min_height="700px" css=".vc_custom_1446650315344{padding-top: 190px !important;padding-bottom: 190px !important;}"][vc_column][ozy_vc_divider caption_size="h1" caption="Redresseur à découpage" border_style="solid" border_size="4" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="300px" align="center"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:18:37', '2015-11-04 15:18:37', '', 141, 'http://micronics.votresitedemo.com/?p=176', 0, 'revision', '', 0),
(178, 1, '2015-11-04 15:21:07', '2015-11-04 15:21:07', '[vc_row row_min_height="700px" css=".vc_custom_1446650458759{padding-top: 190px !important;padding-bottom: 190px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/image-slider-univers.png?id=177) !important;}"][vc_column][ozy_vc_divider caption_size="h1" caption="Redresseur à découpage" border_style="solid" border_size="4" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="300px" align="center"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:21:07', '2015-11-04 15:21:07', '', 141, 'http://micronics.votresitedemo.com/?p=178', 0, 'revision', '', 0),
(179, 1, '2015-11-04 15:24:07', '2015-11-04 15:24:07', '[vc_row row_min_height="700px" css=".vc_custom_1446650645488{padding-top: 190px !important;padding-bottom: 190px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/image-slider-univers.png?id=177) !important;}" font_color="#ffffff"][vc_column][ozy_vc_divider caption_size="h1" caption="Redresseur à découpage" border_style="solid" border_size="4" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="300px" align="center"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:24:07', '2015-11-04 15:24:07', '', 141, 'http://micronics.votresitedemo.com/?p=179', 0, 'revision', '', 0),
(180, 1, '2015-11-04 15:25:39', '2015-11-04 15:25:39', '[vc_row row_min_height="700px" css=".vc_custom_1446650737688{padding-top: 190px !important;padding-bottom: 190px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/image-slider-univers.png?id=177) !important;}" font_color="#ff2828"][vc_column][ozy_vc_divider caption_size="h1" caption="Redresseur à découpage" border_style="solid" border_size="4" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="300px" align="center"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:25:39', '2015-11-04 15:25:39', '', 141, 'http://micronics.votresitedemo.com/?p=180', 0, 'revision', '', 0),
(181, 1, '2015-11-04 15:27:19', '2015-11-04 15:27:19', '[vc_row row_min_height="700px" css=".vc_custom_1446650779704{padding-top: 190px !important;padding-bottom: 190px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/image-slider-univers.png?id=177) !important;}"][vc_column][ozy_vc_divider caption_size="h1" caption="Redresseur à découpage" border_style="solid" border_size="4" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="300px" align="center"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:27:19', '2015-11-04 15:27:19', '', 141, 'http://micronics.votresitedemo.com/?p=181', 0, 'revision', '', 0),
(182, 1, '2015-11-04 15:29:40', '2015-11-04 15:29:40', '[vc_row row_min_height="700px" css=".vc_custom_1446650779704{padding-top: 190px !important;padding-bottom: 190px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/image-slider-univers.png?id=177) !important;}"][vc_column][ozy_vc_divider caption_size="h1" caption="Redresseur à découpage" border_style="solid" border_size="4" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="300px" align="center"][vc_column_text]<span style="font-weight: 400;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span>[/vc_column_text][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:29:40', '2015-11-04 15:29:40', '', 141, 'http://micronics.votresitedemo.com/?p=182', 0, 'revision', '', 0) ;
INSERT INTO `wp_posts` ( `ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(183, 1, '2015-11-04 15:30:51', '2015-11-04 15:30:51', '[vc_row row_min_height="700px" css=".vc_custom_1446650779704{padding-top: 190px !important;padding-bottom: 190px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/image-slider-univers.png?id=177) !important;}"][vc_column][ozy_vc_divider caption_size="h1" caption="Redresseur à découpage" border_style="solid" border_size="4" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="300px" align="center"][vc_column_text]\r\n<p style="text-align: left;"><span style="font-weight: 400; color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:30:51', '2015-11-04 15:30:51', '', 141, 'http://micronics.votresitedemo.com/?p=183', 0, 'revision', '', 0),
(184, 1, '2015-11-04 15:31:58', '2015-11-04 15:31:58', '[vc_row row_min_height="700px" css=".vc_custom_1446650779704{padding-top: 190px !important;padding-bottom: 190px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/image-slider-univers.png?id=177) !important;}"][vc_column width="1/6"][vc_column_text]\r\n<p style="text-align: left;"><span style="font-weight: 400; color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="2/3"][ozy_vc_divider caption_size="h1" caption="Redresseur à découpage" border_style="solid" border_size="4" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="300px" align="center"][/vc_column][vc_column width="1/6"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:31:58', '2015-11-04 15:31:58', '', 141, 'http://micronics.votresitedemo.com/?p=184', 0, 'revision', '', 0),
(185, 1, '2015-11-04 15:33:17', '2015-11-04 15:33:17', '[vc_row][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_separator color="blue" border_width="4" el_width="50"][/vc_column][vc_column width="1/6"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:33:17', '2015-11-04 15:33:17', '', 141, 'http://micronics.votresitedemo.com/?p=185', 0, 'revision', '', 0),
(186, 1, '2015-11-04 15:34:09', '2015-11-04 15:34:09', '[vc_row][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_separator color="blue" border_width="4" el_width="30"][/vc_column][vc_column width="1/6"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:34:09', '2015-11-04 15:34:09', '', 141, 'http://micronics.votresitedemo.com/?p=186', 0, 'revision', '', 0),
(187, 1, '2015-11-04 15:34:35', '2015-11-04 15:34:35', '[vc_row][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][vc_separator color="blue" border_width="4" el_width="30"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:34:35', '2015-11-04 15:34:35', '', 141, 'http://micronics.votresitedemo.com/?p=187', 0, 'revision', '', 0),
(188, 1, '2015-11-04 15:36:13', '2015-11-04 15:36:13', '[vc_row][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="blue" border_width="4" el_width="30"][vc_column_text]\r\n<p style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:36:13', '2015-11-04 15:36:13', '', 141, 'http://micronics.votresitedemo.com/?p=188', 0, 'revision', '', 0),
(189, 1, '2015-11-04 15:36:51', '2015-11-04 15:36:51', '[vc_row css=".vc_custom_1446651409345{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/image-slider-univers.png?id=177) !important;}"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="blue" border_width="4" el_width="30"][vc_column_text]\r\n<p style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:36:51', '2015-11-04 15:36:51', '', 141, 'http://micronics.votresitedemo.com/?p=189', 0, 'revision', '', 0),
(190, 1, '2015-11-04 15:37:27', '2015-11-04 15:37:27', '[vc_row css=".vc_custom_1446651409345{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/image-slider-univers.png?id=177) !important;}"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="blue" border_width="6" el_width="40"][vc_column_text]\r\n<p style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:37:27', '2015-11-04 15:37:27', '', 141, 'http://micronics.votresitedemo.com/?p=190', 0, 'revision', '', 0),
(191, 1, '2015-11-04 15:37:49', '2015-11-04 15:37:49', '[vc_row css=".vc_custom_1446651409345{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/image-slider-univers.png?id=177) !important;}"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="blue" border_width="6" el_width="40"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></h4>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:37:49', '2015-11-04 15:37:49', '', 141, 'http://micronics.votresitedemo.com/?p=191', 0, 'revision', '', 0),
(192, 1, '2015-11-04 15:41:19', '2015-11-04 15:41:19', '[vc_row css=".vc_custom_1446651409345{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/image-slider-univers.png?id=177) !important;}"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="blue" border_width="6" el_width="40"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></h4>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="40px" align="center"][vc_column_text]\r\n<p style="text-align: center;"><span style="font-weight: 400;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:41:19', '2015-11-04 15:41:19', '', 141, 'http://micronics.votresitedemo.com/?p=192', 0, 'revision', '', 0),
(193, 1, '2015-11-04 15:42:07', '2015-11-04 15:42:07', '[vc_row css=".vc_custom_1446651409345{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/image-slider-univers.png?id=177) !important;}"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="blue" border_width="6" el_width="40"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></h4>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/6"][/vc_column][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="40px" align="center"][vc_column_text]\r\n<p style="text-align: center;"><span style="font-weight: 400;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:42:07', '2015-11-04 15:42:07', '', 141, 'http://micronics.votresitedemo.com/?p=193', 0, 'revision', '', 0),
(194, 1, '2015-11-04 15:45:45', '2015-11-04 15:45:45', '', 'product-image-260x260', '', 'inherit', 'open', 'closed', '', 'product-image-260x260', '', '', '2015-11-04 15:45:45', '2015-11-04 15:45:45', '', 141, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png', 0, 'attachment', 'image/png', 0),
(195, 1, '2015-11-04 15:46:35', '2015-11-04 15:46:35', '[vc_row css=".vc_custom_1446651409345{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/image-slider-univers.png?id=177) !important;}"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="blue" border_width="6" el_width="40"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></h4>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/6"][/vc_column][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="40px" align="center"][vc_column_text]\r\n<p style="text-align: center;"><span style="font-weight: 400;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS"][/vc_column][vc_column width="1/4"][/vc_column][vc_column width="1/4"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:46:35', '2015-11-04 15:46:35', '', 141, 'http://micronics.votresitedemo.com/?p=195', 0, 'revision', '', 0),
(196, 1, '2015-11-04 15:47:48', '2015-11-04 15:47:48', '[vc_row css=".vc_custom_1446651409345{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/image-slider-univers.png?id=177) !important;}"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="blue" border_width="6" el_width="40"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></h4>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/6"][/vc_column][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="40px" align="center"][vc_column_text]\r\n<p style="text-align: center;"><span style="font-weight: 400;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][/vc_column][vc_column width="1/4"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:47:48', '2015-11-04 15:47:48', '', 141, 'http://micronics.votresitedemo.com/?p=196', 0, 'revision', '', 0),
(197, 1, '2015-11-04 15:49:41', '2015-11-04 15:49:41', '[vc_row css=".vc_custom_1446651409345{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/image-slider-univers.png?id=177) !important;}"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="blue" border_width="6" el_width="40"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></h4>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/6"][/vc_column][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="40px" align="center"][vc_column_text]\r\n<p style="text-align: center;"><span style="font-weight: 400;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-04 15:49:41', '2015-11-04 15:49:41', '', 141, 'http://micronics.votresitedemo.com/?p=197', 0, 'revision', '', 0),
(198, 1, '2015-11-04 15:53:42', '2015-11-04 15:53:42', '<h1>Redresseur à découpage - Microswitch (0 à 3000 A)</h1>', 'Microswitch (0 à 3000 A)', '', 'inherit', 'closed', 'closed', '', '143-revision-v1', '', '', '2015-11-04 15:53:42', '2015-11-04 15:53:42', '', 143, 'http://micronics.votresitedemo.com/?p=198', 0, 'revision', '', 0),
(199, 1, '2015-11-04 15:54:00', '2015-11-04 15:54:00', '<h3>Redresseur à découpage - Microswitch (0 à 3000 A)</h3>', 'Microswitch (0 à 3000 A)', '', 'inherit', 'closed', 'closed', '', '143-revision-v1', '', '', '2015-11-04 15:54:00', '2015-11-04 15:54:00', '', 143, 'http://micronics.votresitedemo.com/?p=199', 0, 'revision', '', 0),
(200, 1, '2015-11-04 15:54:12', '2015-11-04 15:54:12', '<h2>Redresseur à découpage - Microswitch (0 à 3000 A)</h2>', 'Microswitch (0 à 3000 A)', '', 'inherit', 'closed', 'closed', '', '143-revision-v1', '', '', '2015-11-04 15:54:12', '2015-11-04 15:54:12', '', 143, 'http://micronics.votresitedemo.com/?p=200', 0, 'revision', '', 0),
(201, 1, '2015-11-06 12:39:59', '2015-11-06 12:39:59', '[vc_row][vc_column][vc_column_text]\n<h2>Redresseur à découpage - Microswitch (0 à 3000 A)</h2>\n&nbsp;\n\nCar feerique radieuse dut pressent. Cathedrale le la tu maintenant va redoublait vieillards ordonnance. Pretends le empilait viennent la philippe kolbacks. Groupes drapent menions me etalent je je. Boulevard regardent dissipait pu va. Paraissent admiration decharnees je me tristement etonnement tu du. Pu bouleaux horrible havresac quarante en.\n\nCes porta une grave ont salle. Regard que soldat penser des iii aux arrive cranes. Apprenons ils adjudants son que divergent concierge. Ici nos des feu comme crier voeux. Car portieres reveillez puissions dentelles pas. Effrayant jet nez cauchemar couraient echauffer air nid.\n\n<a href="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png"><img class="size-full wp-image-194 alignleft" src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png" alt="product-image-260x260" width="260" height="260" /></a>Carabines mal fusillade contemple net alternent des fabriques. Son amour mur rendu poing fin parmi. Trahison car defoncat les refletez jeu physique. Me indus tours ii voila houle. Surpris pendant te sourire se tendons arriere. Radieuse il contient on bouleaux.\n\nNet cauchemar ses deroulent des gachettes ton echauffer. Quand ici meres annee rouge les. Bambous mes pouvons torture blottis jet. Electrique vin mon tricolores fit maintenant republique souhaitait. Ah si ivres de etais brave aides metal appel. Le je lisiere chinois qu diables importe. Roc aux viendrait les signalant parlaient attachent seulement. Ah ce frequentes souffrance du gourmettes eclatantes. Vingt ca la hisse doute en leurs annee. Je drapent sa laissez premier.\n\nCet est dit vert tete tira non. Vieille pelouse secouee cet pinacle mauvais rit. Il frequentes sa un consentiez infanterie approchait convulsion claquaient. Premiers sa batisses poitrine garnison du le. La survivants sa condamnait simplement redoublait. Ii comprenez oh philomene evocation uniformes.\n\nCe nous donc deja avec ah tout agit. On fenetres mamelons se agissait ma. Changea au prelude laideur promene mariage te en extreme. On caracolent paraissent evidemment on. Adjudant heureuse kolbacks la on. Nos ont blottis les diables soudain ciments. Impose tu bucher humain je ahuris ii. Conquerir enfantent causaient cesserent nid jeu viendrait certitude.\n\nSinguliers estaminets decharnees etonnement diplomates fer par mur jet. Six style monte mille des. Et sa donnerai chantant repartit tonneaux. Devient on travers pu entendu savants prepare on. Que fit creerent chantant tacherai ete toussent. Bon dentelles conquerir indicible nos agreerait evocation seulement. Dut sol harmonie massacre flottent bon.\n\nMon peu net tetes selon uns haine eumes loups. Suffisait construit courroies he en et. Fraternite entrainait electrique infanterie car ces vieillards. Eux les moi verte lunes seuls breve leurs. Dressait mourants on oh amertume entendit mettions il. Tot caissons feu soudaine aux absorber ton dimanche. Il entrait ca la labeurs premier. Cet fanatiques victorieux asiatiques manoeuvres fin atteignait. Leurs mines celui pu seule ah arbre oh qu.\n\nPiquette laissons comptent la societes en couverts. Agir nous venu en hors arcs joie on. Comme que ton sur chose coeur. Ici comprenez jugements mur ton pic cauchemar printemps sentiment. Crurent fatigue ca pu sa carreau. Nos attique volonte des humains. Inassouvi des neanmoins ils dut poussiere.\n\nWagons et livree en laissa ce soucis. Asie art coin est hate dut peu. Croix ca louis qu wagon le irise forme la utile. Avait air alors herbe net car adore indus mes doute. Assassins attachent apprenons mur fer. Emmener meurtre ici vit symbole mariage eux. Patre ils par essor ronde osait vieil. Ronfle te forces qu oh quelle suivit legion oh. Va un bientot va aurions paysans il comprit faisans sentent. Non renferment fraternite moustachus bas cimetieres ras construits descendons.\n\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][/vc_row]', 'Microswitch (0 à 3000 A)', '', 'inherit', 'closed', 'closed', '', '143-autosave-v1', '', '', '2015-11-06 12:39:59', '2015-11-06 12:39:59', '', 143, 'http://micronics.votresitedemo.com/?p=201', 0, 'revision', '', 0),
(202, 1, '2015-11-04 15:55:27', '2015-11-04 15:55:27', '<h2>Redresseur à découpage - Microswitch (0 à 3000 A)</h2>\r\n&nbsp;\r\n\r\nCar feerique radieuse dut pressent. Cathedrale le la tu maintenant va redoublait vieillards ordonnance. Pretends le empilait viennent la philippe kolbacks. Groupes drapent menions me etalent je je. Boulevard regardent dissipait pu va. Paraissent admiration decharnees je me tristement etonnement tu du. Pu bouleaux horrible havresac quarante en.\r\n\r\nCes porta une grave ont salle. Regard que soldat penser des iii aux arrive cranes. Apprenons ils adjudants son que divergent concierge. Ici nos des feu comme crier voeux. Car portieres reveillez puissions dentelles pas. Effrayant jet nez cauchemar couraient echauffer air nid.\r\n\r\n<a href="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png"><img class="size-full wp-image-194 alignleft" src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png" alt="product-image-260x260" width="260" height="260" /></a>Carabines mal fusillade contemple net alternent des fabriques. Son amour mur rendu poing fin parmi. Trahison car defoncat les refletez jeu physique. Me indus tours ii voila houle. Surpris pendant te sourire se tendons arriere. Radieuse il contient on bouleaux.\r\n\r\nNet cauchemar ses deroulent des gachettes ton echauffer. Quand ici meres annee rouge les. Bambous mes pouvons torture blottis jet. Electrique vin mon tricolores fit maintenant republique souhaitait. Ah si ivres de etais brave aides metal appel. Le je lisiere chinois qu diables importe. Roc aux viendrait les signalant parlaient attachent seulement. Ah ce frequentes souffrance du gourmettes eclatantes. Vingt ca la hisse doute en leurs annee. Je drapent sa laissez premier.\r\n\r\nCet est dit vert tete tira non. Vieille pelouse secouee cet pinacle mauvais rit. Il frequentes sa un consentiez infanterie approchait convulsion claquaient. Premiers sa batisses poitrine garnison du le. La survivants sa condamnait simplement redoublait. Ii comprenez oh philomene evocation uniformes.\r\n\r\nCe nous donc deja avec ah tout agit. On fenetres mamelons se agissait ma. Changea au prelude laideur promene mariage te en extreme. On caracolent paraissent evidemment on. Adjudant heureuse kolbacks la on. Nos ont blottis les diables soudain ciments. Impose tu bucher humain je ahuris ii. Conquerir enfantent causaient cesserent nid jeu viendrait certitude.\r\n\r\nSinguliers estaminets decharnees etonnement diplomates fer par mur jet. Six style monte mille des. Et sa donnerai chantant repartit tonneaux. Devient on travers pu entendu savants prepare on. Que fit creerent chantant tacherai ete toussent. Bon dentelles conquerir indicible nos agreerait evocation seulement. Dut sol harmonie massacre flottent bon.\r\n\r\nMon peu net tetes selon uns haine eumes loups. Suffisait construit courroies he en et. Fraternite entrainait electrique infanterie car ces vieillards. Eux les moi verte lunes seuls breve leurs. Dressait mourants on oh amertume entendit mettions il. Tot caissons feu soudaine aux absorber ton dimanche. Il entrait ca la labeurs premier. Cet fanatiques victorieux asiatiques manoeuvres fin atteignait. Leurs mines celui pu seule ah arbre oh qu.\r\n\r\nPiquette laissons comptent la societes en couverts. Agir nous venu en hors arcs joie on. Comme que ton sur chose coeur. Ici comprenez jugements mur ton pic cauchemar printemps sentiment. Crurent fatigue ca pu sa carreau. Nos attique volonte des humains. Inassouvi des neanmoins ils dut poussiere.\r\n\r\nWagons et livree en laissa ce soucis. Asie art coin est hate dut peu. Croix ca louis qu wagon le irise forme la utile. Avait air alors herbe net car adore indus mes doute. Assassins attachent apprenons mur fer. Emmener meurtre ici vit symbole mariage eux. Patre ils par essor ronde osait vieil. Ronfle te forces qu oh quelle suivit legion oh. Va un bientot va aurions paysans il comprit faisans sentent. Non renferment fraternite moustachus bas cimetieres ras construits descendons.', 'Microswitch (0 à 3000 A)', '', 'inherit', 'closed', 'closed', '', '143-revision-v1', '', '', '2015-11-04 15:55:27', '2015-11-04 15:55:27', '', 143, 'http://micronics.votresitedemo.com/?p=202', 0, 'revision', '', 0),
(203, 1, '2015-11-04 15:57:30', '2015-11-04 15:57:30', '[vc_row][vc_column][vc_column_text]\r\n<h2>Redresseur à découpage - Microswitch (0 à 3000 A)</h2>\r\n&nbsp;\r\n\r\nCar feerique radieuse dut pressent. Cathedrale le la tu maintenant va redoublait vieillards ordonnance. Pretends le empilait viennent la philippe kolbacks. Groupes drapent menions me etalent je je. Boulevard regardent dissipait pu va. Paraissent admiration decharnees je me tristement etonnement tu du. Pu bouleaux horrible havresac quarante en.\r\n\r\nCes porta une grave ont salle. Regard que soldat penser des iii aux arrive cranes. Apprenons ils adjudants son que divergent concierge. Ici nos des feu comme crier voeux. Car portieres reveillez puissions dentelles pas. Effrayant jet nez cauchemar couraient echauffer air nid.\r\n\r\n<a href="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png"><img class="size-full wp-image-194 alignleft" src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png" alt="product-image-260x260" width="260" height="260" /></a>Carabines mal fusillade contemple net alternent des fabriques. Son amour mur rendu poing fin parmi. Trahison car defoncat les refletez jeu physique. Me indus tours ii voila houle. Surpris pendant te sourire se tendons arriere. Radieuse il contient on bouleaux.\r\n\r\nNet cauchemar ses deroulent des gachettes ton echauffer. Quand ici meres annee rouge les. Bambous mes pouvons torture blottis jet. Electrique vin mon tricolores fit maintenant republique souhaitait. Ah si ivres de etais brave aides metal appel. Le je lisiere chinois qu diables importe. Roc aux viendrait les signalant parlaient attachent seulement. Ah ce frequentes souffrance du gourmettes eclatantes. Vingt ca la hisse doute en leurs annee. Je drapent sa laissez premier.\r\n\r\nCet est dit vert tete tira non. Vieille pelouse secouee cet pinacle mauvais rit. Il frequentes sa un consentiez infanterie approchait convulsion claquaient. Premiers sa batisses poitrine garnison du le. La survivants sa condamnait simplement redoublait. Ii comprenez oh philomene evocation uniformes.\r\n\r\nCe nous donc deja avec ah tout agit. On fenetres mamelons se agissait ma. Changea au prelude laideur promene mariage te en extreme. On caracolent paraissent evidemment on. Adjudant heureuse kolbacks la on. Nos ont blottis les diables soudain ciments. Impose tu bucher humain je ahuris ii. Conquerir enfantent causaient cesserent nid jeu viendrait certitude.\r\n\r\nSinguliers estaminets decharnees etonnement diplomates fer par mur jet. Six style monte mille des. Et sa donnerai chantant repartit tonneaux. Devient on travers pu entendu savants prepare on. Que fit creerent chantant tacherai ete toussent. Bon dentelles conquerir indicible nos agreerait evocation seulement. Dut sol harmonie massacre flottent bon.\r\n\r\nMon peu net tetes selon uns haine eumes loups. Suffisait construit courroies he en et. Fraternite entrainait electrique infanterie car ces vieillards. Eux les moi verte lunes seuls breve leurs. Dressait mourants on oh amertume entendit mettions il. Tot caissons feu soudaine aux absorber ton dimanche. Il entrait ca la labeurs premier. Cet fanatiques victorieux asiatiques manoeuvres fin atteignait. Leurs mines celui pu seule ah arbre oh qu.\r\n\r\nPiquette laissons comptent la societes en couverts. Agir nous venu en hors arcs joie on. Comme que ton sur chose coeur. Ici comprenez jugements mur ton pic cauchemar printemps sentiment. Crurent fatigue ca pu sa carreau. Nos attique volonte des humains. Inassouvi des neanmoins ils dut poussiere.\r\n\r\nWagons et livree en laissa ce soucis. Asie art coin est hate dut peu. Croix ca louis qu wagon le irise forme la utile. Avait air alors herbe net car adore indus mes doute. Assassins attachent apprenons mur fer. Emmener meurtre ici vit symbole mariage eux. Patre ils par essor ronde osait vieil. Ronfle te forces qu oh quelle suivit legion oh. Va un bientot va aurions paysans il comprit faisans sentent. Non renferment fraternite moustachus bas cimetieres ras construits descendons.\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" fn_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" fn_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" fn_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" fn_color="#72a0d6"][/vc_column][/vc_row]', 'Microswitch (0 à 3000 A)', '', 'inherit', 'closed', 'closed', '', '143-revision-v1', '', '', '2015-11-04 15:57:30', '2015-11-04 15:57:30', '', 143, 'http://micronics.votresitedemo.com/?p=203', 0, 'revision', '', 0),
(204, 1, '2015-11-04 15:59:55', '2015-11-04 15:59:55', '[vc_row][vc_column][vc_column_text]\r\n<h2>Redresseur à découpage - Microswitch (0 à 3000 A)</h2>\r\n&nbsp;\r\n\r\nCar feerique radieuse dut pressent. Cathedrale le la tu maintenant va redoublait vieillards ordonnance. Pretends le empilait viennent la philippe kolbacks. Groupes drapent menions me etalent je je. Boulevard regardent dissipait pu va. Paraissent admiration decharnees je me tristement etonnement tu du. Pu bouleaux horrible havresac quarante en.\r\n\r\nCes porta une grave ont salle. Regard que soldat penser des iii aux arrive cranes. Apprenons ils adjudants son que divergent concierge. Ici nos des feu comme crier voeux. Car portieres reveillez puissions dentelles pas. Effrayant jet nez cauchemar couraient echauffer air nid.\r\n\r\n<a href="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png"><img class="size-full wp-image-194 alignleft" src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png" alt="product-image-260x260" width="260" height="260" /></a>Carabines mal fusillade contemple net alternent des fabriques. Son amour mur rendu poing fin parmi. Trahison car defoncat les refletez jeu physique. Me indus tours ii voila houle. Surpris pendant te sourire se tendons arriere. Radieuse il contient on bouleaux.\r\n\r\nNet cauchemar ses deroulent des gachettes ton echauffer. Quand ici meres annee rouge les. Bambous mes pouvons torture blottis jet. Electrique vin mon tricolores fit maintenant republique souhaitait. Ah si ivres de etais brave aides metal appel. Le je lisiere chinois qu diables importe. Roc aux viendrait les signalant parlaient attachent seulement. Ah ce frequentes souffrance du gourmettes eclatantes. Vingt ca la hisse doute en leurs annee. Je drapent sa laissez premier.\r\n\r\nCet est dit vert tete tira non. Vieille pelouse secouee cet pinacle mauvais rit. Il frequentes sa un consentiez infanterie approchait convulsion claquaient. Premiers sa batisses poitrine garnison du le. La survivants sa condamnait simplement redoublait. Ii comprenez oh philomene evocation uniformes.\r\n\r\nCe nous donc deja avec ah tout agit. On fenetres mamelons se agissait ma. Changea au prelude laideur promene mariage te en extreme. On caracolent paraissent evidemment on. Adjudant heureuse kolbacks la on. Nos ont blottis les diables soudain ciments. Impose tu bucher humain je ahuris ii. Conquerir enfantent causaient cesserent nid jeu viendrait certitude.\r\n\r\nSinguliers estaminets decharnees etonnement diplomates fer par mur jet. Six style monte mille des. Et sa donnerai chantant repartit tonneaux. Devient on travers pu entendu savants prepare on. Que fit creerent chantant tacherai ete toussent. Bon dentelles conquerir indicible nos agreerait evocation seulement. Dut sol harmonie massacre flottent bon.\r\n\r\nMon peu net tetes selon uns haine eumes loups. Suffisait construit courroies he en et. Fraternite entrainait electrique infanterie car ces vieillards. Eux les moi verte lunes seuls breve leurs. Dressait mourants on oh amertume entendit mettions il. Tot caissons feu soudaine aux absorber ton dimanche. Il entrait ca la labeurs premier. Cet fanatiques victorieux asiatiques manoeuvres fin atteignait. Leurs mines celui pu seule ah arbre oh qu.\r\n\r\nPiquette laissons comptent la societes en couverts. Agir nous venu en hors arcs joie on. Comme que ton sur chose coeur. Ici comprenez jugements mur ton pic cauchemar printemps sentiment. Crurent fatigue ca pu sa carreau. Nos attique volonte des humains. Inassouvi des neanmoins ils dut poussiere.\r\n\r\nWagons et livree en laissa ce soucis. Asie art coin est hate dut peu. Croix ca louis qu wagon le irise forme la utile. Avait air alors herbe net car adore indus mes doute. Assassins attachent apprenons mur fer. Emmener meurtre ici vit symbole mariage eux. Patre ils par essor ronde osait vieil. Ronfle te forces qu oh quelle suivit legion oh. Va un bientot va aurions paysans il comprit faisans sentent. Non renferment fraternite moustachus bas cimetieres ras construits descendons.\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][/vc_column][vc_column width="1/4"][/vc_column][vc_column width="1/4"][/vc_column][/vc_row]', 'Microswitch (0 à 3000 A)', '', 'inherit', 'closed', 'closed', '', '143-revision-v1', '', '', '2015-11-04 15:59:55', '2015-11-04 15:59:55', '', 143, 'http://micronics.votresitedemo.com/?p=204', 0, 'revision', '', 0),
(205, 1, '2015-11-04 16:00:16', '2015-11-04 16:00:16', '[vc_row][vc_column][vc_column_text]\r\n<h2>Redresseur à découpage - Microswitch (0 à 3000 A)</h2>\r\n&nbsp;\r\n\r\nCar feerique radieuse dut pressent. Cathedrale le la tu maintenant va redoublait vieillards ordonnance. Pretends le empilait viennent la philippe kolbacks. Groupes drapent menions me etalent je je. Boulevard regardent dissipait pu va. Paraissent admiration decharnees je me tristement etonnement tu du. Pu bouleaux horrible havresac quarante en.\r\n\r\nCes porta une grave ont salle. Regard que soldat penser des iii aux arrive cranes. Apprenons ils adjudants son que divergent concierge. Ici nos des feu comme crier voeux. Car portieres reveillez puissions dentelles pas. Effrayant jet nez cauchemar couraient echauffer air nid.\r\n\r\n<a href="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png"><img class="size-full wp-image-194 alignleft" src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png" alt="product-image-260x260" width="260" height="260" /></a>Carabines mal fusillade contemple net alternent des fabriques. Son amour mur rendu poing fin parmi. Trahison car defoncat les refletez jeu physique. Me indus tours ii voila houle. Surpris pendant te sourire se tendons arriere. Radieuse il contient on bouleaux.\r\n\r\nNet cauchemar ses deroulent des gachettes ton echauffer. Quand ici meres annee rouge les. Bambous mes pouvons torture blottis jet. Electrique vin mon tricolores fit maintenant republique souhaitait. Ah si ivres de etais brave aides metal appel. Le je lisiere chinois qu diables importe. Roc aux viendrait les signalant parlaient attachent seulement. Ah ce frequentes souffrance du gourmettes eclatantes. Vingt ca la hisse doute en leurs annee. Je drapent sa laissez premier.\r\n\r\nCet est dit vert tete tira non. Vieille pelouse secouee cet pinacle mauvais rit. Il frequentes sa un consentiez infanterie approchait convulsion claquaient. Premiers sa batisses poitrine garnison du le. La survivants sa condamnait simplement redoublait. Ii comprenez oh philomene evocation uniformes.\r\n\r\nCe nous donc deja avec ah tout agit. On fenetres mamelons se agissait ma. Changea au prelude laideur promene mariage te en extreme. On caracolent paraissent evidemment on. Adjudant heureuse kolbacks la on. Nos ont blottis les diables soudain ciments. Impose tu bucher humain je ahuris ii. Conquerir enfantent causaient cesserent nid jeu viendrait certitude.\r\n\r\nSinguliers estaminets decharnees etonnement diplomates fer par mur jet. Six style monte mille des. Et sa donnerai chantant repartit tonneaux. Devient on travers pu entendu savants prepare on. Que fit creerent chantant tacherai ete toussent. Bon dentelles conquerir indicible nos agreerait evocation seulement. Dut sol harmonie massacre flottent bon.\r\n\r\nMon peu net tetes selon uns haine eumes loups. Suffisait construit courroies he en et. Fraternite entrainait electrique infanterie car ces vieillards. Eux les moi verte lunes seuls breve leurs. Dressait mourants on oh amertume entendit mettions il. Tot caissons feu soudaine aux absorber ton dimanche. Il entrait ca la labeurs premier. Cet fanatiques victorieux asiatiques manoeuvres fin atteignait. Leurs mines celui pu seule ah arbre oh qu.\r\n\r\nPiquette laissons comptent la societes en couverts. Agir nous venu en hors arcs joie on. Comme que ton sur chose coeur. Ici comprenez jugements mur ton pic cauchemar printemps sentiment. Crurent fatigue ca pu sa carreau. Nos attique volonte des humains. Inassouvi des neanmoins ils dut poussiere.\r\n\r\nWagons et livree en laissa ce soucis. Asie art coin est hate dut peu. Croix ca louis qu wagon le irise forme la utile. Avait air alors herbe net car adore indus mes doute. Assassins attachent apprenons mur fer. Emmener meurtre ici vit symbole mariage eux. Patre ils par essor ronde osait vieil. Ronfle te forces qu oh quelle suivit legion oh. Va un bientot va aurions paysans il comprit faisans sentent. Non renferment fraternite moustachus bas cimetieres ras construits descendons.\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][/vc_row]', 'Microswitch (0 à 3000 A)', '', 'inherit', 'closed', 'closed', '', '143-revision-v1', '', '', '2015-11-04 16:00:16', '2015-11-04 16:00:16', '', 143, 'http://micronics.votresitedemo.com/?p=205', 0, 'revision', '', 0),
(206, 1, '2015-11-04 16:01:31', '2015-11-04 16:01:31', '[vc_row][vc_column][vc_column_text]\r\n<h2>Redresseur à découpage - Microswitch (0 à 3000 A)</h2>\r\nCar feerique radieuse dut pressent. Cathedrale le la tu maintenant va redoublait vieillards ordonnance. Pretends le empilait viennent la philippe kolbacks. Groupes drapent menions me etalent je je. Boulevard regardent dissipait pu va. Paraissent admiration decharnees je me tristement etonnement tu du. Pu bouleaux horrible havresac quarante en.\r\n\r\nCes porta une grave ont salle. Regard que soldat penser des iii aux arrive cranes. Apprenons ils adjudants son que divergent concierge. Ici nos des feu comme crier voeux. Car portieres reveillez puissions dentelles pas. Effrayant jet nez cauchemar couraient echauffer air nid.\r\n\r\n<a href="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png"><img class="size-full wp-image-194 alignleft" src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png" alt="product-image-260x260" width="260" height="260" /></a>Carabines mal fusillade contemple net alternent des fabriques. Son amour mur rendu poing fin parmi. Trahison car defoncat les refletez jeu physique. Me indus tours ii voila houle. Surpris pendant te sourire se tendons arriere. Radieuse il contient on bouleaux.\r\n\r\nNet cauchemar ses deroulent des gachettes ton echauffer. Quand ici meres annee rouge les. Bambous mes pouvons torture blottis jet. Electrique vin mon tricolores fit maintenant republique souhaitait. Ah si ivres de etais brave aides metal appel. Le je lisiere chinois qu diables importe. Roc aux viendrait les signalant parlaient attachent seulement. Ah ce frequentes souffrance du gourmettes eclatantes. Vingt ca la hisse doute en leurs annee. Je drapent sa laissez premier.\r\n\r\nCet est dit vert tete tira non. Vieille pelouse secouee cet pinacle mauvais rit. Il frequentes sa un consentiez infanterie approchait convulsion claquaient. Premiers sa batisses poitrine garnison du le. La survivants sa condamnait simplement redoublait. Ii comprenez oh philomene evocation uniformes.\r\n\r\nCe nous donc deja avec ah tout agit. On fenetres mamelons se agissait ma. Changea au prelude laideur promene mariage te en extreme. On caracolent paraissent evidemment on. Adjudant heureuse kolbacks la on. Nos ont blottis les diables soudain ciments. Impose tu bucher humain je ahuris ii. Conquerir enfantent causaient cesserent nid jeu viendrait certitude.\r\n\r\nSinguliers estaminets decharnees etonnement diplomates fer par mur jet. Six style monte mille des. Et sa donnerai chantant repartit tonneaux. Devient on travers pu entendu savants prepare on. Que fit creerent chantant tacherai ete toussent. Bon dentelles conquerir indicible nos agreerait evocation seulement. Dut sol harmonie massacre flottent bon.\r\n\r\nMon peu net tetes selon uns haine eumes loups. Suffisait construit courroies he en et. Fraternite entrainait electrique infanterie car ces vieillards. Eux les moi verte lunes seuls breve leurs. Dressait mourants on oh amertume entendit mettions il. Tot caissons feu soudaine aux absorber ton dimanche. Il entrait ca la labeurs premier. Cet fanatiques victorieux asiatiques manoeuvres fin atteignait. Leurs mines celui pu seule ah arbre oh qu.\r\n\r\nPiquette laissons comptent la societes en couverts. Agir nous venu en hors arcs joie on. Comme que ton sur chose coeur. Ici comprenez jugements mur ton pic cauchemar printemps sentiment. Crurent fatigue ca pu sa carreau. Nos attique volonte des humains. Inassouvi des neanmoins ils dut poussiere.\r\n\r\nWagons et livree en laissa ce soucis. Asie art coin est hate dut peu. Croix ca louis qu wagon le irise forme la utile. Avait air alors herbe net car adore indus mes doute. Assassins attachent apprenons mur fer. Emmener meurtre ici vit symbole mariage eux. Patre ils par essor ronde osait vieil. Ronfle te forces qu oh quelle suivit legion oh. Va un bientot va aurions paysans il comprit faisans sentent. Non renferment fraternite moustachus bas cimetieres ras construits descendons.\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][/vc_row]', 'Powerswitch (3000 à 10000 A)', '', 'inherit', 'closed', 'closed', '', '145-revision-v1', '', '', '2015-11-04 16:01:31', '2015-11-04 16:01:31', '', 145, 'http://micronics.votresitedemo.com/?p=206', 0, 'revision', '', 0) ;
INSERT INTO `wp_posts` ( `ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(207, 1, '2015-11-06 12:59:56', '2015-11-06 12:59:56', '[vc_row][vc_column][vc_column_text]\n<h2>Redresseur à découpage - Powerswitch (3000 à 10000 A)</h2>\nCar feerique radieuse dut pressent. Cathedrale le la tu maintenant va redoublait vieillards ordonnance. Pretends le empilait viennent la philippe kolbacks. Groupes drapent menions me etalent je je. Boulevard regardent dissipait pu va. Paraissent admiration decharnees je me tristement etonnement tu du. Pu bouleaux horrible havresac quarante en.\n\nCes porta une grave ont salle. Regard que soldat penser des iii aux arrive cranes. Apprenons ils adjudants son que divergent concierge. Ici nos des feu comme crier voeux. Car portieres reveillez puissions dentelles pas. Effrayant jet nez cauchemar couraient echauffer air nid.\n\n<a href="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png"><img class="size-full wp-image-194 alignleft" src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png" alt="product-image-260x260" width="260" height="260" /></a>Carabines mal fusillade contemple net alternent des fabriques. Son amour mur rendu poing fin parmi. Trahison car defoncat les refletez jeu physique. Me indus tours ii voila houle. Surpris pendant te sourire se tendons arriere. Radieuse il contient on bouleaux.\n\nNet cauchemar ses deroulent des gachettes ton echauffer. Quand ici meres annee rouge les. Bambous mes pouvons torture blottis jet. Electrique vin mon tricolores fit maintenant republique souhaitait. Ah si ivres de etais brave aides metal appel. Le je lisiere chinois qu diables importe. Roc aux viendrait les signalant parlaient attachent seulement. Ah ce frequentes souffrance du gourmettes eclatantes. Vingt ca la hisse doute en leurs annee. Je drapent sa laissez premier.\n\nCet est dit vert tete tira non. Vieille pelouse secouee cet pinacle mauvais rit. Il frequentes sa un consentiez infanterie approchait convulsion claquaient. Premiers sa batisses poitrine garnison du le. La survivants sa condamnait simplement redoublait. Ii comprenez oh philomene evocation uniformes.\n\nCe nous donc deja avec ah tout agit. On fenetres mamelons se agissait ma. Changea au prelude laideur promene mariage te en extreme. On caracolent paraissent evidemment on. Adjudant heureuse kolbacks la on. Nos ont blottis les diables soudain ciments. Impose tu bucher humain je ahuris ii. Conquerir enfantent causaient cesserent nid jeu viendrait certitude.\n\nSinguliers estaminets decharnees etonnement diplomates fer par mur jet. Six style monte mille des. Et sa donnerai chantant repartit tonneaux. Devient on travers pu entendu savants prepare on. Que fit creerent chantant tacherai ete toussent. Bon dentelles conquerir indicible nos agreerait evocation seulement. Dut sol harmonie massacre flottent bon.\n\nMon peu net tetes selon uns haine eumes loups. Suffisait construit courroies he en et. Fraternite entrainait electrique infanterie car ces vieillards. Eux les moi verte lunes seuls breve leurs. Dressait mourants on oh amertume entendit mettions il. Tot caissons feu soudaine aux absorber ton dimanche. Il entrait ca la labeurs premier. Cet fanatiques victorieux asiatiques manoeuvres fin atteignait. Leurs mines celui pu seule ah arbre oh qu.\n\nPiquette laissons comptent la societes en couverts. Agir nous venu en hors arcs joie on. Comme que ton sur chose coeur. Ici comprenez jugements mur ton pic cauchemar printemps sentiment. Crurent fatigue ca pu sa carreau. Nos attique volonte des humains. Inassouvi des neanmoins ils dut poussiere.\n\nWagons et livree en laissa ce soucis. Asie art coin est hate dut peu. Croix ca louis qu wagon le irise forme la utile. Avait air alors herbe net car adore indus mes doute. Assassins attachent apprenons mur fer. Emmener meurtre ici vit symbole mariage eux. Patre ils par essor ronde osait vieil. Ronfle te forces qu oh quelle suivit legion oh. Va un bientot va aurions paysans il comprit faisans sentent. Non renferment fraternite moustachus bas cimetieres ras construits descendons.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][/vc_row]', 'Powerswitch (3000 à 10000 A)', '', 'inherit', 'closed', 'closed', '', '145-autosave-v1', '', '', '2015-11-06 12:59:56', '2015-11-06 12:59:56', '', 145, 'http://micronics.votresitedemo.com/?p=207', 0, 'revision', '', 0),
(208, 1, '2015-11-04 16:04:02', '2015-11-04 16:04:02', '[vc_row][vc_column][vc_column_text]\r\n<h2>Redresseur à découpage - Powerswitch (3000 à 10000 A)</h2>\r\nCar feerique radieuse dut pressent. Cathedrale le la tu maintenant va redoublait vieillards ordonnance. Pretends le empilait viennent la philippe kolbacks. Groupes drapent menions me etalent je je. Boulevard regardent dissipait pu va. Paraissent admiration decharnees je me tristement etonnement tu du. Pu bouleaux horrible havresac quarante en.\r\n\r\nCes porta une grave ont salle. Regard que soldat penser des iii aux arrive cranes. Apprenons ils adjudants son que divergent concierge. Ici nos des feu comme crier voeux. Car portieres reveillez puissions dentelles pas. Effrayant jet nez cauchemar couraient echauffer air nid.\r\n\r\n<a href="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png"><img class="size-full wp-image-194 alignleft" src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png" alt="product-image-260x260" width="260" height="260" /></a>Carabines mal fusillade contemple net alternent des fabriques. Son amour mur rendu poing fin parmi. Trahison car defoncat les refletez jeu physique. Me indus tours ii voila houle. Surpris pendant te sourire se tendons arriere. Radieuse il contient on bouleaux.\r\n\r\nNet cauchemar ses deroulent des gachettes ton echauffer. Quand ici meres annee rouge les. Bambous mes pouvons torture blottis jet. Electrique vin mon tricolores fit maintenant republique souhaitait. Ah si ivres de etais brave aides metal appel. Le je lisiere chinois qu diables importe. Roc aux viendrait les signalant parlaient attachent seulement. Ah ce frequentes souffrance du gourmettes eclatantes. Vingt ca la hisse doute en leurs annee. Je drapent sa laissez premier.\r\n\r\nCet est dit vert tete tira non. Vieille pelouse secouee cet pinacle mauvais rit. Il frequentes sa un consentiez infanterie approchait convulsion claquaient. Premiers sa batisses poitrine garnison du le. La survivants sa condamnait simplement redoublait. Ii comprenez oh philomene evocation uniformes.\r\n\r\nCe nous donc deja avec ah tout agit. On fenetres mamelons se agissait ma. Changea au prelude laideur promene mariage te en extreme. On caracolent paraissent evidemment on. Adjudant heureuse kolbacks la on. Nos ont blottis les diables soudain ciments. Impose tu bucher humain je ahuris ii. Conquerir enfantent causaient cesserent nid jeu viendrait certitude.\r\n\r\nSinguliers estaminets decharnees etonnement diplomates fer par mur jet. Six style monte mille des. Et sa donnerai chantant repartit tonneaux. Devient on travers pu entendu savants prepare on. Que fit creerent chantant tacherai ete toussent. Bon dentelles conquerir indicible nos agreerait evocation seulement. Dut sol harmonie massacre flottent bon.\r\n\r\nMon peu net tetes selon uns haine eumes loups. Suffisait construit courroies he en et. Fraternite entrainait electrique infanterie car ces vieillards. Eux les moi verte lunes seuls breve leurs. Dressait mourants on oh amertume entendit mettions il. Tot caissons feu soudaine aux absorber ton dimanche. Il entrait ca la labeurs premier. Cet fanatiques victorieux asiatiques manoeuvres fin atteignait. Leurs mines celui pu seule ah arbre oh qu.\r\n\r\nPiquette laissons comptent la societes en couverts. Agir nous venu en hors arcs joie on. Comme que ton sur chose coeur. Ici comprenez jugements mur ton pic cauchemar printemps sentiment. Crurent fatigue ca pu sa carreau. Nos attique volonte des humains. Inassouvi des neanmoins ils dut poussiere.\r\n\r\nWagons et livree en laissa ce soucis. Asie art coin est hate dut peu. Croix ca louis qu wagon le irise forme la utile. Avait air alors herbe net car adore indus mes doute. Assassins attachent apprenons mur fer. Emmener meurtre ici vit symbole mariage eux. Patre ils par essor ronde osait vieil. Ronfle te forces qu oh quelle suivit legion oh. Va un bientot va aurions paysans il comprit faisans sentent. Non renferment fraternite moustachus bas cimetieres ras construits descendons.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][/vc_row]', 'Powerswitch (3000 à 10000 A)', '', 'inherit', 'closed', 'closed', '', '145-revision-v1', '', '', '2015-11-04 16:04:02', '2015-11-04 16:04:02', '', 145, 'http://micronics.votresitedemo.com/?p=208', 0, 'revision', '', 0),
(209, 1, '2015-11-04 16:04:38', '2015-11-04 16:04:38', '[vc_row][vc_column][vc_column_text]\r\n<h2>Redresseur à découpage - VTwin (Double sortie)</h2>\r\nCar feerique radieuse dut pressent. Cathedrale le la tu maintenant va redoublait vieillards ordonnance. Pretends le empilait viennent la philippe kolbacks. Groupes drapent menions me etalent je je. Boulevard regardent dissipait pu va. Paraissent admiration decharnees je me tristement etonnement tu du. Pu bouleaux horrible havresac quarante en.\r\n\r\nCes porta une grave ont salle. Regard que soldat penser des iii aux arrive cranes. Apprenons ils adjudants son que divergent concierge. Ici nos des feu comme crier voeux. Car portieres reveillez puissions dentelles pas. Effrayant jet nez cauchemar couraient echauffer air nid.\r\n\r\n<a href="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png"><img class="size-full wp-image-194 alignleft" src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png" alt="product-image-260x260" width="260" height="260" /></a>Carabines mal fusillade contemple net alternent des fabriques. Son amour mur rendu poing fin parmi. Trahison car defoncat les refletez jeu physique. Me indus tours ii voila houle. Surpris pendant te sourire se tendons arriere. Radieuse il contient on bouleaux.\r\n\r\nNet cauchemar ses deroulent des gachettes ton echauffer. Quand ici meres annee rouge les. Bambous mes pouvons torture blottis jet. Electrique vin mon tricolores fit maintenant republique souhaitait. Ah si ivres de etais brave aides metal appel. Le je lisiere chinois qu diables importe. Roc aux viendrait les signalant parlaient attachent seulement. Ah ce frequentes souffrance du gourmettes eclatantes. Vingt ca la hisse doute en leurs annee. Je drapent sa laissez premier.\r\n\r\nCet est dit vert tete tira non. Vieille pelouse secouee cet pinacle mauvais rit. Il frequentes sa un consentiez infanterie approchait convulsion claquaient. Premiers sa batisses poitrine garnison du le. La survivants sa condamnait simplement redoublait. Ii comprenez oh philomene evocation uniformes.\r\n\r\nCe nous donc deja avec ah tout agit. On fenetres mamelons se agissait ma. Changea au prelude laideur promene mariage te en extreme. On caracolent paraissent evidemment on. Adjudant heureuse kolbacks la on. Nos ont blottis les diables soudain ciments. Impose tu bucher humain je ahuris ii. Conquerir enfantent causaient cesserent nid jeu viendrait certitude.\r\n\r\nSinguliers estaminets decharnees etonnement diplomates fer par mur jet. Six style monte mille des. Et sa donnerai chantant repartit tonneaux. Devient on travers pu entendu savants prepare on. Que fit creerent chantant tacherai ete toussent. Bon dentelles conquerir indicible nos agreerait evocation seulement. Dut sol harmonie massacre flottent bon.\r\n\r\nMon peu net tetes selon uns haine eumes loups. Suffisait construit courroies he en et. Fraternite entrainait electrique infanterie car ces vieillards. Eux les moi verte lunes seuls breve leurs. Dressait mourants on oh amertume entendit mettions il. Tot caissons feu soudaine aux absorber ton dimanche. Il entrait ca la labeurs premier. Cet fanatiques victorieux asiatiques manoeuvres fin atteignait. Leurs mines celui pu seule ah arbre oh qu.\r\n\r\nPiquette laissons comptent la societes en couverts. Agir nous venu en hors arcs joie on. Comme que ton sur chose coeur. Ici comprenez jugements mur ton pic cauchemar printemps sentiment. Crurent fatigue ca pu sa carreau. Nos attique volonte des humains. Inassouvi des neanmoins ils dut poussiere.\r\n\r\nWagons et livree en laissa ce soucis. Asie art coin est hate dut peu. Croix ca louis qu wagon le irise forme la utile. Avait air alors herbe net car adore indus mes doute. Assassins attachent apprenons mur fer. Emmener meurtre ici vit symbole mariage eux. Patre ils par essor ronde osait vieil. Ronfle te forces qu oh quelle suivit legion oh. Va un bientot va aurions paysans il comprit faisans sentent. Non renferment fraternite moustachus bas cimetieres ras construits descendons.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][/vc_row]', 'VTwin (Double sortie)', '', 'inherit', 'closed', 'closed', '', '147-revision-v1', '', '', '2015-11-04 16:04:38', '2015-11-04 16:04:38', '', 147, 'http://micronics.votresitedemo.com/?p=209', 0, 'revision', '', 0),
(210, 1, '2015-11-04 16:15:39', '2015-11-04 16:15:39', '', 'Hind-Bold', '', 'publish', 'closed', 'closed', '', 'hind-bold', '', '', '2015-11-04 16:15:39', '2015-11-04 16:15:39', '', 0, 'http://micronics.votresitedemo.com/?post_type=ozy_fonts&#038;p=210', 0, 'ozy_fonts', '', 0),
(211, 1, '2015-11-04 16:11:40', '2015-11-04 16:11:40', '', 'Hind-Medium', '', 'inherit', 'open', 'closed', '', 'hind-medium', '', '', '2015-11-04 16:11:40', '2015-11-04 16:11:40', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Medium.svg', 0, 'attachment', 'image/svg+xml', 0),
(212, 1, '2015-11-04 16:11:41', '2015-11-04 16:11:41', '', 'Hind-Bold', '', 'inherit', 'open', 'closed', '', 'hind-bold', '', '', '2015-11-04 16:11:41', '2015-11-04 16:11:41', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Bold.eot', 0, 'attachment', 'application/vnd.ms-fontobject', 0),
(213, 1, '2015-11-04 16:11:41', '2015-11-04 16:11:41', '', 'Hind-Semibold', '', 'inherit', 'open', 'closed', '', 'hind-semibold', '', '', '2015-11-04 16:11:41', '2015-11-04 16:11:41', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Semibold.eot', 0, 'attachment', 'application/vnd.ms-fontobject', 0),
(214, 1, '2015-11-04 16:11:41', '2015-11-04 16:11:41', '', 'Hind-Regular', '', 'inherit', 'open', 'closed', '', 'hind-regular', '', '', '2015-11-04 16:11:41', '2015-11-04 16:11:41', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Regular.woff', 0, 'attachment', 'application/x-woff', 0),
(215, 1, '2015-11-04 16:11:41', '2015-11-04 16:11:41', '', 'Hind-Bold', '', 'inherit', 'open', 'closed', '', 'hind-bold-2', '', '', '2015-11-04 16:11:41', '2015-11-04 16:11:41', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Bold.woff', 0, 'attachment', 'application/x-woff', 0),
(216, 1, '2015-11-04 16:11:42', '2015-11-04 16:11:42', '', 'Hind-Semibold', '', 'inherit', 'open', 'closed', '', 'hind-semibold-2', '', '', '2015-11-04 16:11:42', '2015-11-04 16:11:42', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Semibold.woff', 0, 'attachment', 'application/x-woff', 0),
(217, 1, '2015-11-04 16:11:42', '2015-11-04 16:11:42', '', 'Hind-Light', '', 'inherit', 'open', 'closed', '', 'hind-light', '', '', '2015-11-04 16:11:42', '2015-11-04 16:11:42', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Light.woff', 0, 'attachment', 'application/x-woff', 0),
(218, 1, '2015-11-04 16:11:42', '2015-11-04 16:11:42', '', 'Hind-Semibold', '', 'inherit', 'open', 'closed', '', 'hind-semibold-3', '', '', '2015-11-04 16:11:42', '2015-11-04 16:11:42', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Semibold.svg', 0, 'attachment', 'image/svg+xml', 0),
(219, 1, '2015-11-04 16:11:43', '2015-11-04 16:11:43', '', 'Hind-Bold', '', 'inherit', 'open', 'closed', '', 'hind-bold-3', '', '', '2015-11-04 16:11:43', '2015-11-04 16:11:43', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Bold.svg', 0, 'attachment', 'image/svg+xml', 0),
(220, 1, '2015-11-04 16:11:43', '2015-11-04 16:11:43', '', 'Hind-Semibold', '', 'inherit', 'open', 'closed', '', 'hind-semibold-4', '', '', '2015-11-04 16:11:43', '2015-11-04 16:11:43', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Semibold.ttf', 0, 'attachment', 'application/octet-stream', 0),
(221, 1, '2015-11-04 16:11:43', '2015-11-04 16:11:43', '', 'Hind-Regular', '', 'inherit', 'open', 'closed', '', 'hind-regular-2', '', '', '2015-11-04 16:11:43', '2015-11-04 16:11:43', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Regular.ttf', 0, 'attachment', 'application/octet-stream', 0),
(222, 1, '2015-11-04 16:11:43', '2015-11-04 16:11:43', '', 'Hind-Regular', '', 'inherit', 'open', 'closed', '', 'hind-regular-3', '', '', '2015-11-04 16:11:43', '2015-11-04 16:11:43', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Regular.eot', 0, 'attachment', 'application/vnd.ms-fontobject', 0),
(223, 1, '2015-11-04 16:11:44', '2015-11-04 16:11:44', '', 'Hind-Medium', '', 'inherit', 'open', 'closed', '', 'hind-medium-2', '', '', '2015-11-04 16:11:44', '2015-11-04 16:11:44', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Medium.eot', 0, 'attachment', 'application/vnd.ms-fontobject', 0),
(224, 1, '2015-11-04 16:11:44', '2015-11-04 16:11:44', '', 'Hind-Medium', '', 'inherit', 'open', 'closed', '', 'hind-medium-3', '', '', '2015-11-04 16:11:44', '2015-11-04 16:11:44', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Medium.woff', 0, 'attachment', 'application/x-woff', 0),
(225, 1, '2015-11-04 16:11:44', '2015-11-04 16:11:44', '', 'Hind-Medium', '', 'inherit', 'open', 'closed', '', 'hind-medium-4', '', '', '2015-11-04 16:11:44', '2015-11-04 16:11:44', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Medium.ttf', 0, 'attachment', 'application/octet-stream', 0),
(226, 1, '2015-11-04 16:11:44', '2015-11-04 16:11:44', '', 'Hind-Light', '', 'inherit', 'open', 'closed', '', 'hind-light-2', '', '', '2015-11-04 16:11:44', '2015-11-04 16:11:44', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Light.ttf', 0, 'attachment', 'application/octet-stream', 0),
(227, 1, '2015-11-04 16:11:44', '2015-11-04 16:11:44', '', 'Hind-Regular', '', 'inherit', 'open', 'closed', '', 'hind-regular-4', '', '', '2015-11-04 16:11:44', '2015-11-04 16:11:44', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Regular.svg', 0, 'attachment', 'image/svg+xml', 0),
(228, 1, '2015-11-04 16:11:45', '2015-11-04 16:11:45', '', 'Hind-Light', '', 'inherit', 'open', 'closed', '', 'hind-light-3', '', '', '2015-11-04 16:11:45', '2015-11-04 16:11:45', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Light.svg', 0, 'attachment', 'image/svg+xml', 0),
(229, 1, '2015-11-04 16:11:45', '2015-11-04 16:11:45', '', 'Hind-Bold', '', 'inherit', 'open', 'closed', '', 'hind-bold-4', '', '', '2015-11-04 16:11:45', '2015-11-04 16:11:45', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Bold.ttf', 0, 'attachment', 'application/octet-stream', 0),
(230, 1, '2015-11-04 16:11:45', '2015-11-04 16:11:45', '', 'Hind-Light', '', 'inherit', 'open', 'closed', '', 'hind-light-4', '', '', '2015-11-04 16:11:45', '2015-11-04 16:11:45', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/Hind-Light.eot', 0, 'attachment', 'application/vnd.ms-fontobject', 0),
(231, 1, '2015-11-04 16:17:48', '2015-11-04 16:17:48', '', 'Hind-Light', '', 'publish', 'closed', 'closed', '', 'hind-light', '', '', '2015-11-04 16:17:48', '2015-11-04 16:17:48', '', 0, 'http://micronics.votresitedemo.com/?post_type=ozy_fonts&#038;p=231', 0, 'ozy_fonts', '', 0),
(232, 1, '2015-11-04 16:19:33', '2015-11-04 16:19:33', '', 'Hind-Medium', '', 'publish', 'closed', 'closed', '', 'hind-medium', '', '', '2015-11-04 16:19:33', '2015-11-04 16:19:33', '', 0, 'http://micronics.votresitedemo.com/?post_type=ozy_fonts&#038;p=232', 0, 'ozy_fonts', '', 0),
(233, 1, '2015-11-04 16:20:54', '2015-11-04 16:20:54', '', 'Hind-Regular', '', 'publish', 'closed', 'closed', '', 'hind-regular', '', '', '2015-11-04 16:20:54', '2015-11-04 16:20:54', '', 0, 'http://micronics.votresitedemo.com/?post_type=ozy_fonts&#038;p=233', 0, 'ozy_fonts', '', 0) ;
INSERT INTO `wp_posts` ( `ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(234, 1, '2015-11-04 16:22:01', '2015-11-04 16:22:01', '', 'Hind-Semibold', '', 'publish', 'closed', 'closed', '', 'hind-semibold', '', '', '2015-11-04 16:22:05', '2015-11-04 16:22:05', '', 0, 'http://micronics.votresitedemo.com/?post_type=ozy_fonts&#038;p=234', 0, 'ozy_fonts', '', 0),
(235, 1, '2015-11-04 16:28:47', '2015-11-04 16:28:47', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h1|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:28:47', '2015-11-04 16:28:47', '', 6, 'http://micronics.votresitedemo.com/?p=235', 0, 'revision', '', 0),
(236, 1, '2015-11-04 16:30:47', '2015-11-04 16:30:47', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446654645435{padding-top: 120px !important;padding-bottom: 120px !important;}"][vc_column][vc_custom_heading source="post_title" font_container="tag:h1|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:30:47', '2015-11-04 16:30:47', '', 6, 'http://micronics.votresitedemo.com/?p=236', 0, 'revision', '', 0),
(237, 1, '2015-11-04 16:31:41', '2015-11-04 16:31:41', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446654645435{padding-top: 120px !important;padding-bottom: 120px !important;}"][vc_column][vc_custom_heading text="Spécialiste en conversion d’énergie" font_container="tag:h1|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:31:41', '2015-11-04 16:31:41', '', 6, 'http://micronics.votresitedemo.com/?p=237', 0, 'revision', '', 0),
(238, 1, '2015-11-04 16:32:07', '2015-11-04 16:32:07', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446654645435{padding-top: 120px !important;padding-bottom: 120px !important;}"][vc_column][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h1|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:32:07', '2015-11-04 16:32:07', '', 6, 'http://micronics.votresitedemo.com/?p=238', 0, 'revision', '', 0),
(239, 1, '2015-11-04 16:32:34', '2015-11-04 16:32:34', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446654645435{padding-top: 120px !important;padding-bottom: 120px !important;}"][vc_column width="1/6"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="2/3"][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h1|text_align:center|color:%23ffffff"][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:32:34', '2015-11-04 16:32:34', '', 6, 'http://micronics.votresitedemo.com/?p=239', 0, 'revision', '', 0),
(240, 1, '2015-11-04 16:33:21', '2015-11-04 16:33:21', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446654645435{padding-top: 120px !important;padding-bottom: 120px !important;}"][vc_column width="1/6"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][/vc_column][vc_column width="2/3"][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h1|text_align:center|color:%23ffffff"][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column][vc_row_inner][vc_column_inner][/vc_column_inner][/vc_row_inner][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:33:21', '2015-11-04 16:33:21', '', 6, 'http://micronics.votresitedemo.com/?p=240', 0, 'revision', '', 0),
(241, 1, '2015-11-04 16:34:39', '2015-11-04 16:34:39', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446654645435{padding-top: 120px !important;padding-bottom: 120px !important;}"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h1|text_align:center|color:%23ffffff"][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:34:39', '2015-11-04 16:34:39', '', 6, 'http://micronics.votresitedemo.com/?p=241', 0, 'revision', '', 0),
(242, 1, '2015-11-04 16:35:42', '2015-11-04 16:35:42', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h2|text_align:center|color:%23ffffff"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:35:42', '2015-11-04 16:35:42', '', 6, 'http://micronics.votresitedemo.com/?p=242', 0, 'revision', '', 0),
(243, 1, '2015-11-04 16:39:52', '2015-11-04 16:39:52', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_row_inner][vc_column_inner width="1/6"][/vc_column_inner][vc_column_inner width="2/3"][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h2|text_align:center|color:%23ffffff"][/vc_column_inner][vc_column_inner width="1/6"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:39:52', '2015-11-04 16:39:52', '', 6, 'http://micronics.votresitedemo.com/?p=243', 0, 'revision', '', 0),
(244, 1, '2015-11-04 16:40:16', '2015-11-04 16:40:16', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_row_inner][vc_column_inner width="1/6"][/vc_column_inner][vc_column_inner width="2/3"][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h1|text_align:center|color:%23ffffff"][/vc_column_inner][vc_column_inner width="1/6"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:40:16', '2015-11-04 16:40:16', '', 6, 'http://micronics.votresitedemo.com/?p=244', 0, 'revision', '', 0),
(245, 1, '2015-11-04 16:40:33', '2015-11-04 16:40:33', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_row_inner][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE EN CONVERSION D’ÉNERGIE" font_container="tag:h1|text_align:center|color:%23ffffff"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:40:33', '2015-11-04 16:40:33', '', 6, 'http://micronics.votresitedemo.com/?p=245', 0, 'revision', '', 0),
(246, 1, '2015-11-04 16:40:59', '2015-11-04 16:40:59', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_row_inner][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|text_align:center|color:%23ffffff"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:40:59', '2015-11-04 16:40:59', '', 6, 'http://micronics.votresitedemo.com/?p=246', 0, 'revision', '', 0),
(247, 1, '2015-11-04 16:41:29', '2015-11-04 16:41:29', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_row_inner css=".vc_custom_1446655287974{padding-top: 120px !important;padding-bottom: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|text_align:center|color:%23ffffff"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:41:29', '2015-11-04 16:41:29', '', 6, 'http://micronics.votresitedemo.com/?p=247', 0, 'revision', '', 0),
(248, 1, '2015-11-04 16:44:32', '2015-11-04 16:44:32', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|text_align:center|color:%23ffffff"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:44:32', '2015-11-04 16:44:32', '', 6, 'http://micronics.votresitedemo.com/?p=248', 0, 'revision', '', 0),
(249, 1, '2015-11-04 16:44:58', '2015-11-04 16:44:58', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|text_align:center|color:%23ffffff"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:44:58', '2015-11-04 16:44:58', '', 6, 'http://micronics.votresitedemo.com/?p=249', 0, 'revision', '', 0),
(250, 1, '2015-11-04 16:45:31', '2015-11-04 16:45:31', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|text_align:center|color:%23ffffff" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:45:31', '2015-11-04 16:45:31', '', 6, 'http://micronics.votresitedemo.com/?p=250', 0, 'revision', '', 0),
(251, 1, '2015-11-04 16:46:20', '2015-11-04 16:46:20', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:60px|text_align:center|color:%23ffffff|line_height:100" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:46:20', '2015-11-04 16:46:20', '', 6, 'http://micronics.votresitedemo.com/?p=251', 0, 'revision', '', 0),
(252, 1, '2015-11-04 16:46:37', '2015-11-04 16:46:37', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:60px|text_align:center|color:%23ffffff" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:46:37', '2015-11-04 16:46:37', '', 6, 'http://micronics.votresitedemo.com/?p=252', 0, 'revision', '', 0),
(253, 1, '2015-11-04 16:46:59', '2015-11-04 16:46:59', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:46:59', '2015-11-04 16:46:59', '', 6, 'http://micronics.votresitedemo.com/?p=253', 0, 'revision', '', 0),
(254, 1, '2015-11-04 16:47:27', '2015-11-04 16:47:27', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:20" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:47:27', '2015-11-04 16:47:27', '', 6, 'http://micronics.votresitedemo.com/?p=254', 0, 'revision', '', 0),
(255, 1, '2015-11-04 16:47:45', '2015-11-04 16:47:45', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:2" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:47:45', '2015-11-04 16:47:45', '', 6, 'http://micronics.votresitedemo.com/?p=255', 0, 'revision', '', 0),
(256, 1, '2015-11-04 16:48:06', '2015-11-04 16:48:06', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:1" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:48:06', '2015-11-04 16:48:06', '', 6, 'http://micronics.votresitedemo.com/?p=256', 0, 'revision', '', 0),
(257, 1, '2015-11-04 16:48:23', '2015-11-04 16:48:23', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:48:23', '2015-11-04 16:48:23', '', 6, 'http://micronics.votresitedemo.com/?p=257', 0, 'revision', '', 0),
(258, 1, '2015-11-04 16:48:44', '2015-11-04 16:48:44', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-04 16:48:44', '2015-11-04 16:48:44', '', 6, 'http://micronics.votresitedemo.com/?p=258', 0, 'revision', '', 0),
(259, 1, '2015-11-04 16:51:15', '2015-11-04 16:51:15', '', 'Alimentation stabilisée', '', 'publish', 'closed', 'closed', '', 'alimentation-stabilisee', '', '', '2015-11-04 16:51:15', '2015-11-04 16:51:15', '', 60, 'http://micronics.votresitedemo.com/?page_id=259', 0, 'page', '', 0),
(260, 1, '2015-11-04 16:51:15', '2015-11-04 16:51:15', '', 'Alimentation stabilisée', '', 'inherit', 'closed', 'closed', '', '259-revision-v1', '', '', '2015-11-04 16:51:15', '2015-11-04 16:51:15', '', 259, 'http://micronics.votresitedemo.com/?p=260', 0, 'revision', '', 0),
(261, 1, '2015-11-04 16:51:32', '2015-11-04 16:51:32', '', 'Générateur pulsé', '', 'publish', 'closed', 'closed', '', 'generateur-pulse', '', '', '2015-11-04 16:51:32', '2015-11-04 16:51:32', '', 60, 'http://micronics.votresitedemo.com/?page_id=261', 0, 'page', '', 0),
(262, 1, '2015-11-04 16:51:32', '2015-11-04 16:51:32', '', 'Générateur pulsé', '', 'inherit', 'closed', 'closed', '', '261-revision-v1', '', '', '2015-11-04 16:51:32', '2015-11-04 16:51:32', '', 261, 'http://micronics.votresitedemo.com/?p=262', 0, 'revision', '', 0),
(263, 1, '2015-11-04 16:51:48', '2015-11-04 16:51:48', '', 'Converstisseur DC-DC', '', 'publish', 'closed', 'closed', '', 'converstisseur-dc-dc', '', '', '2015-11-04 16:51:48', '2015-11-04 16:51:48', '', 60, 'http://micronics.votresitedemo.com/?page_id=263', 0, 'page', '', 0) ;
INSERT INTO `wp_posts` ( `ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(264, 1, '2015-11-04 16:51:48', '2015-11-04 16:51:48', '', 'Converstisseur DC-DC', '', 'inherit', 'closed', 'closed', '', '263-revision-v1', '', '', '2015-11-04 16:51:48', '2015-11-04 16:51:48', '', 263, 'http://micronics.votresitedemo.com/?p=264', 0, 'revision', '', 0),
(265, 1, '2015-11-04 16:52:03', '2015-11-04 16:52:03', '', 'Générateur Torche à Plasma', '', 'publish', 'closed', 'closed', '', 'generateur-torche-a-plasma', '', '', '2015-11-04 16:52:03', '2015-11-04 16:52:03', '', 60, 'http://micronics.votresitedemo.com/?page_id=265', 0, 'page', '', 0),
(266, 1, '2015-11-04 16:52:03', '2015-11-04 16:52:03', '', 'Générateur Torche à Plasma', '', 'inherit', 'closed', 'closed', '', '265-revision-v1', '', '', '2015-11-04 16:52:03', '2015-11-04 16:52:03', '', 265, 'http://micronics.votresitedemo.com/?p=266', 0, 'revision', '', 0),
(267, 1, '2015-11-04 16:52:20', '2015-11-04 16:52:20', '', 'Armoire intégrée', '', 'publish', 'closed', 'closed', '', 'armoire-integree', '', '', '2015-11-04 16:52:20', '2015-11-04 16:52:20', '', 60, 'http://micronics.votresitedemo.com/?page_id=267', 0, 'page', '', 0),
(268, 1, '2015-11-04 16:52:20', '2015-11-04 16:52:20', '', 'Armoire intégrée', '', 'inherit', 'closed', 'closed', '', '267-revision-v1', '', '', '2015-11-04 16:52:20', '2015-11-04 16:52:20', '', 267, 'http://micronics.votresitedemo.com/?p=268', 0, 'revision', '', 0),
(269, 1, '2015-11-04 16:52:36', '2015-11-04 16:52:36', '', 'Coffret Compteur', '', 'publish', 'closed', 'closed', '', 'coffret-compteur', '', '', '2015-11-04 16:52:36', '2015-11-04 16:52:36', '', 60, 'http://micronics.votresitedemo.com/?page_id=269', 0, 'page', '', 0),
(270, 1, '2015-11-04 16:52:36', '2015-11-04 16:52:36', '', 'Coffret Compteur', '', 'inherit', 'closed', 'closed', '', '269-revision-v1', '', '', '2015-11-04 16:52:36', '2015-11-04 16:52:36', '', 269, 'http://micronics.votresitedemo.com/?p=270', 0, 'revision', '', 0),
(271, 1, '2015-11-04 16:52:51', '2015-11-04 16:52:51', '', 'Inverseur de Polarité', '', 'publish', 'closed', 'closed', '', 'inverseur-de-polarite', '', '', '2015-11-04 16:52:51', '2015-11-04 16:52:51', '', 60, 'http://micronics.votresitedemo.com/?page_id=271', 0, 'page', '', 0),
(272, 1, '2015-11-04 16:52:51', '2015-11-04 16:52:51', '', 'Inverseur de Polarité', '', 'inherit', 'closed', 'closed', '', '271-revision-v1', '', '', '2015-11-04 16:52:51', '2015-11-04 16:52:51', '', 271, 'http://micronics.votresitedemo.com/?p=272', 0, 'revision', '', 0),
(273, 1, '2015-11-04 16:54:26', '2015-11-04 16:54:26', ' ', '', '', 'publish', 'closed', 'closed', '', '273', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 60, 'http://micronics.votresitedemo.com/?p=273', 12, 'nav_menu_item', '', 0),
(274, 1, '2015-11-04 16:54:26', '2015-11-04 16:54:26', ' ', '', '', 'publish', 'closed', 'closed', '', '274', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 60, 'http://micronics.votresitedemo.com/?p=274', 11, 'nav_menu_item', '', 0),
(275, 1, '2015-11-04 16:54:26', '2015-11-04 16:54:26', ' ', '', '', 'publish', 'closed', 'closed', '', '275', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 60, 'http://micronics.votresitedemo.com/?p=275', 10, 'nav_menu_item', '', 0),
(276, 1, '2015-11-04 16:54:26', '2015-11-04 16:54:26', ' ', '', '', 'publish', 'closed', 'closed', '', '276', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 60, 'http://micronics.votresitedemo.com/?p=276', 9, 'nav_menu_item', '', 0),
(277, 1, '2015-11-04 16:54:26', '2015-11-04 16:54:26', ' ', '', '', 'publish', 'closed', 'closed', '', '277', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 60, 'http://micronics.votresitedemo.com/?p=277', 8, 'nav_menu_item', '', 0),
(278, 1, '2015-11-04 16:54:26', '2015-11-04 16:54:26', ' ', '', '', 'publish', 'closed', 'closed', '', '278', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 60, 'http://micronics.votresitedemo.com/?p=278', 7, 'nav_menu_item', '', 0),
(279, 1, '2015-11-04 16:54:26', '2015-11-04 16:54:26', ' ', '', '', 'publish', 'closed', 'closed', '', '279', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 60, 'http://micronics.votresitedemo.com/?p=279', 6, 'nav_menu_item', '', 0),
(280, 1, '2015-11-04 16:57:03', '2015-11-04 16:57:03', '', 'DC: COURANT CONTINU', '', 'publish', 'closed', 'closed', '', 'dc-courant-continu', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 0, 'http://micronics.votresitedemo.com/?p=280', 1, 'nav_menu_item', '', 0),
(281, 1, '2015-11-04 16:59:24', '2015-11-04 16:59:24', '', 'AC: COURANT ALTERNATIF', '', 'publish', 'closed', 'closed', '', 'ac-courant-alternatif', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 0, 'http://micronics.votresitedemo.com/?p=281', 13, 'nav_menu_item', '', 0),
(282, 1, '2015-11-04 16:59:54', '2015-11-04 16:59:54', '', 'Source AC', '', 'publish', 'closed', 'closed', '', 'source-ac', '', '', '2015-11-04 16:59:54', '2015-11-04 16:59:54', '', 60, 'http://micronics.votresitedemo.com/?page_id=282', 0, 'page', '', 0),
(283, 1, '2015-11-04 16:59:54', '2015-11-04 16:59:54', '', 'Source AC', '', 'inherit', 'closed', 'closed', '', '282-revision-v1', '', '', '2015-11-04 16:59:54', '2015-11-04 16:59:54', '', 282, 'http://micronics.votresitedemo.com/?p=283', 0, 'revision', '', 0),
(284, 1, '2015-11-04 17:00:05', '2015-11-04 17:00:05', '', 'Onduleur', '', 'publish', 'closed', 'closed', '', 'onduleur', '', '', '2015-11-04 17:00:05', '2015-11-04 17:00:05', '', 60, 'http://micronics.votresitedemo.com/?page_id=284', 0, 'page', '', 0),
(285, 1, '2015-11-04 17:00:05', '2015-11-04 17:00:05', '', 'Onduleur', '', 'inherit', 'closed', 'closed', '', '284-revision-v1', '', '', '2015-11-04 17:00:05', '2015-11-04 17:00:05', '', 284, 'http://micronics.votresitedemo.com/?p=285', 0, 'revision', '', 0),
(286, 1, '2015-11-04 17:00:15', '2015-11-04 17:00:15', '', 'Convertisseur', '', 'publish', 'closed', 'closed', '', 'convertisseur', '', '', '2015-11-04 17:00:15', '2015-11-04 17:00:15', '', 60, 'http://micronics.votresitedemo.com/?page_id=286', 0, 'page', '', 0),
(287, 1, '2015-11-04 17:00:15', '2015-11-04 17:00:15', '', 'Convertisseur', '', 'inherit', 'closed', 'closed', '', '286-revision-v1', '', '', '2015-11-04 17:00:15', '2015-11-04 17:00:15', '', 286, 'http://micronics.votresitedemo.com/?p=287', 0, 'revision', '', 0),
(288, 1, '2015-11-04 17:00:57', '2015-11-04 17:00:57', '', 'Panel Tactile', '', 'publish', 'closed', 'closed', '', 'commande-control', '', '', '2015-11-04 17:01:06', '2015-11-04 17:01:06', '', 60, 'http://micronics.votresitedemo.com/?page_id=288', 0, 'page', '', 0),
(289, 1, '2015-11-04 17:00:57', '2015-11-04 17:00:57', '', 'Commande control', '', 'inherit', 'closed', 'closed', '', '288-revision-v1', '', '', '2015-11-04 17:00:57', '2015-11-04 17:00:57', '', 288, 'http://micronics.votresitedemo.com/?p=289', 0, 'revision', '', 0),
(290, 1, '2015-11-04 17:01:06', '2015-11-04 17:01:06', '', 'Panel Tactile', '', 'inherit', 'closed', 'closed', '', '288-revision-v1', '', '', '2015-11-04 17:01:06', '2015-11-04 17:01:06', '', 288, 'http://micronics.votresitedemo.com/?p=290', 0, 'revision', '', 0),
(291, 1, '2015-11-04 17:01:23', '2015-11-04 17:01:23', '', 'Control Panel', '', 'publish', 'closed', 'closed', '', 'control-panel', '', '', '2015-11-04 17:01:23', '2015-11-04 17:01:23', '', 60, 'http://micronics.votresitedemo.com/?page_id=291', 0, 'page', '', 0),
(292, 1, '2015-11-04 17:01:23', '2015-11-04 17:01:23', '', 'Control Panel', '', 'inherit', 'closed', 'closed', '', '291-revision-v1', '', '', '2015-11-04 17:01:23', '2015-11-04 17:01:23', '', 291, 'http://micronics.votresitedemo.com/?p=292', 0, 'revision', '', 0),
(293, 1, '2015-11-04 17:03:01', '2015-11-04 17:03:01', ' ', '', '', 'publish', 'closed', 'closed', '', '293', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 60, 'http://micronics.votresitedemo.com/?p=293', 16, 'nav_menu_item', '', 0),
(294, 1, '2015-11-04 17:03:01', '2015-11-04 17:03:01', ' ', '', '', 'publish', 'closed', 'closed', '', '294', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 60, 'http://micronics.votresitedemo.com/?p=294', 15, 'nav_menu_item', '', 0),
(295, 1, '2015-11-04 17:03:01', '2015-11-04 17:03:01', ' ', '', '', 'publish', 'closed', 'closed', '', '295', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 60, 'http://micronics.votresitedemo.com/?p=295', 14, 'nav_menu_item', '', 0),
(296, 1, '2015-11-04 17:04:32', '2015-11-04 17:04:32', '', 'COMMANDE CONTROL', '', 'publish', 'closed', 'closed', '', 'commande-control', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 0, 'http://micronics.votresitedemo.com/?p=296', 17, 'nav_menu_item', '', 0),
(297, 1, '2015-11-04 17:04:32', '2015-11-04 17:04:32', ' ', '', '', 'publish', 'closed', 'closed', '', '297', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 60, 'http://micronics.votresitedemo.com/?p=297', 19, 'nav_menu_item', '', 0),
(298, 1, '2015-11-04 17:04:32', '2015-11-04 17:04:32', ' ', '', '', 'publish', 'closed', 'closed', '', '298', '', '', '2015-11-06 12:50:20', '2015-11-06 12:50:20', '', 60, 'http://micronics.votresitedemo.com/?p=298', 18, 'nav_menu_item', '', 0),
(299, 1, '2015-11-05 07:56:32', '2015-11-05 07:56:32', '[vc_row full_height="yes" parallax="content-moving-fade" parallax_image="78" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 07:56:32', '2015-11-05 07:56:32', '', 6, 'http://micronics.votresitedemo.com/?p=299', 0, 'revision', '', 0),
(300, 1, '2015-11-05 07:57:03', '2015-11-05 07:57:03', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 07:57:03', '2015-11-05 07:57:03', '', 6, 'http://micronics.votresitedemo.com/?p=300', 0, 'revision', '', 0),
(301, 1, '2015-11-05 08:10:13', '2015-11-05 08:10:13', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_video="on" bg_slider_images="79,78"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 08:10:13', '2015-11-05 08:10:13', '', 6, 'http://micronics.votresitedemo.com/?p=301', 0, 'revision', '', 0),
(302, 1, '2015-11-05 08:11:17', '2015-11-05 08:11:17', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446711076156{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-circuits.png?id=79) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 08:11:17', '2015-11-05 08:11:17', '', 6, 'http://micronics.votresitedemo.com/?p=302', 0, 'revision', '', 0),
(303, 1, '2015-11-05 09:02:29', '2015-11-05 09:02:29', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446711076156{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-circuits.png?id=79) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 09:02:29', '2015-11-05 09:02:29', '', 6, 'http://micronics.votresitedemo.com/?p=303', 0, 'revision', '', 0),
(304, 1, '2015-11-05 09:04:54', '2015-11-05 09:04:54', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446711076156{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-circuits.png?id=79) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class=".mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 09:04:54', '2015-11-05 09:04:54', '', 6, 'http://micronics.votresitedemo.com/?p=304', 0, 'revision', '', 0),
(305, 1, '2015-11-05 09:05:35', '2015-11-05 09:05:35', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446711076156{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-circuits.png?id=79) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 09:05:35', '2015-11-05 09:05:35', '', 6, 'http://micronics.votresitedemo.com/?p=305', 0, 'revision', '', 0),
(306, 1, '2015-11-05 09:07:39', '2015-11-05 09:07:39', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446711076156{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-circuits.png?id=79) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 09:07:39', '2015-11-05 09:07:39', '', 6, 'http://micronics.votresitedemo.com/?p=306', 0, 'revision', '', 0),
(307, 1, '2015-11-05 09:48:02', '2015-11-05 09:48:02', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446711076156{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-circuits.png?id=79) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="mip_homepage_news"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 09:48:02', '2015-11-05 09:48:02', '', 6, 'http://micronics.votresitedemo.com/?p=307', 0, 'revision', '', 0),
(308, 1, '2015-11-05 10:05:10', '2015-11-05 10:05:10', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446711076156{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-circuits.png?id=79) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_id="home_news"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 10:05:10', '2015-11-05 10:05:10', '', 6, 'http://micronics.votresitedemo.com/?p=308', 0, 'revision', '', 0),
(309, 1, '2015-11-05 10:07:01', '2015-11-05 10:07:01', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446711076156{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-circuits.png?id=79) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_id="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 10:07:01', '2015-11-05 10:07:01', '', 6, 'http://micronics.votresitedemo.com/?p=309', 0, 'revision', '', 0),
(310, 1, '2015-11-05 10:30:15', '2015-11-05 10:30:15', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446711076156{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-circuits.png?id=79) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="97" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 10:30:15', '2015-11-05 10:30:15', '', 6, 'http://micronics.votresitedemo.com/?p=310', 0, 'revision', '', 0),
(311, 1, '2015-11-05 12:17:27', '2015-11-05 12:17:27', '', 'block-industrie', '', 'inherit', 'open', 'closed', '', 'block-industrie', '', '', '2015-11-05 12:17:27', '2015-11-05 12:17:27', '', 6, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/block-industrie.png', 0, 'attachment', 'image/png', 0),
(312, 1, '2015-11-05 12:17:27', '2015-11-05 12:17:27', '', 'block-solution', '', 'inherit', 'open', 'closed', '', 'block-solution', '', '', '2015-11-05 12:17:27', '2015-11-05 12:17:27', '', 6, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/block-solution.png', 0, 'attachment', 'image/png', 0),
(313, 1, '2015-11-05 12:17:28', '2015-11-05 12:17:28', '', 'block-etude', '', 'inherit', 'open', 'closed', '', 'block-etude', '', '', '2015-11-05 12:17:28', '2015-11-05 12:17:28', '', 6, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/block-etude.png', 0, 'attachment', 'image/png', 0),
(314, 1, '2015-11-05 12:17:28', '2015-11-05 12:17:28', '', 'block-eco-conception', '', 'inherit', 'open', 'closed', '', 'block-eco-conception', '', '', '2015-11-05 12:17:28', '2015-11-05 12:17:28', '', 6, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/block-eco-conception.png', 0, 'attachment', 'image/png', 0),
(315, 1, '2015-11-05 12:18:13', '2015-11-05 12:18:13', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446711076156{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-circuits.png?id=79) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446655496316{padding-top: 60px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 12:18:13', '2015-11-05 12:18:13', '', 6, 'http://micronics.votresitedemo.com/?p=315', 0, 'revision', '', 0),
(316, 1, '2015-11-05 12:22:11', '2015-11-05 12:22:11', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446711076156{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-circuits.png?id=79) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446726129513{margin-bottom: 30px !important;padding-top: 60px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 12:22:11', '2015-11-05 12:22:11', '', 6, 'http://micronics.votresitedemo.com/?p=316', 0, 'revision', '', 0),
(317, 1, '2015-11-05 12:22:43', '2015-11-05 12:22:43', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446711076156{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-circuits.png?id=79) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446726161748{margin-bottom: 30px !important;padding-top: 60px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 12:22:43', '2015-11-05 12:22:43', '', 6, 'http://micronics.votresitedemo.com/?p=317', 0, 'revision', '', 0),
(318, 1, '2015-11-05 12:23:32', '2015-11-05 12:23:32', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446711076156{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-circuits.png?id=79) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446726211281{padding-top: 60px !important;padding-bottom: 40px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 12:23:32', '2015-11-05 12:23:32', '', 6, 'http://micronics.votresitedemo.com/?p=318', 0, 'revision', '', 0) ;
INSERT INTO `wp_posts` ( `ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(319, 1, '2015-11-05 12:24:06', '2015-11-05 12:24:06', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446711076156{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-circuits.png?id=79) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/4"][/vc_column_inner][vc_column_inner width="1/2"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/4"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446726245170{padding-top: 60px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 12:24:06', '2015-11-05 12:24:06', '', 6, 'http://micronics.votresitedemo.com/?p=319', 0, 'revision', '', 0),
(320, 1, '2015-11-05 12:26:24', '2015-11-05 12:26:24', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446711076156{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-circuits.png?id=79) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/6"][/vc_column_inner][vc_column_inner width="2/3"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/6"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446726245170{padding-top: 60px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 12:26:24', '2015-11-05 12:26:24', '', 6, 'http://micronics.votresitedemo.com/?p=320', 0, 'revision', '', 0),
(321, 1, '2015-11-05 12:26:57', '2015-11-05 12:26:57', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446726414678{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/6"][/vc_column_inner][vc_column_inner width="2/3"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/6"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446726245170{padding-top: 60px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 12:26:57', '2015-11-05 12:26:57', '', 6, 'http://micronics.votresitedemo.com/?p=321', 0, 'revision', '', 0),
(322, 1, '2015-11-05 12:27:32', '2015-11-05 12:27:32', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446726450677{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/6"][/vc_column_inner][vc_column_inner width="2/3"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/6"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446726245170{padding-top: 60px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-05 12:27:32', '2015-11-05 12:27:32', '', 6, 'http://micronics.votresitedemo.com/?p=322', 0, 'revision', '', 0),
(323, 1, '2015-11-06 07:53:53', '2015-11-06 07:53:53', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446726450677{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner width="1/6"][/vc_column_inner][vc_column_inner width="2/3"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:65|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][vc_column_inner width="1/6"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446726245170{padding-top: 60px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 07:53:53', '2015-11-06 07:53:53', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(324, 1, '2015-11-06 07:55:41', '2015-11-06 07:55:41', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446726450677{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:65|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">MICRONICS SYSTEMS</span></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">UN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446726245170{padding-top: 60px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 07:55:41', '2015-11-06 07:55:41', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(325, 1, '2015-11-06 07:56:58', '2015-11-06 07:56:58', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446726450677{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:65|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4 style="text-align: center;"><strong><span style="color: #ffffff; font-size: 24pt;">MICRONICS SYSTEMS</span></strong></h4>\r\n<h4 style="text-align: center;"><span style="color: #ffffff;"><strong><span style="font-size: 24pt;">UN CONCEPTEUR ET</span></strong> FABRICANT EN ÉLECTRONIQUE DE PUISSANCE</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446726245170{padding-top: 60px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 07:56:58', '2015-11-06 07:56:58', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(326, 1, '2015-11-06 07:58:36', '2015-11-06 07:58:36', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446726450677{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:65|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][vc_column_text]\r\n<h4><span style="color: #ffffff;">micronics systems un concepteur et fabricant en électronique de puissance</span></h4>\r\n[/vc_column_text][vc_row_inner css=".vc_custom_1446726245170{padding-top: 60px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 07:58:36', '2015-11-06 07:58:36', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(327, 1, '2015-11-06 08:00:14', '2015-11-06 08:00:14', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446726450677{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:65|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][vc_custom_heading text="micronics systems\r\nun concepteur et fabricant en électronique de puissance" font_container="tag:h2|font_size:24|text_align:center"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446726245170{padding-top: 60px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:00:14', '2015-11-06 08:00:14', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(328, 1, '2015-11-06 08:01:46', '2015-11-06 08:01:46', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446726450677{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446726245170{padding-top: 60px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:01:46', '2015-11-06 08:01:46', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(329, 1, '2015-11-06 08:03:28', '2015-11-06 08:03:28', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446726450677{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446726245170{padding-top: 60px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:03:28', '2015-11-06 08:03:28', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(330, 1, '2015-11-06 08:03:52', '2015-11-06 08:03:52', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446726450677{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.5" use_theme_fonts="yes"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446726245170{padding-top: 60px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:03:52', '2015-11-06 08:03:52', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(331, 1, '2015-11-06 08:04:25', '2015-11-06 08:04:25', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446726450677{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.5" use_theme_fonts="yes" css=".vc_custom_1446797063951{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446726245170{padding-top: 60px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:04:25', '2015-11-06 08:04:25', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(332, 1, '2015-11-06 08:06:39', '2015-11-06 08:06:39', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446726450677{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.5" use_theme_fonts="yes" css=".vc_custom_1446797063951{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446797197678{padding-top: 90px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:06:39', '2015-11-06 08:06:39', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(333, 1, '2015-11-06 08:09:39', '2015-11-06 08:09:39', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446797377774{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.6" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.5" use_theme_fonts="yes" css=".vc_custom_1446797063951{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446797197678{padding-top: 90px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:09:39', '2015-11-06 08:09:39', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0) ;
INSERT INTO `wp_posts` ( `ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(334, 1, '2015-11-06 08:10:52', '2015-11-06 08:10:52', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" bg_slider="on" bg_slider_images="79,78" css=".vc_custom_1446797377774{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.7" use_theme_fonts="yes" css=".vc_custom_1446797450986{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446797197678{padding-top: 90px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:10:52', '2015-11-06 08:10:52', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(335, 1, '2015-11-06 08:11:40', '2015-11-06 08:11:40', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446797498341{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.7" use_theme_fonts="yes" css=".vc_custom_1446797450986{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446797197678{padding-top: 90px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:11:40', '2015-11-06 08:11:40', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(336, 1, '2015-11-06 08:12:59', '2015-11-06 08:12:59', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446797498341{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.7" use_theme_fonts="yes" css=".vc_custom_1446797450986{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446797577848{padding-top: 120px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:12:59', '2015-11-06 08:12:59', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(337, 1, '2015-11-06 08:13:30', '2015-11-06 08:13:30', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446797498341{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner css=".vc_custom_1446797608823{padding-bottom: 40px !important;}"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.7" use_theme_fonts="yes" css=".vc_custom_1446797450986{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446797577848{padding-top: 120px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:13:30', '2015-11-06 08:13:30', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(338, 1, '2015-11-06 08:14:43', '2015-11-06 08:14:43', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446797498341{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner css=".vc_custom_1446797669437{padding-bottom: 20px !important;}"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.7" use_theme_fonts="yes" css=".vc_custom_1446797450986{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446797681500{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:14:43', '2015-11-06 08:14:43', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(339, 1, '2015-11-06 08:15:44', '2015-11-06 08:15:44', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446797498341{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner css=".vc_custom_1446797669437{padding-bottom: 20px !important;}"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes" css=".vc_custom_1446797743170{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446797681500{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:15:44', '2015-11-06 08:15:44', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(340, 1, '2015-11-06 08:16:50', '2015-11-06 08:16:50', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446797498341{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner css=".vc_custom_1446797669437{padding-bottom: 20px !important;}"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes" css=".vc_custom_1446797743170{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446797681500{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:16:50', '2015-11-06 08:16:50', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(341, 1, '2015-11-06 08:21:17', '2015-11-06 08:21:17', '[vc_row full_width="stretch_row_content_no_spaces" full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446798075986{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner css=".vc_custom_1446797669437{padding-bottom: 20px !important;}"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes" css=".vc_custom_1446797743170{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446797681500{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:21:17', '2015-11-06 08:21:17', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(342, 1, '2015-11-06 08:21:38', '2015-11-06 08:21:38', '[vc_row full_width="stretch_row_content" full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446798096639{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner css=".vc_custom_1446797669437{padding-bottom: 20px !important;}"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes" css=".vc_custom_1446797743170{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446797681500{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:21:38', '2015-11-06 08:21:38', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(343, 1, '2015-11-06 08:21:57', '2015-11-06 08:21:57', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446798115356{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner css=".vc_custom_1446797669437{padding-bottom: 20px !important;}"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes" css=".vc_custom_1446797743170{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446797681500{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:21:57', '2015-11-06 08:21:57', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(344, 1, '2015-11-06 08:22:23', '2015-11-06 08:22:23', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446798115356{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner css=".vc_custom_1446797669437{padding-bottom: 20px !important;}"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes" css=".vc_custom_1446797743170{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446797681500{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:22:23', '2015-11-06 08:22:23', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(345, 1, '2015-11-06 08:22:40', '2015-11-06 08:22:40', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446798115356{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner css=".vc_custom_1446797669437{padding-bottom: 20px !important;}"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes" css=".vc_custom_1446797743170{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446797681500{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:22:40', '2015-11-06 08:22:40', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(346, 1, '2015-11-06 08:25:47', '2015-11-06 08:25:47', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446798115356{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner css=".vc_custom_1446797669437{padding-bottom: 20px !important;}"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes" css=".vc_custom_1446797743170{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446797681500{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4" offset="vc_col-md-offset-3 vc_col-md-3 vc_col-sm-offset-2"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:25:47', '2015-11-06 08:25:47', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(347, 1, '2015-11-06 08:26:42', '2015-11-06 08:26:42', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446798115356{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner css=".vc_custom_1446797669437{padding-bottom: 20px !important;}"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes" css=".vc_custom_1446797743170{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner css=".vc_custom_1446797681500{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:26:42', '2015-11-06 08:26:42', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(348, 1, '2015-11-06 08:31:56', '2015-11-06 08:31:56', '[vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" row_fullheight="1" css=".vc_custom_1446798115356{background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/slider-image-green.png?id=78) !important;}"][vc_column][vc_row_inner css=".vc_custom_1446655471037{padding-top: 120px !important;}"][vc_column_inner css=".vc_custom_1446797669437{padding-bottom: 20px !important;}"][vc_custom_heading text="SPÉCIALISTE\r\nEN CONVERSION D’ÉNERGIE" font_container="tag:h1|font_size:50px|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes"][vc_custom_heading text="MICRONICS SYSTEMS\r\nUN CONCEPTEUR ET FABRICANT EN ÉLECTRONIQUE DE PUISSANCE" font_container="tag:h2|font_size:24|text_align:center|color:%23ffffff|line_height:0.8" use_theme_fonts="yes" css=".vc_custom_1446797743170{padding-top: 40px !important;padding-bottom: 40px !important;}"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="311" caption="" title="Industrie" excerpt="TRaitements de Surface\r\nMétallurgie\r\nSidérurgie" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="312" caption="" title="Solution recherche" excerpt="Laboratoire\r\n\r\n" link_caption="EN SAVOIR PLUS" el_class="mip_home_bloc_height"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="313" caption="" title="Etude et développment" excerpt="Prototype\r\nTest Bench\r\nSource AC &amp; DC" link_caption="EN SAVOIR PLUS"][/vc_column_inner][vc_column_inner el_class="mip_home_bloc_height" width="1/4"][ozy_vc_simpleinfobox image="314" caption="" title="Eco-conception" excerpt="Green products" link_caption="EN SAVOIR PLUS"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row el_class="homenews"][vc_column][ozy_vc_newsbar title="ACTUALITÉS" sub_title="SUIVEZ-NOUS" link=" http://micronics.votresitedemo.com/?page_id=160" link_caption="TOUTES LES ACTUALITÉS"][/vc_column][/vc_row]', 'Accueil', '', 'inherit', 'closed', 'closed', '', '6-revision-v1', '', '', '2015-11-06 08:31:56', '2015-11-06 08:31:56', '', 6, 'http://micronics.votresitedemo.com/6-revision-v1/', 0, 'revision', '', 0),
(349, 1, '2015-11-06 09:43:02', '2015-11-06 09:43:02', '[vc_row css=".vc_custom_1446802981164{padding-top: 20px !important;}"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446636892026{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 09:43:02', '2015-11-06 09:43:02', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(350, 1, '2015-11-06 09:43:22', '2015-11-06 09:43:22', '[vc_row css=".vc_custom_1446803001071{padding-top: 50px !important;}"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446636892026{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 09:43:22', '2015-11-06 09:43:22', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0) ;
INSERT INTO `wp_posts` ( `ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(351, 1, '2015-11-06 09:43:45', '2015-11-06 09:43:45', '[vc_row css=".vc_custom_1446803024071{padding-top: 40px !important;}"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446636892026{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 09:43:45', '2015-11-06 09:43:45', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(352, 1, '2015-11-06 09:45:20', '2015-11-06 09:45:20', '[vc_row css=".vc_custom_1446803024071{padding-top: 40px !important;}"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text_right"]\r\n<h3><span style="font-weight: 400; color: #0267c1;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446636892026{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 09:45:20', '2015-11-06 09:45:20', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(353, 1, '2015-11-06 09:51:37', '2015-11-06 09:51:37', '[vc_row css=".vc_custom_1446803024071{padding-top: 40px !important;}"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text_right"]\r\n<h3><span style="font-weight: 400; color: #000000;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446636892026{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 09:51:37', '2015-11-06 09:51:37', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(354, 1, '2015-11-06 09:52:32', '2015-11-06 09:52:32', '[vc_row css=".vc_custom_1446803024071{padding-top: 40px !important;}"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400; color: #000000;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]<span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span>[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446636892026{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 09:52:32', '2015-11-06 09:52:32', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(355, 1, '2015-11-06 09:53:00', '2015-11-06 09:53:00', '[vc_row css=".vc_custom_1446803024071{padding-top: 40px !important;}"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400; color: #000000;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446636892026{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 09:53:00', '2015-11-06 09:53:00', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(356, 1, '2015-11-06 09:58:14', '2015-11-06 09:58:14', '[vc_row css=".vc_custom_1446803858943{padding-top: 40px !important;}" el_id="mip_societe"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400; color: #000000;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446636892026{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 09:58:14', '2015-11-06 09:58:14', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(357, 1, '2015-11-06 10:00:30', '2015-11-06 10:00:30', '[vc_row css=".vc_custom_1446803858943{padding-top: 40px !important;}" el_id="mip_societe"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446636892026{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:00:30', '2015-11-06 10:00:30', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(358, 1, '2015-11-06 10:06:47', '2015-11-06 10:06:47', '[vc_row css=".vc_custom_1446803858943{padding-top: 40px !important;}" el_id="mip_societe"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446804406131{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:06:47', '2015-11-06 10:06:47', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(359, 1, '2015-11-06 10:07:27', '2015-11-06 10:07:27', '[vc_row css=".vc_custom_1446803858943{padding-top: 40px !important;}" el_id="mip_societe"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446804446049{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:07:27', '2015-11-06 10:07:27', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(360, 1, '2015-11-06 10:10:32', '2015-11-06 10:10:32', '[vc_row css=".vc_custom_1446803858943{padding-top: 40px !important;}" el_id="mip_societe"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces" css=".vc_custom_1446804631016{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:10:32', '2015-11-06 10:10:32', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0) ;
INSERT INTO `wp_posts` ( `ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(361, 1, '2015-11-06 10:11:02', '2015-11-06 10:11:02', '[vc_row css=".vc_custom_1446803858943{padding-top: 40px !important;}" el_id="mip_societe"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row css=".vc_custom_1446804660287{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:11:02', '2015-11-06 10:11:02', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(362, 1, '2015-11-06 10:11:48', '2015-11-06 10:11:48', '[vc_row css=".vc_custom_1446803858943{padding-top: 40px !important;}" el_id="mip_societe"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" css=".vc_custom_1446804707256{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]\r\n\r\n<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>\r\n\r\n&nbsp;\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:11:48', '2015-11-06 10:11:48', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(363, 1, '2015-11-06 10:12:18', '2015-11-06 10:12:18', '[vc_row css=".vc_custom_1446803858943{padding-top: 40px !important;}" el_id="mip_societe"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" row_fullwidth="1" row_vertical_center="1" css=".vc_custom_1446804707256{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:12:18', '2015-11-06 10:12:18', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(364, 1, '2015-11-06 10:13:10', '2015-11-06 10:13:10', '[vc_row css=".vc_custom_1446803858943{padding-top: 40px !important;}" el_id="mip_societe"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446804788420{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:13:10', '2015-11-06 10:13:10', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(365, 1, '2015-11-06 10:13:47', '2015-11-06 10:13:47', '[vc_row css=".vc_custom_1446804825303{padding-top: 40px !important;padding-bottom: -40px !important;}" el_id="mip_societe"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446804788420{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:13:47', '2015-11-06 10:13:47', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(366, 1, '2015-11-06 10:14:42', '2015-11-06 10:14:42', '[vc_row css=".vc_custom_1446804880478{padding-top: 40px !important;}" el_id="mip_societe"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446804788420{background-color: #efeff2 !important;}"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:14:42', '2015-11-06 10:14:42', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(367, 1, '2015-11-06 10:18:52', '2015-11-06 10:18:52', '[vc_row css=".vc_custom_1446805109031{padding-top: 40px !important;}" el_id="mip_societe_section1"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446805094423{background-color: #efeff2 !important;}" el_id="#mip_societe_section2"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:18:52', '2015-11-06 10:18:52', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(368, 1, '2015-11-06 10:23:57', '2015-11-06 10:23:57', '[vc_row css=".vc_custom_1446805109031{padding-top: 40px !important;}" el_id="mip_societe_section1"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446805435087{background-color: #efeff2 !important;}" el_id="mip_societe_section2"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:23:57', '2015-11-06 10:23:57', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(369, 1, '2015-11-06 10:27:40', '2015-11-06 10:27:40', '[vc_row css=".vc_custom_1446805109031{padding-top: 40px !important;}" el_id="mip_societe_section1"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446805435087{background-color: #efeff2 !important;}" el_id="mip_societe_section2"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text css=".vc_custom_1446805658878{padding-top: 40px !important;}"]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:27:40', '2015-11-06 10:27:40', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(370, 1, '2015-11-06 10:28:11', '2015-11-06 10:28:11', '[vc_row css=".vc_custom_1446805109031{padding-top: 40px !important;}" el_id="mip_societe_section1"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446805435087{background-color: #efeff2 !important;}" el_id="mip_societe_section2"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text css=".vc_custom_1446805689580{padding-top: 20px !important;}"]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:28:11', '2015-11-06 10:28:11', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0) ;
INSERT INTO `wp_posts` ( `ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(371, 1, '2015-11-06 10:39:18', '2015-11-06 10:39:18', '[vc_row css=".vc_custom_1446805109031{padding-top: 40px !important;}" el_id="mip_societe_section1"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446805435087{background-color: #efeff2 !important;}" el_id="mip_societe_section2"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text css=".vc_custom_1446805689580{padding-top: 20px !important;}"]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row el_id="mip_societe_section3"][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="5"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:39:18', '2015-11-06 10:39:18', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(372, 1, '2015-11-06 10:43:34', '2015-11-06 10:43:34', '[vc_row css=".vc_custom_1446805109031{padding-top: 40px !important;}" el_id="mip_societe_section1"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446805435087{background-color: #efeff2 !important;}" el_id="mip_societe_section2"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text css=".vc_custom_1446805689580{padding-top: 20px !important;}"]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row el_id="mip_societe_section3"][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="1" title="mip_tabs" no_fill_content_area="true"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:43:34', '2015-11-06 10:43:34', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(373, 1, '2015-11-06 10:44:05', '2015-11-06 10:44:05', '[vc_row css=".vc_custom_1446805109031{padding-top: 40px !important;}" el_id="mip_societe_section1"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446805435087{background-color: #efeff2 !important;}" el_id="mip_societe_section2"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text css=".vc_custom_1446805689580{padding-top: 20px !important;}"]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row el_id="mip_societe_section3"][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="5" active_section="1" no_fill_content_area="true"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:44:05', '2015-11-06 10:44:05', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(374, 1, '2015-11-06 10:45:03', '2015-11-06 10:45:03', '[vc_row css=".vc_custom_1446805109031{padding-top: 40px !important;}" el_id="mip_societe_section1"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446805435087{background-color: #efeff2 !important;}" el_id="mip_societe_section2"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text css=".vc_custom_1446805689580{padding-top: 20px !important;}"]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row el_id="mip_societe_section3"][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs autoplay="10" active_section="1" no_fill_content_area="true"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:45:03', '2015-11-06 10:45:03', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(375, 1, '2015-11-06 10:46:38', '2015-11-06 10:46:38', '[vc_row css=".vc_custom_1446805109031{padding-top: 40px !important;}" el_id="mip_societe_section1"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446805435087{background-color: #efeff2 !important;}" el_id="mip_societe_section2"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text css=".vc_custom_1446805689580{padding-top: 20px !important;}"]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row el_id="mip_societe_section3"][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs color="white" autoplay="10" active_section="1" no_fill_content_area="true"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:46:38', '2015-11-06 10:46:38', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(376, 1, '2015-11-06 10:47:27', '2015-11-06 10:47:27', '[vc_row css=".vc_custom_1446805109031{padding-top: 40px !important;}" el_id="mip_societe_section1"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446805435087{background-color: #efeff2 !important;}" el_id="mip_societe_section2"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text css=".vc_custom_1446805689580{padding-top: 20px !important;}"]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row el_id="mip_societe_section3"][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs shape="round" color="white" autoplay="10" active_section="1" no_fill_content_area="true"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:47:27', '2015-11-06 10:47:27', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(377, 1, '2015-11-06 10:48:00', '2015-11-06 10:48:00', '[vc_row css=".vc_custom_1446805109031{padding-top: 40px !important;}" el_id="mip_societe_section1"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446805435087{background-color: #efeff2 !important;}" el_id="mip_societe_section2"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text css=".vc_custom_1446805689580{padding-top: 20px !important;}"]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row el_id="mip_societe_section3"][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs shape="square" color="white" autoplay="10" active_section="1" no_fill_content_area="true"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:48:00', '2015-11-06 10:48:00', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(378, 1, '2015-11-06 10:51:01', '2015-11-06 10:51:01', '[vc_row css=".vc_custom_1446805109031{padding-top: 40px !important;}" el_id="mip_societe_section1"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446805435087{background-color: #efeff2 !important;}" el_id="mip_societe_section2"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text css=".vc_custom_1446805689580{padding-top: 20px !important;}"]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row el_id="mip_societe_section3"][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs shape="square" color="blue" autoplay="10" active_section="1" no_fill_content_area="true"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:51:01', '2015-11-06 10:51:01', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(379, 1, '2015-11-06 10:51:30', '2015-11-06 10:51:30', '[vc_row css=".vc_custom_1446805109031{padding-top: 40px !important;}" el_id="mip_societe_section1"][vc_column width="1/2"][vc_single_image image="102" img_size="full"][/vc_column][vc_column width="1/2"][vc_column_text el_class="mip_societe_text1_right"]\r\n<h3><span style="font-weight: 400;">Iussisse quod obstinatum oblato non non adulatorum inexorabiles poenae fertur haec fertur iussisse iussisse revocari.</span></h3>\r\n[/vc_column_text][vc_separator][vc_column_text el_class="mip_societe_text2_right"]\r\n<h5><span style="font-weight: 400;">Nec vox accusatoris ulla licet subditicii in his malorum quaerebatur acervis ut saltem specie tenus crimina praescriptis legum committerentur, quod aliquotiens fecere principes saevi: sed quicquid Caesaris implacabilitati sedisset, id velut fas iusque perpensum confestim urgebatur impleri.</span></h5>\r\n[/vc_column_text][/vc_column][/vc_row][vc_row full_height="yes" css=".vc_custom_1446805435087{background-color: #efeff2 !important;}" el_id="mip_societe_section2"][vc_column][ozy_vc_divider caption_size="h3" caption="Celebritati herbidas praesidia amnis egressus ullo tabescebat" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][vc_column_text css=".vc_custom_1446805689580{padding-top: 20px !important;}"]<b><span style="font-weight: 400;">Et quoniam mirari posse quosdam peregrinos existimo haec lecturos forsitan, si contigerit, quamobrem cum oratio ad ea monstranda deflexerit quae Romae gererentur, nihil praeter seditiones narratur et tabernas et vilitates harum similis alias, summatim causas perstringam nusquam a veritate sponte propria digressurus.</span></b>\r\n\r\n<span style="font-weight: 400;">Alios autem dicere aiunt multo etiam inhumanius (quem locum breviter paulo ante perstrinxi) praesidii adiumentique causa, non benevolentiae neque caritatis, amicitias esse expetendas; itaque, ut quisque minimum firmitatis haberet minimumque virium, ita amicitias appetere maxime; ex eo fieri ut mulierculae magis amicitiarum praesidia quaerant quam viri et inopes quam opulenti et calamitosi quam ii qui putentur beati.</span>[/vc_column_text][/vc_column][/vc_row][vc_row el_id="mip_societe_section3"][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="left" caption_position="top" more_custom="on" width="40px" align="left"][ozy_vc_spacer][vc_tta_tabs shape="square" color="white" autoplay="10" active_section="1" no_fill_content_area="true"][vc_tta_section title="Ex et illa" tab_id="1446635988055-5ebab72b-9089"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Hodie" tab_id="1446635988195-7cf634d6-5a55"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Fas iusque" tab_id="1446636005221-e8800c27-22b9"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title="Impleri urgebatur" tab_id="1446636113708-8a54a404-b7c6"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_tabs][/vc_column][vc_column width="1/3"][ozy_vc_testimonials][ozy_vc_testimonial title="John Smith" subtitle="Paris / France" image="124" testimonial_content="Victus universis caro ferina est lactisque abundans copia qua sustentantur, et herbae multiplices et siquae alites capi per aucupium possint, et plerosque mos vidimus frumenti usum et vini penitus ignorantes."][ozy_vc_testimonial title="Jane Doe" subtitle="DNS / Logistic Department" image="126" testimonial_content="Marfa Tumblr locavore, cray meh salvia Portland Carles chillwave fashion axe PBR. Squid farm-to-table McSweeney\'s mixtape try-hard, heirloom photo booth. Ethical four loko forage, messenger bag yr cold-pressed Bushwick."][/ozy_vc_testimonials][/vc_column][/vc_row]', 'Société', '', 'inherit', 'closed', 'closed', '', '45-revision-v1', '', '', '2015-11-06 10:51:30', '2015-11-06 10:51:30', '', 45, 'http://micronics.votresitedemo.com/45-revision-v1/', 0, 'revision', '', 0),
(381, 1, '2015-11-06 11:42:16', '2015-11-06 11:42:16', '[vc_row css=".vc_custom_1446810133798{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/produits1.png?id=380) !important;}"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="blue" border_width="6" el_width="40"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></h4>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/6"][/vc_column][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="40px" align="center"][vc_column_text]\r\n<p style="text-align: center;"><span style="font-weight: 400;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-06 11:42:16', '2015-11-06 11:42:16', '', 141, 'http://micronics.votresitedemo.com/141-revision-v1/', 0, 'revision', '', 0),
(382, 1, '2015-11-06 11:45:36', '2015-11-06 11:45:36', '', 'produits1', '', 'inherit', 'open', 'closed', '', 'produits1', '', '', '2015-11-06 11:45:36', '2015-11-06 11:45:36', '', 141, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/produits1.jpg', 0, 'attachment', 'image/jpeg', 0),
(383, 1, '2015-11-06 11:45:40', '2015-11-06 11:45:40', '[vc_row css=".vc_custom_1446810339429{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/produits1.jpg?id=382) !important;}"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="blue" border_width="6" el_width="40"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></h4>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/6"][/vc_column][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="40px" align="center"][vc_column_text]\r\n<p style="text-align: center;"><span style="font-weight: 400;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-06 11:45:40', '2015-11-06 11:45:40', '', 141, 'http://micronics.votresitedemo.com/141-revision-v1/', 0, 'revision', '', 0) ;
INSERT INTO `wp_posts` ( `ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(384, 1, '2015-11-06 11:46:18', '2015-11-06 11:46:18', '[vc_row css=".vc_custom_1446810376929{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/produits1.jpg?id=382) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="blue" border_width="6" el_width="40"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></h4>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/6"][/vc_column][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="40px" align="center"][vc_column_text]\r\n<p style="text-align: center;"><span style="font-weight: 400;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-06 11:46:18', '2015-11-06 11:46:18', '', 141, 'http://micronics.votresitedemo.com/141-revision-v1/', 0, 'revision', '', 0),
(385, 1, '2015-11-06 11:48:13', '2015-11-06 11:48:13', '[vc_row css=".vc_custom_1446810376929{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/produits1.jpg?id=382) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="blue" border_width="4" el_width="40"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></h4>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/6"][/vc_column][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="40px" align="center"][vc_column_text]\r\n<p style="text-align: center;"><span style="font-weight: 400;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-06 11:48:13', '2015-11-06 11:48:13', '', 141, 'http://micronics.votresitedemo.com/141-revision-v1/', 0, 'revision', '', 0),
(386, 1, '2015-11-06 12:04:46', '2015-11-06 12:04:46', '[vc_row css=".vc_custom_1446810376929{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/produits1.jpg?id=382) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="custom" border_width="4" el_width="40" accent_color="#1e4cc3"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></h4>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/6"][/vc_column][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#34ccff" caption_align="center" caption_position="top" more_custom="on" width="40px" align="center"][vc_column_text]\r\n<p style="text-align: center;"><span style="font-weight: 400;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-06 12:04:46', '2015-11-06 12:04:46', '', 141, 'http://micronics.votresitedemo.com/141-revision-v1/', 0, 'revision', '', 0),
(387, 1, '2015-11-06 12:05:54', '2015-11-06 12:05:54', '[vc_row css=".vc_custom_1446810376929{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/produits1.jpg?id=382) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="custom" border_width="4" el_width="40" accent_color="#1e4cc4"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></h4>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/6"][/vc_column][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#1e4cc4" caption_align="center" caption_position="top" more_custom="on" width="40px" align="center"][vc_column_text]\r\n<p style="text-align: center;"><span style="font-weight: 400;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-06 12:05:54', '2015-11-06 12:05:54', '', 141, 'http://micronics.votresitedemo.com/141-revision-v1/', 0, 'revision', '', 0),
(388, 1, '2015-11-06 12:09:49', '2015-11-06 12:09:49', '[vc_row css=".vc_custom_1446811755292{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/produits1.jpg?id=382) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_id="mip_univers_section1"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="custom" border_width="4" el_width="40" accent_color="#1e4cc4"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></h4>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row el_id="mip_univers_section2"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#1e4cc4" caption_align="center" caption_position="top" more_custom="on" width="40px" align="center"][vc_column_text]\r\n<p style="text-align: center;"><span style="font-weight: 400;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row el_id="mip_univers_section3"][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#72a0d6"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-06 12:09:49', '2015-11-06 12:09:49', '', 141, 'http://micronics.votresitedemo.com/141-revision-v1/', 0, 'revision', '', 0),
(389, 1, '2015-11-06 12:23:30', '2015-11-06 12:23:30', '[vc_row css=".vc_custom_1446811755292{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/produits1.jpg?id=382) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_id="mip_univers_section1"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="custom" border_width="4" el_width="40" accent_color="#0267c1"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></h4>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row el_id="mip_univers_section2"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="center" caption_position="top" more_custom="on" width="40px" align="center"][vc_column_text]\r\n<p style="text-align: center;"><span style="font-weight: 400;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row el_id="mip_univers_section3"][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#0267c1"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#0267c1"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#0267c1"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" hover_caption="DÉTAILS" bg_color="#0267c1"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-06 12:23:30', '2015-11-06 12:23:30', '', 141, 'http://micronics.votresitedemo.com/141-revision-v1/', 0, 'revision', '', 0),
(390, 1, '2015-11-06 12:24:18', '2015-11-06 12:24:18', '[vc_row css=".vc_custom_1446811755292{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/produits1.jpg?id=382) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_id="mip_univers_section1"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="custom" border_width="4" el_width="40" accent_color="#0267c1"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></h4>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row el_id="mip_univers_section2"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="center" caption_position="top" more_custom="on" width="40px" align="center"][vc_column_text]\r\n<p style="text-align: center;"><span style="font-weight: 400;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row el_id="mip_univers_section3"][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1"][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1"][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-06 12:24:18', '2015-11-06 12:24:18', '', 141, 'http://micronics.votresitedemo.com/141-revision-v1/', 0, 'revision', '', 0),
(391, 1, '2015-11-06 12:25:22', '2015-11-06 12:25:22', '[vc_row css=".vc_custom_1446811755292{padding-top: 170px !important;padding-bottom: 170px !important;background-image: url(http://micronics.votresitedemo.com/wp-content/uploads/2015/11/produits1.jpg?id=382) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_id="mip_univers_section1"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][vc_column_text]\r\n<h1 style="text-align: center;"><span style="color: #ffffff;">Redresseur à découpage</span></h1>\r\n[/vc_column_text][vc_separator color="custom" border_width="4" el_width="40" accent_color="#0267c1"][vc_column_text]\r\n<h4 style="text-align: center;"><span style="color: #ffffff;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></h4>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row el_id="mip_univers_section2"][vc_column width="1/6"][/vc_column][vc_column width="2/3"][ozy_vc_divider caption_size="h3" caption="Tribunus familiares hemicyclio" border_style="solid" border_size="2" border_color="#0267c1" caption_align="center" caption_position="top" more_custom="on" width="40px" align="center"][vc_column_text]\r\n<p style="text-align: center;"><span style="font-weight: 400;">Haec et huius modi quaedam innumerabilia ultrix facinorum impiorum bonorumque praemiatrix aliquotiens operatur Adrastia atque utinam semper quam vocabulo duplici etiam Nemesim appellamus: ius quoddam sublime numinis efficacis, humanarum mentium opinione lunari circulo superpositum.</span></p>\r\n[/vc_column_text][/vc_column][vc_column width="1/6"][/vc_column][/vc_row][vc_row el_id="mip_univers_section3"][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][/vc_row]', 'Redresseur à découpage', '', 'inherit', 'closed', 'closed', '', '141-revision-v1', '', '', '2015-11-06 12:25:22', '2015-11-06 12:25:22', '', 141, 'http://micronics.votresitedemo.com/141-revision-v1/', 0, 'revision', '', 0),
(392, 1, '2015-11-06 12:40:26', '2015-11-06 12:40:26', '[vc_row][vc_column][vc_column_text]\r\n<h2>Redresseur à découpage - Microswitch (0 à 3000 A)</h2>\r\n&nbsp;\r\n\r\nCar feerique radieuse dut pressent. Cathedrale le la tu maintenant va redoublait vieillards ordonnance. Pretends le empilait viennent la philippe kolbacks. Groupes drapent menions me etalent je je. Boulevard regardent dissipait pu va. Paraissent admiration decharnees je me tristement etonnement tu du. Pu bouleaux horrible havresac quarante en.\r\n\r\nCes porta une grave ont salle. Regard que soldat penser des iii aux arrive cranes. Apprenons ils adjudants son que divergent concierge. Ici nos des feu comme crier voeux. Car portieres reveillez puissions dentelles pas. Effrayant jet nez cauchemar couraient echauffer air nid.\r\n\r\n<a href="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png"><img class="size-full wp-image-194 alignleft" src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png" alt="product-image-260x260" width="260" height="260" /></a>Carabines mal fusillade contemple net alternent des fabriques. Son amour mur rendu poing fin parmi. Trahison car defoncat les refletez jeu physique. Me indus tours ii voila houle. Surpris pendant te sourire se tendons arriere. Radieuse il contient on bouleaux.\r\n\r\nNet cauchemar ses deroulent des gachettes ton echauffer. Quand ici meres annee rouge les. Bambous mes pouvons torture blottis jet. Electrique vin mon tricolores fit maintenant republique souhaitait. Ah si ivres de etais brave aides metal appel. Le je lisiere chinois qu diables importe. Roc aux viendrait les signalant parlaient attachent seulement. Ah ce frequentes souffrance du gourmettes eclatantes. Vingt ca la hisse doute en leurs annee. Je drapent sa laissez premier.\r\n\r\nCet est dit vert tete tira non. Vieille pelouse secouee cet pinacle mauvais rit. Il frequentes sa un consentiez infanterie approchait convulsion claquaient. Premiers sa batisses poitrine garnison du le. La survivants sa condamnait simplement redoublait. Ii comprenez oh philomene evocation uniformes.\r\n\r\nCe nous donc deja avec ah tout agit. On fenetres mamelons se agissait ma. Changea au prelude laideur promene mariage te en extreme. On caracolent paraissent evidemment on. Adjudant heureuse kolbacks la on. Nos ont blottis les diables soudain ciments. Impose tu bucher humain je ahuris ii. Conquerir enfantent causaient cesserent nid jeu viendrait certitude.\r\n\r\nSinguliers estaminets decharnees etonnement diplomates fer par mur jet. Six style monte mille des. Et sa donnerai chantant repartit tonneaux. Devient on travers pu entendu savants prepare on. Que fit creerent chantant tacherai ete toussent. Bon dentelles conquerir indicible nos agreerait evocation seulement. Dut sol harmonie massacre flottent bon.\r\n\r\nMon peu net tetes selon uns haine eumes loups. Suffisait construit courroies he en et. Fraternite entrainait electrique infanterie car ces vieillards. Eux les moi verte lunes seuls breve leurs. Dressait mourants on oh amertume entendit mettions il. Tot caissons feu soudaine aux absorber ton dimanche. Il entrait ca la labeurs premier. Cet fanatiques victorieux asiatiques manoeuvres fin atteignait. Leurs mines celui pu seule ah arbre oh qu.\r\n\r\nPiquette laissons comptent la societes en couverts. Agir nous venu en hors arcs joie on. Comme que ton sur chose coeur. Ici comprenez jugements mur ton pic cauchemar printemps sentiment. Crurent fatigue ca pu sa carreau. Nos attique volonte des humains. Inassouvi des neanmoins ils dut poussiere.\r\n\r\nWagons et livree en laissa ce soucis. Asie art coin est hate dut peu. Croix ca louis qu wagon le irise forme la utile. Avait air alors herbe net car adore indus mes doute. Assassins attachent apprenons mur fer. Emmener meurtre ici vit symbole mariage eux. Patre ils par essor ronde osait vieil. Ronfle te forces qu oh quelle suivit legion oh. Va un bientot va aurions paysans il comprit faisans sentent. Non renferment fraternite moustachus bas cimetieres ras construits descendons.\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][/vc_row]', 'Microswitch (0 à 3000 A)', '', 'inherit', 'closed', 'closed', '', '143-revision-v1', '', '', '2015-11-06 12:40:26', '2015-11-06 12:40:26', '', 143, 'http://micronics.votresitedemo.com/143-revision-v1/', 0, 'revision', '', 0),
(393, 1, '2015-11-06 12:55:42', '2015-11-06 12:55:42', '', 'operator', '', 'inherit', 'open', 'closed', '', 'operator-2', '', '', '2015-11-06 12:55:42', '2015-11-06 12:55:42', '', 0, 'http://micronics.votresitedemo.com/wp-content/uploads/2015/11/operator1.png', 0, 'attachment', 'image/png', 0),
(394, 1, '2015-11-06 12:58:46', '2015-11-06 12:58:46', '[vc_row][vc_column][vc_column_text]\r\n<h2>Redresseur à découpage - Microswitch (0 à 3000 A)</h2>\r\n&nbsp;\r\n\r\nCar feerique radieuse dut pressent. Cathedrale le la tu maintenant va redoublait vieillards ordonnance. Pretends le empilait viennent la philippe kolbacks. Groupes drapent menions me etalent je je. Boulevard regardent dissipait pu va. Paraissent admiration decharnees je me tristement etonnement tu du. Pu bouleaux horrible havresac quarante en.\r\n\r\nCes porta une grave ont salle. Regard que soldat penser des iii aux arrive cranes. Apprenons ils adjudants son que divergent concierge. Ici nos des feu comme crier voeux. Car portieres reveillez puissions dentelles pas. Effrayant jet nez cauchemar couraient echauffer air nid.\r\n\r\n<a href="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png"><img class="size-full wp-image-194 alignleft" src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png" alt="product-image-260x260" width="260" height="260" /></a>Carabines mal fusillade contemple net alternent des fabriques. Son amour mur rendu poing fin parmi. Trahison car defoncat les refletez jeu physique. Me indus tours ii voila houle. Surpris pendant te sourire se tendons arriere. Radieuse il contient on bouleaux.\r\n\r\nNet cauchemar ses deroulent des gachettes ton echauffer. Quand ici meres annee rouge les. Bambous mes pouvons torture blottis jet. Electrique vin mon tricolores fit maintenant republique souhaitait. Ah si ivres de etais brave aides metal appel. Le je lisiere chinois qu diables importe. Roc aux viendrait les signalant parlaient attachent seulement. Ah ce frequentes souffrance du gourmettes eclatantes. Vingt ca la hisse doute en leurs annee. Je drapent sa laissez premier.\r\n\r\nCet est dit vert tete tira non. Vieille pelouse secouee cet pinacle mauvais rit. Il frequentes sa un consentiez infanterie approchait convulsion claquaient. Premiers sa batisses poitrine garnison du le. La survivants sa condamnait simplement redoublait. Ii comprenez oh philomene evocation uniformes.\r\n\r\nCe nous donc deja avec ah tout agit. On fenetres mamelons se agissait ma. Changea au prelude laideur promene mariage te en extreme. On caracolent paraissent evidemment on. Adjudant heureuse kolbacks la on. Nos ont blottis les diables soudain ciments. Impose tu bucher humain je ahuris ii. Conquerir enfantent causaient cesserent nid jeu viendrait certitude.\r\n\r\nSinguliers estaminets decharnees etonnement diplomates fer par mur jet. Six style monte mille des. Et sa donnerai chantant repartit tonneaux. Devient on travers pu entendu savants prepare on. Que fit creerent chantant tacherai ete toussent. Bon dentelles conquerir indicible nos agreerait evocation seulement. Dut sol harmonie massacre flottent bon.\r\n\r\nMon peu net tetes selon uns haine eumes loups. Suffisait construit courroies he en et. Fraternite entrainait electrique infanterie car ces vieillards. Eux les moi verte lunes seuls breve leurs. Dressait mourants on oh amertume entendit mettions il. Tot caissons feu soudaine aux absorber ton dimanche. Il entrait ca la labeurs premier. Cet fanatiques victorieux asiatiques manoeuvres fin atteignait. Leurs mines celui pu seule ah arbre oh qu.\r\n\r\nPiquette laissons comptent la societes en couverts. Agir nous venu en hors arcs joie on. Comme que ton sur chose coeur. Ici comprenez jugements mur ton pic cauchemar printemps sentiment. Crurent fatigue ca pu sa carreau. Nos attique volonte des humains. Inassouvi des neanmoins ils dut poussiere.\r\n\r\nWagons et livree en laissa ce soucis. Asie art coin est hate dut peu. Croix ca louis qu wagon le irise forme la utile. Avait air alors herbe net car adore indus mes doute. Assassins attachent apprenons mur fer. Emmener meurtre ici vit symbole mariage eux. Patre ils par essor ronde osait vieil. Ronfle te forces qu oh quelle suivit legion oh. Va un bientot va aurions paysans il comprit faisans sentent. Non renferment fraternite moustachus bas cimetieres ras construits descendons.\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="" tag=""][/vc_column][/vc_row]', 'Microswitch (0 à 3000 A)', '', 'inherit', 'closed', 'closed', '', '143-revision-v1', '', '', '2015-11-06 12:58:46', '2015-11-06 12:58:46', '', 143, 'http://micronics.votresitedemo.com/143-revision-v1/', 0, 'revision', '', 0),
(395, 1, '2015-11-06 13:00:46', '2015-11-06 13:00:46', '[vc_row][vc_column][vc_column_text]\r\n<h2>Redresseur à découpage - Powerswitch (3000 à 10000 A)</h2>\r\nCar feerique radieuse dut pressent. Cathedrale le la tu maintenant va redoublait vieillards ordonnance. Pretends le empilait viennent la philippe kolbacks. Groupes drapent menions me etalent je je. Boulevard regardent dissipait pu va. Paraissent admiration decharnees je me tristement etonnement tu du. Pu bouleaux horrible havresac quarante en.\r\n\r\nCes porta une grave ont salle. Regard que soldat penser des iii aux arrive cranes. Apprenons ils adjudants son que divergent concierge. Ici nos des feu comme crier voeux. Car portieres reveillez puissions dentelles pas. Effrayant jet nez cauchemar couraient echauffer air nid.\r\n\r\n<a href="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png"><img class="size-full wp-image-194 alignleft" src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png" alt="product-image-260x260" width="260" height="260" /></a>Carabines mal fusillade contemple net alternent des fabriques. Son amour mur rendu poing fin parmi. Trahison car defoncat les refletez jeu physique. Me indus tours ii voila houle. Surpris pendant te sourire se tendons arriere. Radieuse il contient on bouleaux.\r\n\r\nNet cauchemar ses deroulent des gachettes ton echauffer. Quand ici meres annee rouge les. Bambous mes pouvons torture blottis jet. Electrique vin mon tricolores fit maintenant republique souhaitait. Ah si ivres de etais brave aides metal appel. Le je lisiere chinois qu diables importe. Roc aux viendrait les signalant parlaient attachent seulement. Ah ce frequentes souffrance du gourmettes eclatantes. Vingt ca la hisse doute en leurs annee. Je drapent sa laissez premier.\r\n\r\nCet est dit vert tete tira non. Vieille pelouse secouee cet pinacle mauvais rit. Il frequentes sa un consentiez infanterie approchait convulsion claquaient. Premiers sa batisses poitrine garnison du le. La survivants sa condamnait simplement redoublait. Ii comprenez oh philomene evocation uniformes.\r\n\r\nCe nous donc deja avec ah tout agit. On fenetres mamelons se agissait ma. Changea au prelude laideur promene mariage te en extreme. On caracolent paraissent evidemment on. Adjudant heureuse kolbacks la on. Nos ont blottis les diables soudain ciments. Impose tu bucher humain je ahuris ii. Conquerir enfantent causaient cesserent nid jeu viendrait certitude.\r\n\r\nSinguliers estaminets decharnees etonnement diplomates fer par mur jet. Six style monte mille des. Et sa donnerai chantant repartit tonneaux. Devient on travers pu entendu savants prepare on. Que fit creerent chantant tacherai ete toussent. Bon dentelles conquerir indicible nos agreerait evocation seulement. Dut sol harmonie massacre flottent bon.\r\n\r\nMon peu net tetes selon uns haine eumes loups. Suffisait construit courroies he en et. Fraternite entrainait electrique infanterie car ces vieillards. Eux les moi verte lunes seuls breve leurs. Dressait mourants on oh amertume entendit mettions il. Tot caissons feu soudaine aux absorber ton dimanche. Il entrait ca la labeurs premier. Cet fanatiques victorieux asiatiques manoeuvres fin atteignait. Leurs mines celui pu seule ah arbre oh qu.\r\n\r\nPiquette laissons comptent la societes en couverts. Agir nous venu en hors arcs joie on. Comme que ton sur chose coeur. Ici comprenez jugements mur ton pic cauchemar printemps sentiment. Crurent fatigue ca pu sa carreau. Nos attique volonte des humains. Inassouvi des neanmoins ils dut poussiere.\r\n\r\nWagons et livree en laissa ce soucis. Asie art coin est hate dut peu. Croix ca louis qu wagon le irise forme la utile. Avait air alors herbe net car adore indus mes doute. Assassins attachent apprenons mur fer. Emmener meurtre ici vit symbole mariage eux. Patre ils par essor ronde osait vieil. Ronfle te forces qu oh quelle suivit legion oh. Va un bientot va aurions paysans il comprit faisans sentent. Non renferment fraternite moustachus bas cimetieres ras construits descendons.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][/vc_row]', 'Powerswitch (3000 à 10000 A)', '', 'inherit', 'closed', 'closed', '', '145-revision-v1', '', '', '2015-11-06 13:00:46', '2015-11-06 13:00:46', '', 145, 'http://micronics.votresitedemo.com/145-revision-v1/', 0, 'revision', '', 0),
(396, 1, '2015-11-06 13:01:44', '2015-11-06 13:01:44', '[vc_row][vc_column][vc_column_text]\r\n<h2>Redresseur à découpage - Microswitch (0 à 3000 A)</h2>\r\n&nbsp;\r\n\r\nCar feerique radieuse dut pressent. Cathedrale le la tu maintenant va redoublait vieillards ordonnance. Pretends le empilait viennent la philippe kolbacks. Groupes drapent menions me etalent je je. Boulevard regardent dissipait pu va. Paraissent admiration decharnees je me tristement etonnement tu du. Pu bouleaux horrible havresac quarante en.\r\n\r\nCes porta une grave ont salle. Regard que soldat penser des iii aux arrive cranes. Apprenons ils adjudants son que divergent concierge. Ici nos des feu comme crier voeux. Car portieres reveillez puissions dentelles pas. Effrayant jet nez cauchemar couraient echauffer air nid.\r\n\r\n<a href="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png"><img class="size-full wp-image-194 alignleft" src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png" alt="product-image-260x260" width="260" height="260" /></a>Carabines mal fusillade contemple net alternent des fabriques. Son amour mur rendu poing fin parmi. Trahison car defoncat les refletez jeu physique. Me indus tours ii voila houle. Surpris pendant te sourire se tendons arriere. Radieuse il contient on bouleaux.\r\n\r\nNet cauchemar ses deroulent des gachettes ton echauffer. Quand ici meres annee rouge les. Bambous mes pouvons torture blottis jet. Electrique vin mon tricolores fit maintenant republique souhaitait. Ah si ivres de etais brave aides metal appel. Le je lisiere chinois qu diables importe. Roc aux viendrait les signalant parlaient attachent seulement. Ah ce frequentes souffrance du gourmettes eclatantes. Vingt ca la hisse doute en leurs annee. Je drapent sa laissez premier.\r\n\r\nCet est dit vert tete tira non. Vieille pelouse secouee cet pinacle mauvais rit. Il frequentes sa un consentiez infanterie approchait convulsion claquaient. Premiers sa batisses poitrine garnison du le. La survivants sa condamnait simplement redoublait. Ii comprenez oh philomene evocation uniformes.\r\n\r\nCe nous donc deja avec ah tout agit. On fenetres mamelons se agissait ma. Changea au prelude laideur promene mariage te en extreme. On caracolent paraissent evidemment on. Adjudant heureuse kolbacks la on. Nos ont blottis les diables soudain ciments. Impose tu bucher humain je ahuris ii. Conquerir enfantent causaient cesserent nid jeu viendrait certitude.\r\n\r\nSinguliers estaminets decharnees etonnement diplomates fer par mur jet. Six style monte mille des. Et sa donnerai chantant repartit tonneaux. Devient on travers pu entendu savants prepare on. Que fit creerent chantant tacherai ete toussent. Bon dentelles conquerir indicible nos agreerait evocation seulement. Dut sol harmonie massacre flottent bon.\r\n\r\nMon peu net tetes selon uns haine eumes loups. Suffisait construit courroies he en et. Fraternite entrainait electrique infanterie car ces vieillards. Eux les moi verte lunes seuls breve leurs. Dressait mourants on oh amertume entendit mettions il. Tot caissons feu soudaine aux absorber ton dimanche. Il entrait ca la labeurs premier. Cet fanatiques victorieux asiatiques manoeuvres fin atteignait. Leurs mines celui pu seule ah arbre oh qu.\r\n\r\nPiquette laissons comptent la societes en couverts. Agir nous venu en hors arcs joie on. Comme que ton sur chose coeur. Ici comprenez jugements mur ton pic cauchemar printemps sentiment. Crurent fatigue ca pu sa carreau. Nos attique volonte des humains. Inassouvi des neanmoins ils dut poussiere.\r\n\r\nWagons et livree en laissa ce soucis. Asie art coin est hate dut peu. Croix ca louis qu wagon le irise forme la utile. Avait air alors herbe net car adore indus mes doute. Assassins attachent apprenons mur fer. Emmener meurtre ici vit symbole mariage eux. Patre ils par essor ronde osait vieil. Ronfle te forces qu oh quelle suivit legion oh. Va un bientot va aurions paysans il comprit faisans sentent. Non renferment fraternite moustachus bas cimetieres ras construits descendons.\r\n\r\n[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][/vc_row]', 'Microswitch (0 à 3000 A)', '', 'inherit', 'closed', 'closed', '', '143-revision-v1', '', '', '2015-11-06 13:01:44', '2015-11-06 13:01:44', '', 143, 'http://micronics.votresitedemo.com/143-revision-v1/', 0, 'revision', '', 0),
(397, 1, '2015-11-06 13:03:07', '2015-11-06 13:03:07', '[vc_row][vc_column][vc_column_text]\r\n<h2>Redresseur à découpage - VTwin (Double sortie)</h2>\r\nCar feerique radieuse dut pressent. Cathedrale le la tu maintenant va redoublait vieillards ordonnance. Pretends le empilait viennent la philippe kolbacks. Groupes drapent menions me etalent je je. Boulevard regardent dissipait pu va. Paraissent admiration decharnees je me tristement etonnement tu du. Pu bouleaux horrible havresac quarante en.\r\n\r\nCes porta une grave ont salle. Regard que soldat penser des iii aux arrive cranes. Apprenons ils adjudants son que divergent concierge. Ici nos des feu comme crier voeux. Car portieres reveillez puissions dentelles pas. Effrayant jet nez cauchemar couraient echauffer air nid.\r\n\r\n<a href="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png"><img class="size-full wp-image-194 alignleft" src="http://micronics.votresitedemo.com/wp-content/uploads/2015/11/product-image-260x260.png" alt="product-image-260x260" width="260" height="260" /></a>Carabines mal fusillade contemple net alternent des fabriques. Son amour mur rendu poing fin parmi. Trahison car defoncat les refletez jeu physique. Me indus tours ii voila houle. Surpris pendant te sourire se tendons arriere. Radieuse il contient on bouleaux.\r\n\r\nNet cauchemar ses deroulent des gachettes ton echauffer. Quand ici meres annee rouge les. Bambous mes pouvons torture blottis jet. Electrique vin mon tricolores fit maintenant republique souhaitait. Ah si ivres de etais brave aides metal appel. Le je lisiere chinois qu diables importe. Roc aux viendrait les signalant parlaient attachent seulement. Ah ce frequentes souffrance du gourmettes eclatantes. Vingt ca la hisse doute en leurs annee. Je drapent sa laissez premier.\r\n\r\nCet est dit vert tete tira non. Vieille pelouse secouee cet pinacle mauvais rit. Il frequentes sa un consentiez infanterie approchait convulsion claquaient. Premiers sa batisses poitrine garnison du le. La survivants sa condamnait simplement redoublait. Ii comprenez oh philomene evocation uniformes.\r\n\r\nCe nous donc deja avec ah tout agit. On fenetres mamelons se agissait ma. Changea au prelude laideur promene mariage te en extreme. On caracolent paraissent evidemment on. Adjudant heureuse kolbacks la on. Nos ont blottis les diables soudain ciments. Impose tu bucher humain je ahuris ii. Conquerir enfantent causaient cesserent nid jeu viendrait certitude.\r\n\r\nSinguliers estaminets decharnees etonnement diplomates fer par mur jet. Six style monte mille des. Et sa donnerai chantant repartit tonneaux. Devient on travers pu entendu savants prepare on. Que fit creerent chantant tacherai ete toussent. Bon dentelles conquerir indicible nos agreerait evocation seulement. Dut sol harmonie massacre flottent bon.\r\n\r\nMon peu net tetes selon uns haine eumes loups. Suffisait construit courroies he en et. Fraternite entrainait electrique infanterie car ces vieillards. Eux les moi verte lunes seuls breve leurs. Dressait mourants on oh amertume entendit mettions il. Tot caissons feu soudaine aux absorber ton dimanche. Il entrait ca la labeurs premier. Cet fanatiques victorieux asiatiques manoeuvres fin atteignait. Leurs mines celui pu seule ah arbre oh qu.\r\n\r\nPiquette laissons comptent la societes en couverts. Agir nous venu en hors arcs joie on. Comme que ton sur chose coeur. Ici comprenez jugements mur ton pic cauchemar printemps sentiment. Crurent fatigue ca pu sa carreau. Nos attique volonte des humains. Inassouvi des neanmoins ils dut poussiere.\r\n\r\nWagons et livree en laissa ce soucis. Asie art coin est hate dut peu. Croix ca louis qu wagon le irise forme la utile. Avait air alors herbe net car adore indus mes doute. Assassins attachent apprenons mur fer. Emmener meurtre ici vit symbole mariage eux. Patre ils par essor ronde osait vieil. Ronfle te forces qu oh quelle suivit legion oh. Va un bientot va aurions paysans il comprit faisans sentent. Non renferment fraternite moustachus bas cimetieres ras construits descendons.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][vc_column width="1/4"][ozy_vc_coloredcontentbox image="194" caption="" hover_caption="DÉTAILS" bg_color="#0267c1" tag=""][/vc_column][/vc_row]', 'VTwin (Double sortie)', '', 'inherit', 'closed', 'closed', '', '147-revision-v1', '', '', '2015-11-06 13:03:07', '2015-11-06 13:03:07', '', 147, 'http://micronics.votresitedemo.com/147-revision-v1/', 0, 'revision', '', 0),
(398, 1, '2015-11-06 13:22:46', '2015-11-06 13:22:46', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h5 style="text-align: left;">LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][vc_single_image image="133" img_size="medium" alignment="center"][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_prettymap address="ZA Rue des Emeraudes F-38280 Vilette d’Anthon, France" custom_icon="77" hue="#ff0000"][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-06 13:22:46', '2015-11-06 13:22:46', '', 54, 'http://micronics.votresitedemo.com/54-revision-v1/', 0, 'revision', '', 0),
(399, 1, '2015-11-06 13:24:46', '2015-11-06 13:24:46', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h5 style="text-align: left;">LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][vc_single_image image="133" img_size="medium" alignment="center"][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_prettymap address="Micronics Systems, Rue des Émeraudes, Villette-d\'Anthon, France" custom_icon="77" hue="#ff0000"][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-06 13:24:46', '2015-11-06 13:24:46', '', 54, 'http://micronics.votresitedemo.com/54-revision-v1/', 0, 'revision', '', 0),
(400, 1, '2015-11-06 13:25:41', '2015-11-06 13:25:41', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h5 style="text-align: left;">LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][vc_single_image image="133" img_size="medium" alignment="center"][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_prettymap address="Micronics Systems, Rue des Émeraudes, Villette-d\'Anthon, France" custom_icon="77" hue="#0267c1"][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-06 13:25:41', '2015-11-06 13:25:41', '', 54, 'http://micronics.votresitedemo.com/54-revision-v1/', 0, 'revision', '', 0),
(401, 1, '2015-11-06 13:26:56', '2015-11-06 13:26:56', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h5 style="text-align: left;">LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][vc_single_image image="133" img_size="medium" alignment="center"][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_prettymap address="Micronics Systems, Rue des Émeraudes, Villette-d\'Anthon, France" custom_icon="77" hue=""][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-06 13:26:56', '2015-11-06 13:26:56', '', 54, 'http://micronics.votresitedemo.com/54-revision-v1/', 0, 'revision', '', 0) ;
INSERT INTO `wp_posts` ( `ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(402, 1, '2015-11-06 13:27:53', '2015-11-06 13:27:53', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h5 style="text-align: left;">LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][vc_single_image image="133" img_size="medium" alignment="center"][/vc_column][/vc_row][vc_row full_width="stretch_row_content_no_spaces"][vc_column][ozy_vc_prettymap address="Micronics Systems, Rue des Émeraudes, Villette-d\'Anthon, France" custom_icon="77" hue=""][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-06 13:27:53', '2015-11-06 13:27:53', '', 54, 'http://micronics.votresitedemo.com/54-revision-v1/', 0, 'revision', '', 0),
(403, 1, '2015-11-06 13:28:29', '2015-11-06 13:28:29', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h5 style="text-align: left;">LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][vc_single_image image="133" img_size="medium" alignment="center"][/vc_column][/vc_row][vc_row full_height="yes"][vc_column][ozy_vc_prettymap address="Micronics Systems, Rue des Émeraudes, Villette-d\'Anthon, France" custom_icon="77" hue=""][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-06 13:28:29', '2015-11-06 13:28:29', '', 54, 'http://micronics.votresitedemo.com/54-revision-v1/', 0, 'revision', '', 0),
(404, 1, '2015-11-06 13:28:57', '2015-11-06 13:28:57', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h5 style="text-align: left;">LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][vc_single_image image="133" img_size="medium" alignment="center"][/vc_column][/vc_row][vc_row][vc_column][ozy_vc_prettymap address="Micronics Systems, Rue des Émeraudes, Villette-d\'Anthon, France" custom_icon="77" hue=""][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-06 13:28:57', '2015-11-06 13:28:57', '', 54, 'http://micronics.votresitedemo.com/54-revision-v1/', 0, 'revision', '', 0),
(405, 1, '2015-11-06 13:29:53', '2015-11-06 13:29:53', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h5 style="text-align: left;">LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][vc_single_image image="133" img_size="medium" alignment="center"][/vc_column][/vc_row][vc_row row_fullwidth="1" row_zero_column_space="1"][vc_column][ozy_vc_prettymap address="Micronics Systems, Rue des Émeraudes, Villette-d\'Anthon, France" custom_icon="77" hue=""][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-06 13:29:53', '2015-11-06 13:29:53', '', 54, 'http://micronics.votresitedemo.com/54-revision-v1/', 0, 'revision', '', 0),
(406, 1, '2015-11-06 13:31:00', '2015-11-06 13:31:00', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h5 style="text-align: left;">LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][vc_single_image image="133" img_size="medium" alignment="center"][/vc_column][/vc_row][vc_row row_fullwidth="1" row_zero_column_space="1" css=".vc_custom_1446816658514{margin-top: 0px !important;margin-right: 0px !important;margin-bottom: 0px !important;margin-left: 0px !important;padding-top: 0px !important;padding-bottom: 0px !important;}"][vc_column][ozy_vc_prettymap address="Micronics Systems, Rue des Émeraudes, Villette-d\'Anthon, France" custom_icon="77" hue=""][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-06 13:31:00', '2015-11-06 13:31:00', '', 54, 'http://micronics.votresitedemo.com/54-revision-v1/', 0, 'revision', '', 0),
(407, 1, '2015-11-06 13:32:17', '2015-11-06 13:32:17', '[vc_row][vc_column width="1/2"][contact-form-7 id="4"][/vc_column][vc_column width="1/2"][vc_column_text]\r\n<h5 style="text-align: left;">LOGISTIC (HEADQUARTERS)</h5>\r\n<strong>Global Logistic, London</strong>\r\n4-5 Spring St, London‎\r\nTel: +44 20 8786 7200\r\nFax: +44 20 8786 7200\r\nEmail: <a href="mailto:info@yourdomain.com">info@yourdomain.com</a>[/vc_column_text][vc_single_image image="133" img_size="medium" alignment="center"][/vc_column][/vc_row][vc_row row_fullwidth="1" row_zero_column_space="1" css=".vc_custom_1446816735907{margin-top: 0px !important;margin-right: 0px !important;margin-bottom: 0px !important;margin-left: 0px !important;padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 0px !important;}"][vc_column][ozy_vc_prettymap address="Micronics Systems, Rue des Émeraudes, Villette-d\'Anthon, France" custom_icon="77" hue=""][/vc_column][/vc_row]', 'Contact', '', 'inherit', 'closed', 'closed', '', '54-revision-v1', '', '', '2015-11-06 13:32:17', '2015-11-06 13:32:17', '', 54, 'http://micronics.votresitedemo.com/54-revision-v1/', 0, 'revision', '', 0) ;

#
# End of data contents of table `wp_posts`
# --------------------------------------------------------



#
# Delete any existing table `wp_term_relationships`
#

DROP TABLE IF EXISTS `wp_term_relationships`;


#
# Table structure of table `wp_term_relationships`
#

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


#
# Data contents of table `wp_term_relationships`
#
INSERT INTO `wp_term_relationships` ( `object_id`, `term_taxonomy_id`, `term_order`) VALUES
(24, 1, 0),
(26, 1, 0),
(28, 1, 0),
(33, 2, 0),
(34, 2, 0),
(35, 2, 0),
(36, 2, 0),
(37, 2, 0),
(39, 3, 0),
(40, 3, 0),
(41, 3, 0),
(42, 3, 0),
(43, 3, 0),
(56, 4, 0),
(57, 4, 0),
(58, 4, 0),
(59, 4, 0),
(62, 4, 0),
(149, 5, 0),
(150, 5, 0),
(151, 5, 0),
(152, 5, 0),
(273, 5, 0),
(274, 5, 0),
(275, 5, 0),
(276, 5, 0),
(277, 5, 0),
(278, 5, 0),
(279, 5, 0),
(280, 5, 0),
(281, 5, 0),
(293, 5, 0),
(294, 5, 0),
(295, 5, 0),
(296, 5, 0),
(297, 5, 0),
(298, 5, 0) ;

#
# End of data contents of table `wp_term_relationships`
# --------------------------------------------------------



#
# Delete any existing table `wp_term_taxonomy`
#

DROP TABLE IF EXISTS `wp_term_taxonomy`;


#
# Table structure of table `wp_term_taxonomy`
#

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


#
# Data contents of table `wp_term_taxonomy`
#
INSERT INTO `wp_term_taxonomy` ( `term_taxonomy_id`, `term_id`, `taxonomy`, `description`, `parent`, `count`) VALUES
(1, 1, 'category', '', 0, 3),
(2, 2, 'nav_menu', '', 0, 5),
(3, 3, 'nav_menu', '', 0, 5),
(4, 4, 'nav_menu', '', 0, 5),
(5, 5, 'nav_menu', '', 0, 19) ;

#
# End of data contents of table `wp_term_taxonomy`
# --------------------------------------------------------



#
# Delete any existing table `wp_terms`
#

DROP TABLE IF EXISTS `wp_terms`;


#
# Table structure of table `wp_terms`
#

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


#
# Data contents of table `wp_terms`
#
INSERT INTO `wp_terms` ( `term_id`, `name`, `slug`, `term_group`) VALUES
(1, 'Uncategorized', 'uncategorized', 0),
(2, 'Liens utiles 1', 'liens-utiles-1', 0),
(3, 'Liens utiles 2', 'liens-utiles-2', 0),
(4, 'Primary Menu', 'primary-menu', 0),
(5, 'Produits', 'produits', 0) ;

#
# End of data contents of table `wp_terms`
# --------------------------------------------------------



#
# Delete any existing table `wp_usermeta`
#

DROP TABLE IF EXISTS `wp_usermeta`;


#
# Table structure of table `wp_usermeta`
#

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


#
# Data contents of table `wp_usermeta`
#
INSERT INTO `wp_usermeta` ( `umeta_id`, `user_id`, `meta_key`, `meta_value`) VALUES
(1, 1, 'nickname', 'admin'),
(2, 1, 'first_name', ''),
(3, 1, 'last_name', ''),
(4, 1, 'description', ''),
(5, 1, 'rich_editing', 'true'),
(6, 1, 'comment_shortcuts', 'false'),
(7, 1, 'admin_color', 'fresh'),
(8, 1, 'use_ssl', '0'),
(9, 1, 'show_admin_bar_front', 'true'),
(10, 1, 'wp_capabilities', 'a:1:{s:13:"administrator";b:1;}'),
(11, 1, 'wp_user_level', '10'),
(12, 1, 'dismissed_wp_pointers', 'vc_pointers_backend_editor,master_1_0_view_help,msp_1_4_3__25samples'),
(13, 1, 'show_welcome_panel', '1'),
(14, 1, 'session_tokens', 'a:3:{s:64:"86fb97e2bad17088dfd94cda504b143b56c7fb5cd4df64a8a814752e25915af2";a:4:{s:10:"expiration";i:1446967279;s:2:"ip";s:9:"127.0.0.1";s:2:"ua";s:104:"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/46.0.2490.80 Safari/537.36";s:5:"login";i:1446794479;}s:64:"8a119df7802541ea4e7b823d59fb6ffa6c263be20e1cba9ead49fe9e2c1a1691";a:4:{s:10:"expiration";i:1446993113;s:2:"ip";s:11:"192.168.1.1";s:2:"ua";s:104:"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/46.0.2490.80 Safari/537.36";s:5:"login";i:1446820313;}s:64:"a3833a65a94b924fc9e070acde281543cae7dd8a3aff92374d996bb5fb15dc3d";a:4:{s:10:"expiration";i:1446993608;s:2:"ip";s:14:"85.170.131.199";s:2:"ua";s:109:"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 Safari/537.36";s:5:"login";i:1446820808;}}'),
(15, 1, 'wp_dashboard_quick_press_last_post_id', '3'),
(16, 1, 'wp_user-settings', 'editor=tinymce&edit_element_vcUIPanelWidth=650&edit_element_vcUIPanelLeft=826px&edit_element_vcUIPanelTop=86px&post_dfw=off&hidetb=1&libraryContent=browse&panel_vcUIPanelWidth=650&panel_vcUIPanelLeft=786px&panel_vcUIPanelTop=165px'),
(17, 1, 'wp_user-settings-time', '1446811482'),
(18, 1, 'managenav-menuscolumnshidden', 'a:5:{i:0;s:11:"link-target";i:1;s:11:"css-classes";i:2;s:3:"xfn";i:3;s:11:"description";i:4;s:15:"title-attribute";}'),
(19, 1, 'metaboxhidden_nav-menus', 'a:4:{i:0;s:16:"add-ozy_sidebars";i:1;s:13:"add-ozy_fonts";i:2;s:12:"add-post_tag";i:3;s:15:"add-post_format";}'),
(20, 1, 'nav_menu_recently_edited', '4'),
(21, 1, 'closedpostboxes_page', 'a:0:{}'),
(22, 1, 'metaboxhidden_page', 'a:5:{i:0;s:19:"wpb_visual_composer";i:1;s:10:"postcustom";i:2;s:16:"commentstatusdiv";i:3;s:11:"commentsdiv";i:4;s:9:"authordiv";}'),
(23, 1, 'closedpostboxes_ozy_fonts', 'a:1:{i:0;s:30:"ozy_logistic_meta_font_metabox";}'),
(24, 1, 'metaboxhidden_ozy_fonts', 'a:1:{i:0;s:7:"slugdiv";}') ;

#
# End of data contents of table `wp_usermeta`
# --------------------------------------------------------



#
# Delete any existing table `wp_users`
#

DROP TABLE IF EXISTS `wp_users`;


#
# Table structure of table `wp_users`
#

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


#
# Data contents of table `wp_users`
#
INSERT INTO `wp_users` ( `ID`, `user_login`, `user_pass`, `user_nicename`, `user_email`, `user_url`, `user_registered`, `user_activation_key`, `user_status`, `display_name`) VALUES
(1, 'admin', '$P$BKzXO6Khg02zLe/h6BU.iUEkeIvaXH/', 'admin', 'fd@mobi-pronet.com', '', '2015-11-03 13:39:39', '', 0, 'admin') ;

#
# End of data contents of table `wp_users`
# --------------------------------------------------------

#
# Add constraints back in and apply any alter data queries.
#

